/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.jinzuan.cmd.grow;

import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.jinzuan.cmd.DefaultCmd;
import com.xunlei.niux.jinzuan.service.GrowDutyReceiveInfoService;
import com.xunlei.niux.jinzuan.service.JinZuanService;
import com.xunlei.niux.jinzuan.util.IpUtil;
import com.xunlei.util.Log;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class GrowDutyReceiveCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(GrowDutyReceiveCmd.class.getName());
    private static final String bonusKey = "6f5aadf0-8aa7-41bf-bcd1-74eab17dd9b5";

    @CmdMapper(value={"/grow/querygrowdutyreceiveinfo.do"})
    public Object queryGrowDutyReceiveInfo(XLHttpRequest request, XLHttpResponse response) {
        JinZuanService jinZuanService = new JinZuanService();
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String uid = request.getParameter("uid");
        try {
            String myip = request.getRemoteIP();
            if (!IpUtil.getInstance().validateIp(myip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(10, "\u65e0\u6548ip");
            }
            if (StringTools.isEmpty(uid)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            MemberShip memberShip = jinZuanService.getMemberShip(uid);
            if (!jinZuanService.isJinzuanMembership(memberShip)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(7, "\u60a8\u975e\u91d1\u94bb\u4f1a\u5458");
            }
            if (jinZuanService.isJinzuanExpire(memberShip)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(8, "\u60a8\u7684\u91d1\u94bb\u4f1a\u5458\u7279\u6743\u5df2\u8fc7\u671f");
            }
            GrowDutyReceiveInfoService receiveInfoService = new GrowDutyReceiveInfoService();
            List<Map<String, Object>> result = receiveInfoService.getGrowDutyReceiveInfo(uid);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (XLRuntimeException ee) {
            logger.info("jinzuan querygrowdutyreceiveinfo querygrowdutyreceiveinfo.do error uid=" + uid + ",reason=" + ee.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u672a\u77e5\u5f02\u5e38");
        }
        catch (Exception e) {
            logger.info("jinzuan querygrowdutyreceiveinfo querygrowdutyreceiveinfo.do error uid=" + uid + ",reason=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/grow/receivegrowdutybonus.do"})
    public Object receiveGrowDutyBonus(XLHttpRequest request, XLHttpResponse response) {
        JinZuanService jinZuanService = new JinZuanService();
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String uid = request.getParameter("uid");
        String jinzuanLevel = request.getParameter("jinzuanLevel");
        String timestamp = request.getParameter("timestamp");
        try {
            long timestamp0;
            String sign = request.getParameter("sign");
            logger.info("jinzuan receivegrowdutybonus receivegrowdutybonus.do uid=" + uid + "timestamp=" + timestamp + ",sign=" + sign);
            String myip = request.getRemoteIP();
            if (!IpUtil.getInstance().validateIp(myip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(10, "\u65e0\u6548ip");
            }
            if (StringTools.isEmpty(uid) || StringTools.isEmpty(timestamp) || StringTools.isEmpty(sign)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            String md5msg = uid + timestamp + jinzuanLevel + bonusKey;
            String mysign = Md5Encrypt.md5(md5msg);
            if (!sign.trim().equals(mysign)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7b7e\u540d\u9519\u8bef");
            }
            long mytimestamp = System.currentTimeMillis() / 1000L;
            if (mytimestamp - (timestamp0 = Long.parseLong(timestamp)) >= 900L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u8bf7\u6c42\u8d85\u65f6");
            }
            MemberShip memberShip = jinZuanService.getMemberShip(uid);
            if (!jinZuanService.isJinzuanMembership(memberShip)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(7, "\u60a8\u975e\u91d1\u94bb\u4f1a\u5458");
            }
            if (jinZuanService.isJinzuanExpire(memberShip)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(8, "\u60a8\u7684\u91d1\u94bb\u4f1a\u5458\u7279\u6743\u5df2\u8fc7\u671f");
            }
            GrowDutyReceiveInfoService receiveInfoService = new GrowDutyReceiveInfoService();
            if (!receiveInfoService.isMatchJinzuanLevel(memberShip, Integer.parseInt(jinzuanLevel))) {
                return JsonObjectUtil.getRtnAndDataJsonObject(9, "\u60a8\u8fd8\u672a\u8fbe\u5230\u89c4\u5b9a\u7684\u91d1\u94bb\u7b49\u7ea7");
            }
            if (receiveInfoService.isReceivedDuty(uid, Integer.parseInt(jinzuanLevel))) {
                return JsonObjectUtil.getRtnAndDataJsonObject(10, "\u60a8\u5df2\u9886\u53d6\u8fc7\u8be5\u7b49\u7ea7\u4efb\u52a1\u5956\u52b1");
            }
            receiveInfoService.recordDutyInfo(uid, Integer.parseInt(jinzuanLevel));
            return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u9886\u53d6\u6210\u529f");
        }
        catch (XLRuntimeException ee) {
            logger.info("jinzuan querygrowdutyreceiveinfo querygrowdutyreceiveinfo.do error uid=" + uid + ",reason=" + ee.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u672a\u77e5\u5f02\u5e38");
        }
        catch (Exception e) {
            logger.info("jinzuan querygrowdutyreceiveinfo querygrowdutyreceiveinfo.do error uid=" + uid + ",reason=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    public static void main(String[] args) {
        String uid = "123540516";
        long timestamp = System.currentTimeMillis();
        String jinzuanLevel = "1";
        String md5msg = uid + timestamp + jinzuanLevel + bonusKey;
        String mysign = Md5Encrypt.md5(md5msg);
        String url = "http://localhost:9090/grow/receivegrowdutybonus.do?";
        System.out.println(url + "uid=" + uid + "&timestamp=" + timestamp + "&jinzuanLevel=" + jinzuanLevel + "&sign=" + mysign);
        System.out.println(mysign);
    }
}

