/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.jinzuan.cmd.grow;

import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.jinzuan.cmd.DefaultCmd;
import com.xunlei.niux.jinzuan.so.RewardEnum;
import com.xunlei.niux.jinzuan.so.RewardFactory;
import com.xunlei.niux.jinzuan.util.IpUtil;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import java.util.HashMap;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class GrowCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(GrowCmd.class.getName());
    private static final String growkey = "94eea20d-7b37-4021-8edf-0cea8e6cb342";

    @CmdMapper(value={"/grow/use.do"})
    public Object usePrivilege(XLHttpRequest request, XLHttpResponse response) {
        String uid = request.getParameter("uid");
        try {
            long timestampl;
            long mytimestamp;
            String ptype = request.getParameter("ptype");
            String sourceId = request.getParameter("sourceId");
            String money = request.getParameter("money");
            String growValue = request.getParameter("growValue");
            String timestamp = request.getParameter("timestamp");
            String months = request.getParameter("months");
            String sign = request.getParameter("sign");
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            String ip = request.getRemoteIP();
            logger.info("jinzuan grow use.do ptype=" + ptype + ",uid=" + uid + ",sourceId=" + sourceId + ",money=" + money + ",ip=" + ip + ",timestamp=" + timestamp + ",sign=" + sign);
            if (!IpUtil.getInstance().validateIp(ip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(7, "\u65e0\u6548ip");
            }
            if (StringTools.isEmpty(uid) || StringTools.isEmpty(ptype) || StringTools.isEmpty(sign) || StringTools.isEmpty(timestamp)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            int type = Integer.parseInt(ptype);
            String msg = uid + ptype + timestamp + growkey;
            String mysign = Md5Encrypt.md5(msg);
            if (!sign.trim().equals(mysign)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u6570\u5b57\u7b7e\u540d\u9519\u8bef");
            }
            if (type != 1 && type != 4 && type != 5 && (mytimestamp = System.currentTimeMillis() / 1000L) - (timestampl = Long.parseLong(timestamp)) >= 900L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u8be5\u8bf7\u6c42\u5df2\u8d85\u65f6");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("uid", Long.parseLong(uid));
            map.put("sourceId", sourceId);
            map.put("ip", ip);
            switch (type) {
                case 1: {
                    RewardFactory.getInstance().getReward(RewardEnum.DailyReward, map);
                    break;
                }
                case 2: {
                    if (StringTools.isEmpty(months)) {
                        return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
                    }
                    map.put("months", Integer.parseInt(months));
                    RewardFactory.getInstance().getReward(RewardEnum.FirstPayReward, map);
                    break;
                }
                case 3: {
                    if (StringTools.isEmpty(money)) {
                        return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
                    }
                    map.put("money", Double.parseDouble(money));
                    RewardFactory.getInstance().getReward(RewardEnum.PayReward, map);
                    break;
                }
                case 5: {
                    RewardFactory.getInstance().getReward(RewardEnum.ExpireReward, map);
                    break;
                }
                case 6: {
                    if (StringTools.isEmpty(growValue)) {
                        return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
                    }
                    map.put("growValue", Long.parseLong(growValue));
                    RewardFactory.getInstance().getReward(RewardEnum.ActAward, map);
                    break;
                }
                default: {
                    return JsonObjectUtil.getRtnAndDataJsonObject(6, "\u589e\u957f\u7c7b\u578b\u4e0d\u6b63\u786e");
                }
            }
            logger.info("jinzuan grow use.do success ptype=" + ptype + ",uid=" + uid + ",sourceId=" + sourceId + ",money=" + money + ",timestamp=" + timestamp + ",sign=" + sign);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u4f7f\u7528\u6210\u529f");
        }
        catch (XLRuntimeException ee) {
            logger.error("use.do exception.uid=" + uid + ",reason:" + ee.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(2, ee.getMessage());
        }
        catch (Exception e) {
            logger.error("use.do exception.uid=" + uid + ",reason:" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u7f51\u7edc\u5f02\u5e38");
        }
    }
}

