/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.client.vip;

import com.xunlei.niux.client.util.PropertiesReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheVipClient {
    private static Map<String, String> uRLConfigMap = new HashMap<String, String>();
    private static PropertiesReader pu;
    private static Log logger;

    static {
        logger = LogFactory.getLog(CacheVipClient.class);
        try {
            pu = new PropertiesReader("niuxclient.properties");
            CacheVipClient.loadVIPConfig();
        }
        catch (IOException e) {
            logger.error("read niuxclient.properties Exception", e);
        }
    }

    private static void loadVIPConfig() {
        try {
            uRLConfigMap.put("first_vipcache_host", pu.getProperty("first_vipcache_host"));
            uRLConfigMap.put("first_vipcache_port", pu.getProperty("first_vipcache_port"));
            uRLConfigMap.put("first_vipcache_timeout", pu.getProperty("first_vipcache_timeout"));
            uRLConfigMap.put("second_vipcache_host", pu.getProperty("second_vipcache_host"));
            uRLConfigMap.put("second_vipcache_port", pu.getProperty("second_vipcache_port"));
            uRLConfigMap.put("second_vipcache_timeout", pu.getProperty("second_vipcache_timeout"));
            uRLConfigMap.put("third_vipcache_host", pu.getProperty("third_vipcache_host"));
            uRLConfigMap.put("third_vipcache_port", pu.getProperty("third_vipcache_port"));
            uRLConfigMap.put("third_vipcache_timeout", pu.getProperty("third_vipcache_timeout"));
            uRLConfigMap.put("protocol_version", pu.getProperty("protocol_version"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Map<String, String> getVipInfoMap(String userid, String sessionId) {
        return CacheVipClient.getVIPBackInfoMap(userid, sessionId);
    }

    private static String getURLPart(int type) {
        String host = "";
        String port = "";
        String urlPart = "";
        switch (type) {
            case 1: {
                host = uRLConfigMap.get("first_vipcache_host");
                port = uRLConfigMap.get("first_vipcache_port");
                break;
            }
            case 2: {
                host = uRLConfigMap.get("second_vipcache_host");
                port = uRLConfigMap.get("second_vipcache_port");
                break;
            }
            case 3: {
                host = uRLConfigMap.get("third_vipcache_host");
                port = uRLConfigMap.get("third_vipcache_port");
                break;
            }
        }
        urlPart = "http://" + host + ":" + port + "/";
        logger.info("urlPart : " + urlPart);
        return urlPart;
    }

    private static Map<String, String> getVIPBackInfoMap(String userId, String sessionid) {
        try {
            return CacheVipClient.getVIPBackInfoMap(userId, 1, sessionid);
        }
        catch (Exception e) {
            try {
                return CacheVipClient.getVIPBackInfoMap(userId, 2, sessionid);
            }
            catch (Exception e2) {
                try {
                    return CacheVipClient.getVIPBackInfoMap(userId, 3, sessionid);
                }
                catch (Exception e3) {
                    logger.error("getVIPBackInfoMap Exception", e);
                    return null;
                }
            }
        }
    }

    private static Map<String, String> getVIPBackInfoMap(String userId, int type, String sessionid) {
        String retXml = "";
        HttpURLConnection httpURLConnection = null;
        String timeout = null;
        String url = null;
        try {
            String version = uRLConfigMap.get("protocol_version");
            url = CacheVipClient.getVIPInfoUrl(userId, type, true, version, sessionid);
            switch (type) {
                case 1: {
                    timeout = uRLConfigMap.get("first_vipcache_timeout");
                    break;
                }
                case 2: {
                    timeout = uRLConfigMap.get("second_vipcache_timeout");
                    break;
                }
                case 3: {
                    timeout = uRLConfigMap.get("third_vipcache_timeout");
                    break;
                }
                default: {
                    throw new RuntimeException("getVIPBackInfoMap get invalid type");
                }
            }
            URL urlConnect = new URL(url);
            httpURLConnection = (HttpURLConnection)urlConnect.openConnection();
            httpURLConnection.setConnectTimeout(Integer.valueOf(timeout));
            BufferedReader in = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
            String line = null;
            while ((line = in.readLine()) != null) {
                retXml = String.valueOf(retXml) + line;
            }
            in.close();
            logger.info("retXml=" + retXml);
            Map<String, String> backMap = CacheVipClient.parseMap(retXml, "&");
            return backMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, String> parseMap(String retxml, String splitString) {
        HashMap<String, String> backMap = new HashMap<String, String>();
        try {
            String[] resultStrings = retxml.split(splitString);
            ArrayList<String> resultList = new ArrayList<String>(resultStrings.length);
            int i = 0;
            while (i < resultStrings.length) {
                resultList.add(i, resultStrings[i]);
                ++i;
            }
            for (String indexString : resultList) {
                backMap.put(indexString.split("=")[0], indexString.split("=")[1]);
            }
        }
        catch (Exception e) {
            logger.error("parseMap Exception", e);
        }
        return backMap;
    }

    private static String getVIPInfoUrl(String userId, int type, boolean secure, String protocol_version, String sessionid) {
        String urlPart = CacheVipClient.getURLPart(type);
        String url = String.valueOf(urlPart) + "cache?userid=" + userId + "&protocol_version=" + protocol_version + "&secure=" + secure + "&sessionid=" + sessionid;
        logger.info("VIP URL=:  " + url);
        return url;
    }
}

