/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.client.jinzuan;

import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.client.util.SignUtil;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class CommonActivityClient {
    private static final Logger logger = Log.getLogger(CommonActivityClient.class);
    private static final String ActivityUrl = "http://activity.niu.xunlei.com:8090/commonactivity/";
    private static final String authId = EnvPropertyUtil.loadProperty("niuxclient", "CommonActivityClient_authId");
    private static final String SignKey = EnvPropertyUtil.loadProperty("niuxclient", "CommonActivityClient_SignKey");

    public static String isUserCanUseActAllModule(String actNo, String moduleId, String userId) {
        String url = "http://activity.niu.xunlei.com:8090/commonactivity/isUserCanUseActAllModule.do?";
        url = String.valueOf(url) + "actno=" + actNo + "&userid=" + userId;
        if (StringUtils.isNotEmpty(moduleId)) {
            url = String.valueOf(url) + "&moduleid=" + moduleId;
        }
        url = String.valueOf(url) + "&isJinZuan=1";
        logger.info("isUserCanUseActAllModule request URL: " + url);
        String resp = HttpClientUtil.get(url);
        logger.info("isUserCanUseActAllModule request response: " + resp);
        return resp;
    }

    public static String getGift(String actNo, String moduleId, String userId, String giftId, String remoteIp) {
        return CommonActivityClient.getGift(actNo, moduleId, userId, giftId, remoteIp, true);
    }

    public static String getGift(String actNo, String moduleId, String userId, String giftId, String remoteIp, boolean isJinzuan) {
        String url = "http://activity.niu.xunlei.com:8090/commonactivity/getGift_v2.do?";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userid", userId);
        param.put("actno", actNo);
        if (!StringUtils.isEmpty(moduleId)) {
            param.put("moduleid", moduleId);
        }
        if (!StringUtils.isEmpty(remoteIp)) {
            param.put("ip", remoteIp);
        }
        param.put("isjinzuan", isJinzuan ? "1" : "0");
        param.put("authid", authId);
        param.put("giftid", giftId);
        Random random = new Random(System.currentTimeMillis());
        String orderId = String.valueOf(actNo) + System.currentTimeMillis() / 1000L + random.nextInt(100000);
        param.put("orderid", orderId);
        String sign = SignUtil.sign(param, SignKey);
        param.put("sign", sign);
        String paramStr = SignUtil.getSignatureContent(param);
        url = String.valueOf(url) + paramStr;
        logger.info("getGift request URL: " + url);
        String resp = HttpClientUtil.get(url);
        logger.info("getGift request response: " + resp);
        return resp;
    }

    public static String getGiftInfoList(String actNo, String moduleId) {
        String url = "http://activity.niu.xunlei.com:8090/commonactivity/getGiftInfo.do?";
        url = String.valueOf(url) + "actno=" + actNo;
        if (StringUtils.isNotEmpty(moduleId)) {
            url = String.valueOf(url) + "&moduleid=" + moduleId;
        }
        logger.info("getGiftInfoList request URL: " + url);
        String resp = HttpClientUtil.get(url);
        logger.info("getGiftInfoList request response: " + resp);
        return resp;
    }

    public static String isGameHasGiftPackage(String gameId) {
        String url = "http://activity.niu.xunlei.com:8090/commonactivity/isGameHasGiftPackage.do?";
        url = String.valueOf(url) + "gameid=" + gameId;
        logger.info("isGameHasGiftPackage request URL: " + url);
        String resp = HttpClientUtil.get(url);
        logger.info("isGameHasGiftPackage request response: " + resp);
        return resp;
    }

    public static String getGiftRecords(String actNo, String moduleId, String userId, int max) {
        String url = "http://activity.niu.xunlei.com:8090/commonactivity/getGiftRecords.do?";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("actno", actNo);
        paramMap.put("moduleid", moduleId);
        paramMap.put("userId", userId);
        paramMap.put("max", String.valueOf(max));
        url = String.valueOf(url) + SignUtil.getSignatureContent(paramMap);
        logger.info("getGiftRecords request URL: " + url);
        String resp = HttpClientUtil.get(url);
        logger.info("getGiftRecords request response: " + resp);
        return resp;
    }

    public static String getGiftRecordsWithPhoto(String actNo, String moduleId, String userId, int max) {
        String url = "http://activity.niu.xunlei.com:8090/commonactivity/getGiftRecordsWithPhoto.do?";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("actno", actNo);
        paramMap.put("moduleid", moduleId);
        paramMap.put("userId", userId);
        paramMap.put("max", String.valueOf(max));
        url = String.valueOf(url) + SignUtil.getSignatureContent(paramMap);
        logger.info("getGiftRecordsWithPhoto request URL: " + url);
        String resp = HttpClientUtil.get(url);
        logger.info("getGiftRecordsWithPhoto request response: " + resp);
        return resp;
    }
}

