/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.client.card;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.client.util.MapEasyUtils;
import com.xunlei.niux.client.util.SignUtil;
import com.xunlei.niux.client.util.StringUtil;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;

public class CardClient {
    private static Logger logger = Log.getLogger(CardClient.class);
    private static String card_url = EnvPropertyUtil.loadProperty("niux", "card_url");
    private static String newCard_url = EnvPropertyUtil.loadProperty("niuxclient", "newcard_url");
    private static final String KEY = "febd6f8dft3e412d4beb69c68ed41e";
    public static final String GIFT = "gift";
    public static final String CARD = "card";

    public static String sender(String gameid, String serverid, String type, String batid, long userid, String username, boolean getmore) {
        if (StringUtil.isEmpty(gameid, serverid, type, batid, username)) {
            throw new NullPointerException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!GIFT.equals(type) && !CARD.equals(type)) {
            throw new IllegalArgumentException("type value must be gift or card");
        }
        String sign = SignUtil.sign(String.valueOf(gameid) + serverid + username + userid, KEY);
        String url = String.format(card_url, gameid, serverid, type, batid, userid, username, sign, getmore);
        logger.debug("\u65b0\u624b\u5361\u63a5\u53e3url:{}", (Object)url);
        return HttpClientUtil.get(url);
    }

    public static String getCardCode(String gameid, String serverid, String type, String batid, long userid, String username, boolean getmore) {
        String code = null;
        try {
            String reslut = CardClient.sender(gameid, serverid, type, batid, userid, username, getmore);
            ObjectMapper mapper = new ObjectMapper();
            Map map = mapper.readValue(reslut, Map.class);
            if ((Integer)map.get("code") == 0) {
                code = map.get("result").toString();
            } else {
                logger.warn("\u83b7\u53d6\u6fc0\u6d3b\u7801\u9519\u8bef:{}", (Object)reslut);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6fc0\u6d3b\u7801\u5f02\u5e38", e);
        }
        return code;
    }

    public static String getCardCode22(String gameid, String serverid, String type, String batid, long userid, String username, boolean getmore) {
        try {
            String reslut = CardClient.sender(gameid, serverid, type, batid, userid, username, getmore);
            ObjectMapper mapper = new ObjectMapper();
            Map map = mapper.readValue(reslut, Map.class);
            Integer code = (Integer)map.get("code");
            if (code == 0 || code == 2) {
                String cardNo = map.get("result").toString();
                return cardNo;
            }
            String message = (String)map.get("message");
            if (code == -2) {
                throw new NiuRuntimeException("1030", message);
            }
            if (message.contains("\u6682\u65e0\u65b0\u624b\u5361")) {
                throw new NiuRuntimeException("1017", "\u6ca1\u6709\u793c\u5305\u6216\u5df2\u5151\u6362\u5b8c");
            }
            throw new NiuRuntimeException("99", message);
        }
        catch (NiuRuntimeException e) {
            logger.error("\u83b7\u53d6\u6fc0\u6d3b\u7801\u5f02\u5e38", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6fc0\u6d3b\u7801\u5f02\u5e38", e);
            throw new NiuRuntimeException("99", e);
        }
    }

    public static Map<String, Object> getNewCardBatIdByGameId(String gameId) {
        String url = String.valueOf(newCard_url) + "action=getGameBatchId&gameId=" + gameId;
        logger.info("getNewCardBatIdByGameId request url:" + url);
        String resp = HttpClientUtil.get(url);
        logger.info("getNewCardBatIdByGameId response result:" + resp);
        JsonObject jsonObject = new JsonParser().parse(resp).getAsJsonObject();
        int code = jsonObject.get("code").getAsInt();
        if (code != 0) {
            return MapEasyUtils.generateMap(code, jsonObject.get("message").getAsString());
        }
        return MapEasyUtils.generateMap(code, jsonObject.get("result").getAsString());
    }

    public static CardClientResult getResult(String gameid, String serverid, String type, String batid, long userid, String username, boolean getmore) {
        CardClientResult result = new CardClientResult();
        try {
            String strReslut = CardClient.sender(gameid, serverid, type, batid, userid, username, getmore);
            ObjectMapper mapper = new ObjectMapper();
            Map map = mapper.readValue(strReslut, Map.class);
            Integer code = (Integer)map.get("code");
            result.setCode(code);
            result.setMessage(map.get("message").toString());
            if (code == 0 || 2 == code) {
                result.setResult(map.get("result").toString());
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6fc0\u6d3b\u7801\u5f02\u5e38", e);
            result = null;
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(CardClient.getCardCode("00087", "1", GIFT, "49", 246880500L, "246880500", false));
    }

    public static class CardClientResult {
        public static final int SUCCESS_CODE = 0;
        public static final int HAS_SUCCESS_CODE = 2;
        public static final int NONE_CODE = -99;
        public static final int NO_PLAY = -2;
        private int code;
        private String message;
        private String result;

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }
    }
}

