/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.client.bonus;

import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.client.util.JsonUtil;
import com.xunlei.niux.client.util.SignUtil;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.dto.UserBonus;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import java.util.HashMap;
import java.util.Map;

public class BonusClient {
    private static String bizNo = EnvPropertyUtil.loadProperty("bonus", "bonusbizno");
    private static String bizPwd = EnvPropertyUtil.loadProperty("bonus", "bonusbizpwd");
    private static String bonusUrl = EnvPropertyUtil.loadProperty("bonus", "bonusurl");

    public static String consume(String userId, String userName, int transNum, String transNo, String balanceDate, String actNo, String gameId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        param.put("userName", userName);
        param.put("transNum", String.valueOf(transNum));
        param.put("transNo", transNo);
        param.put("bizNo", bizNo);
        param.put("balanceDate", balanceDate);
        param.put("actNo", actNo == null ? "" : actNo);
        param.put("gameId", gameId == null ? "" : gameId);
        String sign = SignUtil.sign(param, bizPwd);
        String str = SignUtil.getSignatureContent(param);
        str = String.valueOf(str) + "&sign=" + sign;
        String resp = HttpClientUtil.get(String.valueOf(bonusUrl) + "/consume.do?" + str);
        if (resp.contains("\"code\":\"00\"")) {
            return "00";
        }
        if (resp.contains("\"code\":\"1001\"")) {
            return "00";
        }
        if (resp.contains("\"code\":\"1020\"")) {
            return "1020";
        }
        if (resp.contains("\"code\":\"1021\"")) {
            return "1021";
        }
        if (resp.contains("\"code\":\"1022\"")) {
            return "1022";
        }
        throw new RuntimeException(resp);
    }

    public static void recharge(String userId, String userName, int transNum, String transNo, String balanceDate, String actNo) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        param.put("userName", userName);
        param.put("transNum", String.valueOf(transNum));
        param.put("transNo", transNo);
        param.put("bizNo", bizNo);
        param.put("balanceDate", balanceDate);
        param.put("actNo", actNo == null ? "" : actNo);
        String sign = SignUtil.sign(param, bizPwd);
        String str = SignUtil.getSignatureContent(param);
        str = String.valueOf(str) + "&sign=" + sign;
        String resp = HttpClientUtil.get(String.valueOf(bonusUrl) + "/recharge.do?" + str);
        if (resp.contains("\"code\":\"00\"")) {
            return;
        }
        if (resp.contains("\"code\":\"1001\"")) {
            return;
        }
        throw new RuntimeException(resp);
    }

    public static void recharge(String userId, String userName, int transNum, String transNo, String balanceDate, String p_bizNo, String p_bizPwd, String remark) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        param.put("userName", userName);
        param.put("transNum", String.valueOf(transNum));
        param.put("transNo", transNo);
        param.put("bizNo", p_bizNo);
        param.put("balanceDate", balanceDate);
        String sign = SignUtil.sign(param, p_bizPwd);
        String str = SignUtil.getSignatureContent(param);
        str = String.valueOf(str) + "&sign=" + sign + "&remark=" + remark;
        String resp = HttpClientUtil.get(String.valueOf(bonusUrl) + "/recharge.do?" + str);
        if (resp.contains("\"code\":\"00\"")) {
            return;
        }
        if (resp.contains("\"code\":\"1001\"")) {
            return;
        }
        throw new RuntimeException(resp);
    }

    public static void returnconsume(String userId, int transNum, String transNo, String balanceDate, String actNo, String gameId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        param.put("transNum", String.valueOf(transNum));
        param.put("transNo", transNo);
        param.put("bizNo", bizNo);
        param.put("balanceDate", balanceDate);
        param.put("actNo", actNo == null ? "" : actNo);
        param.put("gameId", gameId == null ? "" : gameId);
        String sign = SignUtil.sign(param, bizPwd);
        String str = SignUtil.getSignatureContent(param);
        str = String.valueOf(str) + "&sign=" + sign;
        String resp = HttpClientUtil.get(String.valueOf(bonusUrl) + "/returnconsume.do?" + str);
        if (resp.contains("\"code\":\"00\"")) {
            return;
        }
        if (resp.contains("\"code\":\"1001\"")) {
            return;
        }
        throw new RuntimeException(resp);
    }

    public static UserBonus queryBonus(String userId) {
        String resp = HttpClientUtil.get(String.valueOf(bonusUrl) + "/querybonus.do?userId=" + userId);
        if (!resp.contains("\"code\":\"00\"")) {
            throw new RuntimeException("\u51fa\u73b0\u5f02\u5e38");
        }
        if (resp.contains("\"userBonus\":null")) {
            return null;
        }
        try {
            Map respMap = (Map)JsonUtil.jsonToObject(resp.substring(9, resp.length() - 1));
            respMap = (Map)respMap.get("data");
            respMap = (Map)respMap.get("userBonus");
            UserBonus userBonus = new UserBonus();
            userBonus.setBonusLevel(Integer.valueOf((String)respMap.get("bonusLevel")));
            userBonus.setConsumeSum(Integer.valueOf((String)respMap.get("consumeSum")));
            userBonus.setBonusStatus((String)respMap.get("bonusStatus"));
            userBonus.setRechargeSum(Integer.valueOf((String)respMap.get("rechargeSum")));
            userBonus.setBonusNum(Integer.valueOf((String)respMap.get("bonusNum")));
            userBonus.setUserName((String)respMap.get("userName"));
            userBonus.setUserId((String)respMap.get("userId"));
            userBonus.setNextLevelNeedNum(Integer.valueOf((String)respMap.get("nextLevelNeedNum")));
            userBonus.setLevelName((String)respMap.get("levelName"));
            userBonus.setLevelUrl((String)respMap.get("levelUrl"));
            userBonus.setBonusRanking(Long.valueOf((String)respMap.get("bonusRanking")));
            return userBonus;
        }
        catch (Exception e) {
            throw new RuntimeException("\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public static Map<String, Object> getBonusSort(String userId) throws Exception {
        String resp = HttpClientUtil.get(String.valueOf(bonusUrl) + "/querybonussort.do?userId=" + userId);
        Map respMap = (Map)JsonUtil.jsonToObject(resp.substring(9, resp.length() - 1));
        return (Map)respMap.get("data");
    }

    public static void checkBonusEnough(String userId, int bonusNum) {
        String resp = HttpClientUtil.get(String.valueOf(bonusUrl) + "/checkenoughconsume.do?userId=" + userId + "&bonusNum=" + bonusNum);
        if (resp.contains("\"code\":\"00\"")) {
            return;
        }
        if (resp.contains("\"code\":\"1020\"")) {
            throw new NiuRuntimeException("1020", "\u79ef\u5206\u4e0d\u5b58\u5728");
        }
        if (resp.contains("\"code\":\"1021\"")) {
            throw new NiuRuntimeException("1021", "\u79ef\u5206\u4e0d\u591f");
        }
        if (resp.contains("\"code\":\"1022\"")) {
            throw new NiuRuntimeException("1022", "\u79ef\u5206\u4e0d\u591f");
        }
        throw new RuntimeException(resp);
    }
}

