/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.nettyframework.jdbc;

import com.mysql.jdbc.ResultSetMetaData;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XLJdbcTemplate
extends JdbcTemplate {
    public XLJdbcTemplate(DataSource dataSource) {
        super(dataSource);
    }

    public List<HashMap<String, Object>> queryForMapList(String sql, Object[] params) {
        final ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        this.query(sql, params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                ResultSetMetaData resultSetMetaData = (ResultSetMetaData)rs.getMetaData();
                int columnNum = resultSetMetaData.getColumnCount();
                if (columnNum == 0) {
                    throw new SQLException("column Num=0");
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>(columnNum);
                int i = 1;
                while (i < columnNum + 1) {
                    String columnName = resultSetMetaData.getColumnLabel(i).toLowerCase();
                    Object columnValue = rs.getObject(i);
                    hashMap.put(columnName, columnValue);
                    ++i;
                }
                list.add(hashMap);
            }
        });
        return list;
    }

    public List<HashMap<String, Object>> queryForMapList(String sql) {
        return this.queryForMapList(sql, null);
    }

    @Override
    public HashMap<String, Object> queryForMap(String sql, Object[] params) {
        final HashMap<String, Object> map = new HashMap<String, Object>();
        this.query(sql, params, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                int columnNum = rs.getMetaData().getColumnCount();
                if (columnNum == 0) {
                    throw new SQLException("column Num=0");
                }
                int i = 1;
                while (i < columnNum + 1) {
                    String columnName = rs.getMetaData().getColumnName(i).toLowerCase();
                    Object columnValue = rs.getObject(i);
                    map.put(columnName, columnValue);
                    ++i;
                }
            }
        });
        return map;
    }

    @Override
    public HashMap<String, Object> queryForMap(String sql) {
        return this.queryForMap(sql, null);
    }

    public BigInteger queryForBigInteger(String sql, Object[] params) {
        BigInteger number = (BigInteger)this.queryForObject(sql, params, BigInteger.class);
        return number;
    }
}

