/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util;

import com.xunlei.netty.httpserver.exception.ClosedChannelError;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.util.Log;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.slf4j.Logger;

public class NetUtil {
    private static final int DEFAULT_CONFIG_CONNECTTIMEOUTMILLIS = 5000;
    private static final int DEFAULT_CONFIG_RECEIVEBUFFERSIZE = 8192;
    private static final boolean DEFAULT_CONFIG_REUSEADDRESS = true;
    private static final int DEFAULT_CONFIG_SENDBUFFERSIZE = 8192;
    private static final int DEFAULT_CONFIG_SOLINGER = -1;
    private static final boolean DEFAULT_CONFIG_TCPKEEPALIVE = true;
    private static final boolean DEFAULT_CONFIG_TCPNODELAY = true;
    private static Logger log = Log.getLogger();
    private static String resetByPeerFilterStr = "reset by";
    private static String resetByPeerFilterStr1 = "\u5f3a\u8feb\u5173\u95ed";
    private static String connectionTimedOut = "Connection timed out";

    public static void checkSocketPortBind(int ... ports) {
        if (System.getProperty("os.name").startsWith("Win")) {
            int[] nArray = ports;
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                int port = nArray[n2];
                boolean isBind = true;
                try {
                    Socket client = new Socket("localhost", port);
                }
                catch (ConnectException e1) {
                    isBind = false;
                }
                catch (Exception e1) {
                    log.error("", e1);
                    isBind = true;
                }
                if (isBind) {
                    String errStr = "Failed to bind to " + port;
                    System.err.println(errStr);
                    HttpServerConfig.ALARMLOG.error(errStr);
                    System.exit(1);
                }
                ++n2;
            }
        }
    }

    public static boolean exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        boolean channelInterrupt = false;
        try {
            try {
                Object v;
                Channel channel = e.getChannel();
                Throwable t = e.getCause();
                Object attach = ctx.getAttachment();
                Object object = v = attach == null ? channel : attach;
                if (t != null) {
                    if (t instanceof IOException && t.getMessage() != null) {
                        String msg = t.getMessage();
                        if (msg.contains(resetByPeerFilterStr) || msg.contains(resetByPeerFilterStr1)) {
                            log.info("resetByPeer      :{},{}", v, (Object)msg);
                        } else if (msg.contains(connectionTimedOut)) {
                            log.info("connectionTimeout:{},{}", v, (Object)msg);
                        }
                    } else if (t instanceof ClosedChannelException || t instanceof ClosedChannelError) {
                        log.info("channelClosed    :{},{}", v, (Object)t.getMessage());
                        channelInterrupt = true;
                    } else {
                        log.error("exceptionCaught  :{}", v, (Object)t);
                    }
                } else {
                    log.error("exceptionCaught :{}", v, (Object)e);
                }
                channel.close();
            }
            catch (Exception exception) {
                ctx.sendUpstream(e);
            }
        }
        finally {
            ctx.sendUpstream(e);
        }
        return channelInterrupt;
    }

    public static void setServerBootstrapOptions(ServerBootstrap serverBootstrap) {
        NetUtil.setServerBootstrapOptions(serverBootstrap, 5000, 8192, 8192);
    }

    public static void setServerBootstrapOptions(ServerBootstrap serverBootstrap, int connectTimeoutMillis, int receiveBufferSize, int sendBufferSize) {
        serverBootstrap.setOption("tcpNoDelay", true);
        serverBootstrap.setOption("soLinger", -1);
        serverBootstrap.setOption("reuseAddress", true);
        serverBootstrap.setOption("child.tcpNoDelay", true);
        serverBootstrap.setOption("child.soLinger", -1);
        serverBootstrap.setOption("child.reuseAddress", true);
        serverBootstrap.setOption("keepAlive", true);
        serverBootstrap.setOption("connectTimeoutMillis", connectTimeoutMillis);
        serverBootstrap.setOption("receiveBufferSize", receiveBufferSize);
        serverBootstrap.setOption("sendBufferSize", sendBufferSize);
        serverBootstrap.setOption("child.keepAlive", true);
        serverBootstrap.setOption("child.connectTimeoutMillis", connectTimeoutMillis);
        serverBootstrap.setOption("child.receiveBufferSize", receiveBufferSize);
        serverBootstrap.setOption("child.sendBufferSize", sendBufferSize);
    }
}

