/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.component;

import com.xunlei.netty.httpserver.component.PostContentDecoder;
import com.xunlei.netty.httpserver.component.XLCookieDecoder;
import com.xunlei.netty.httpserver.exception.IllegalParameterError;
import com.xunlei.netty.httpserver.util.IPGetterHelper;
import com.xunlei.util.CharsetTools;
import com.xunlei.util.EmptyChecker;
import com.xunlei.util.HttpUtil;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import com.xunlei.util.ValueUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.Attribute;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.DefaultHttpDataFactory;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.DiskAttribute;
import org.jboss.netty.handler.codec.http.DiskFileUpload;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpDataFactory;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpPostRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.InterfaceHttpData;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.slf4j.Logger;

public class XLHttpRequest
extends DefaultHttpRequest {
    private static final String COOKIE = "COOKIE";
    private static final XLCookieDecoder cookieDecoder = new XLCookieDecoder();
    private static final HttpDataFactory factory = new DefaultHttpDataFactory(DefaultHttpDataFactory.MINSIZE);
    private static final Logger log = Log.getLogger();
    private static final String PARAMETER = "PARAMETER";
    private Charset charset4ContentDecoder = CharsetTools.UTF_8;
    private Charset charset4QueryStringDecoder = CharsetTools.UTF_8;
    private Map<String, Cookie> cookies;
    private long createTime = System.currentTimeMillis();
    private HttpPostRequestDecoder httpPostRequestDecoder;
    private boolean httpPostRequestDecoderInit;
    private SocketAddress localAddress;
    private String localIP;
    private Map<String, List<String>> parameters;
    private Map<String, List<String>> parametersByPost;
    @Deprecated
    private PostContentDecoder postContentDecoder;
    private String primitiveRemoteIP;
    private QueryStringDecoder queryStringDecoder;
    private SocketAddress remoteAddress;
    private String remoteIP;
    private String url;

    static {
        DiskFileUpload.deleteOnExitTemporaryFile = false;
        DiskFileUpload.baseDirectory = null;
        DiskAttribute.deleteOnExitTemporaryFile = false;
        DiskAttribute.baseDirectory = null;
    }

    private Map<String, List<String>> initParametersByPost(Map<String, List<String>> params, HttpPostRequestDecoder httpPostRequestDecoder) {
        if (httpPostRequestDecoder == null) {
            return params;
        }
        try {
            List<InterfaceHttpData> datas = httpPostRequestDecoder.getBodyHttpDatas();
            if (datas != null) {
                for (InterfaceHttpData data : datas) {
                    if (!(data instanceof Attribute)) continue;
                    Attribute attribute = (Attribute)data;
                    try {
                        String key = attribute.getName();
                        String value = attribute.getValue();
                        List<String> ori = params.get(key);
                        if (ori == null) {
                            ori = new ArrayList<String>(1);
                            params.put(key, ori);
                        }
                        ori.add(value);
                    }
                    catch (IOException e) {
                        log.error("cant init attribute,req:{},attribute:{}", new Object[]{this, attribute, e});
                    }
                }
            }
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException e) {
            log.error("req:{}", this, (Object)e);
        }
        return params;
    }

    public XLHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri) {
        super(httpVersion, method, uri);
    }

    private boolean getBoolean(String key, String v, String type) {
        if (v == null) {
            throw new IllegalParameterError(key, this, type);
        }
        return v.equals("true") || v.equalsIgnoreCase("y") || v.equals("1");
    }

    public Charset getCharset4QueryStringDecoder() {
        return this.charset4QueryStringDecoder;
    }

    public Cookie getCookie(String name) {
        return this.getCookies().get(name);
    }

    public Map<String, Cookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, Cookie>();
            List<String> cookieList = this.getHeaders("Cookie");
            for (String cookieString : cookieList) {
                if (StringTools.isEmpty(cookieString)) continue;
                cookieDecoder.decode(cookieString, this.cookies);
            }
        }
        return this.cookies;
    }

    public String getCookieValue(String cookieName) {
        if (StringTools.isEmpty(cookieName)) {
            throw new IllegalArgumentException("cookieName isEmpty:[" + cookieName + "]");
        }
        Cookie cookie = this.getCookie(cookieName);
        return cookie == null ? null : cookie.getValue();
    }

    public String getCookieValue(String cookieName, String defaultValue) {
        if (StringTools.isEmpty(cookieName)) {
            throw new IllegalArgumentException("cookieName isEmpty:[" + cookieName + "]");
        }
        Cookie cookie = this.getCookie(cookieName);
        if (cookie == null) {
            return defaultValue;
        }
        return cookie.getValue();
    }

    public boolean getCookieValueBoolean(String cookieName) {
        return this.getBoolean(cookieName, this.getCookieValue(cookieName), COOKIE);
    }

    public boolean getCookieValueBoolean(String cookieName, boolean defaultValue) {
        return ValueUtil.getBoolean(this.getCookieValue(cookieName), defaultValue);
    }

    public String getCookieValueCompelled(String cookieName) {
        String v = this.getCookieValue(cookieName);
        if (v == null) {
            throw new IllegalParameterError(cookieName, this, COOKIE);
        }
        return v;
    }

    public double getCookieValueDouble(String cookieName) {
        return this.getDouble(cookieName, this.getCookieValue(cookieName), COOKIE);
    }

    public double getCookieValueDouble(String cookieName, int defaultValue) {
        return ValueUtil.getDouble(this.getCookieValue(cookieName), defaultValue);
    }

    public float getCookieValueFloat(String cookieName) {
        return this.getFloat(cookieName, this.getCookieValue(cookieName), COOKIE);
    }

    public float getCookieValueFloat(String cookieName, int defaultValue) {
        return ValueUtil.getFloat(this.getCookieValue(cookieName), defaultValue);
    }

    public long getCookieValueInteger(String cookieName) {
        return this.getInteger(cookieName, this.getCookieValue(cookieName), COOKIE);
    }

    public int getCookieValueInteger(String cookieName, int defaultValue) {
        return ValueUtil.getInteger(this.getCookieValue(cookieName), defaultValue);
    }

    public long getCookieValueLong(String cookieName) {
        return this.getLong(cookieName, this.getCookieValue(cookieName), COOKIE);
    }

    public long getCookieValueLong(String cookieName, long defaultValue) {
        return ValueUtil.getLong(this.getCookieValue(cookieName), defaultValue);
    }

    public long getCreateTime() {
        return this.createTime;
    }

    private double getDouble(String key, String v, String type) {
        if (v == null) {
            throw new IllegalParameterError(key, this, type);
        }
        try {
            return Double.valueOf(v);
        }
        catch (Exception exception) {
            throw new IllegalParameterError(key, this, type, " must be Double");
        }
    }

    private float getFloat(String key, String v, String type) {
        if (v == null) {
            throw new IllegalParameterError(key, this, type);
        }
        try {
            return Float.valueOf(v).floatValue();
        }
        catch (Exception exception) {
            throw new IllegalParameterError(key, this, type, " must be Float");
        }
    }

    public HttpPostRequestDecoder getHttpPostRequestDecoder() {
        if (!this.httpPostRequestDecoderInit) {
            HttpMethod method = this.getMethod();
            if (method.equals(HttpMethod.POST) || method.equals(HttpMethod.PUT)) {
                try {
                    this.httpPostRequestDecoder = new HttpPostRequestDecoder(factory, this, this.charset4ContentDecoder);
                }
                catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                    log.error("request postDataDecode error:{}", this, (Object)e);
                }
                catch (HttpPostRequestDecoder.IncompatibleDataDecoderException incompatibleDataDecoderException) {
                    // empty catch block
                }
            }
            this.httpPostRequestDecoderInit = true;
        }
        return this.httpPostRequestDecoder;
    }

    private int getInteger(String key, String v, String type) {
        if (v == null) {
            throw new IllegalParameterError(key, this, type);
        }
        try {
            return Integer.valueOf(v);
        }
        catch (Exception exception) {
            throw new IllegalParameterError(key, this, type, " must be Integer");
        }
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public String getLocalIP() {
        if (this.localIP == null) {
            try {
                this.localIP = HttpUtil.getIP((InetSocketAddress)this.getLocalAddress());
            }
            catch (Exception e) {
                log.error("", e);
                this.localIP = "";
            }
        }
        return this.localIP;
    }

    public int getLocalPort() {
        return ((InetSocketAddress)this.localAddress).getPort();
    }

    private long getLong(String key, String v, String type) {
        if (v == null) {
            throw new IllegalParameterError(key, this, type);
        }
        try {
            return Long.valueOf(v);
        }
        catch (Exception exception) {
            throw new IllegalParameterError(key, this, type, " must be Long");
        }
    }

    public String getParameter(String key) {
        if (StringTools.isEmpty(key)) {
            throw new IllegalArgumentException("key isEmpty:[" + key + "]");
        }
        List<String> v = this.getParameters().get(key);
        if (v != null) {
            return v.get(0);
        }
        return this.getParameterByPost(key);
    }

    public String getParameter(String key, String defaultValue) {
        String v = this.getParameter(key);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public boolean getParameterBoolean(String key) {
        return this.getBoolean(key, this.getParameter(key), PARAMETER);
    }

    public boolean getParameterBoolean(String key, boolean defaultValue) {
        return ValueUtil.getBoolean(this.getParameter(key), defaultValue);
    }

    public String getParameterByPost(String key) {
        List<String> v = this.getParametersByPost().get(key);
        if (v != null) {
            return v.get(0);
        }
        return null;
    }

    public String getParameterCompelled(String key) {
        String v = this.getParameter(key);
        if (v == null) {
            throw new IllegalParameterError(key, this, PARAMETER);
        }
        return v;
    }

    public double getParameterDouble(String key) {
        return this.getDouble(key, this.getParameter(key), PARAMETER);
    }

    public double getParameterDouble(String key, double defaultValue) {
        return ValueUtil.getDouble(this.getParameter(key), defaultValue);
    }

    public float getParameterFloat(String key) {
        return this.getFloat(key, this.getParameter(key), PARAMETER);
    }

    public float getParameterFloat(String key, float defaultValue) {
        return ValueUtil.getFloat(this.getParameter(key), defaultValue);
    }

    public int getParameterInteger(String key) {
        return this.getInteger(key, this.getParameter(key), PARAMETER);
    }

    public int getParameterInteger(String key, int defaultValue) {
        return ValueUtil.getInteger(this.getParameter(key), defaultValue);
    }

    public long getParameterLong(String key) {
        return this.getLong(key, this.getParameter(key), PARAMETER);
    }

    public long getParameterLong(String key, long defaultValue) {
        return ValueUtil.getLong(this.getParameter(key), defaultValue);
    }

    public Map<String, List<String>> getParameters() {
        if (this.parameters == null) {
            try {
                Map<String, List<String>> params = this.getQueryStringDecoder().getParameters();
                this.parameters = params;
            }
            catch (Exception e) {
                log.error("queryString decode fail,req:{},{}:{}", new Object[]{this, e.getClass(), e.getMessage()});
                this.parameters = Collections.emptyMap();
            }
        }
        return this.parameters;
    }

    public Map<String, List<String>> getParametersByPost() {
        if (this.parametersByPost == null) {
            HttpPostRequestDecoder httpPostRequestDecoder = this.getHttpPostRequestDecoder();
            this.parametersByPost = httpPostRequestDecoder != null ? this.initParametersByPost(new HashMap<String, List<String>>(0), httpPostRequestDecoder) : Collections.emptyMap();
        }
        return this.parametersByPost;
    }

    public String[] getParameterValues(String key) {
        List<String> result = this.getParameters().get(key);
        if (EmptyChecker.isNotEmpty(result)) {
            return (String[])result.toArray();
        }
        result = this.getParametersByPost().get(key);
        if (EmptyChecker.isNotEmpty(result)) {
            return (String[])result.toArray();
        }
        return null;
    }

    public String getPath() {
        return this.getQueryStringDecoder().getPath();
    }

    @Deprecated
    public PostContentDecoder getPostContentDecoder() {
        ChannelBuffer buffer;
        if (this.postContentDecoder == null && (buffer = this.getContent()) != null) {
            this.postContentDecoder = new PostContentDecoder(buffer.toString(this.charset4ContentDecoder));
        }
        return this.postContentDecoder;
    }

    public String getPrimitiveRemoteIP() {
        if (this.primitiveRemoteIP == null) {
            try {
                this.primitiveRemoteIP = HttpUtil.getIP((InetSocketAddress)this.remoteAddress);
            }
            catch (Exception e) {
                log.error("", e);
                this.primitiveRemoteIP = "";
            }
        }
        return this.primitiveRemoteIP;
    }

    public QueryStringDecoder getQueryStringDecoder() {
        if (this.queryStringDecoder == null) {
            this.queryStringDecoder = new QueryStringDecoder(this.getUri(), this.charset4QueryStringDecoder);
        }
        return this.queryStringDecoder;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getRemoteHost() {
        return ((InetSocketAddress)this.remoteAddress).getHostName();
    }

    public String getRemoteIP() {
        this.remoteIP = this.getHeader("X-real-IP");
        if (this.remoteIP == null) {
            this.remoteIP = IPGetterHelper.getIP(this);
        }
        return this.remoteIP;
    }

    public int getRemotePort() {
        return ((InetSocketAddress)this.remoteAddress).getPort();
    }

    public void offerChunk(HttpChunk chunk) throws Exception {
        this.getHttpPostRequestDecoder().offer(chunk);
    }

    public void setCharset4QueryStringDecoder(Charset charset4QueryStringDecoder) {
        this.charset4QueryStringDecoder = charset4QueryStringDecoder;
    }

    public void setLocalAddress(SocketAddress localAddress) {
        this.localAddress = localAddress;
    }

    public void setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public String toString() {
        return String.valueOf(Integer.toHexString(this.hashCode())) + this.getRemoteAddress() + "/" + this.getMethod() + " " + this.getUri();
    }

    public String getUrl() {
        if (this.url == null) {
            String host = this.getHeader("Host");
            String port = ":" + this.getLocalPort();
            this.url = "http://" + (StringTools.isEmpty(host) ? String.valueOf(this.getLocalIP()) + port : host) + this.getUri();
        }
        return this.url;
    }

    public StringBuilder getDetailInfo() {
        List<String> vals;
        String key;
        String content;
        Map<String, List<String>> params = this.getParameters();
        Map<String, List<String>> post_params = this.getParametersByPost();
        int keyMaxLen = 20;
        for (String key2 : params.keySet()) {
            keyMaxLen = Math.max(keyMaxLen, key2.length());
        }
        for (String key2 : post_params.keySet()) {
            keyMaxLen = Math.max(keyMaxLen, key2.length());
        }
        String fmt = "%" + keyMaxLen + "s  %s\n";
        StringBuilder r = new StringBuilder("REQUEST:\n");
        r.append(String.format(fmt, this.getMethod(), this.getUrl()));
        r.append(String.format(fmt, this.getProtocolVersion().getText(), this.getRemoteAddress() + "->" + this.getLocalAddress()));
        if (!this.getHeaderNames().isEmpty()) {
            r.append("HEADER:\n");
            for (String name : this.getHeaderNames()) {
                for (String value : this.getHeaders(name)) {
                    r.append(String.format(fmt, name, value));
                }
            }
        }
        if (StringTools.isNotEmpty(content = this.getContentString())) {
            r.append("CONTENT:\n" + content + "\n");
        }
        if (!params.isEmpty()) {
            r.append("PARAM:\n");
            for (Map.Entry<String, List<String>> p : params.entrySet()) {
                key = p.getKey();
                vals = p.getValue();
                for (String val : vals) {
                    r.append(String.format(fmt, key, val));
                }
            }
        }
        if (!post_params.isEmpty()) {
            r.append("POST_PARAM:\n");
            for (Map.Entry<String, List<String>> p : post_params.entrySet()) {
                key = p.getKey();
                vals = p.getValue();
                for (String val : vals) {
                    r.append(String.format(fmt, key, val));
                }
            }
        }
        return r;
    }

    public String getContentString(Charset charset) {
        ChannelBuffer content = this.getContent();
        return new String(content.array(), charset);
    }

    public String getContentString() {
        ChannelBuffer content = this.getContent();
        return new String(content.array(), this.charset4ContentDecoder);
    }

    public Charset getCharset4ContentDecoder() {
        return this.charset4ContentDecoder;
    }

    public void setCharset4ContentDecoder(Charset charset4ContentDecoder) {
        this.charset4ContentDecoder = charset4ContentDecoder;
    }
}

