/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.component;

import com.xunlei.netty.httpserver.async.AsyncCallback;
import com.xunlei.netty.httpserver.cmd.CmdMappers;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.util.CloseableHelper;
import com.xunlei.util.HumanReadableUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.netty.channel.ChannelHandlerContext;

public class XLContextAttachment {
    private XLHttpRequest request;
    private XLHttpResponse response;
    private ChannelHandlerContext channelHandlerContext;
    private CmdMappers.CmdMeta cmdMeta;
    private long lastReadTime;
    private long lastWriteTime;
    private volatile Thread processThread;
    private long decode;
    private long process;
    private long encode;
    private long complete;
    private Set<Object> closeable;
    private List<Throwable> throwables;
    private AsyncCallback asyncCallback;
    private Object innerAttach;

    public long markLastReadTime() {
        this.lastReadTime = System.currentTimeMillis();
        return this.lastReadTime;
    }

    public long markLastWriteTime() {
        this.lastWriteTime = System.currentTimeMillis();
        return this.lastWriteTime;
    }

    public void registerAsyncCallback(AsyncCallback asyncProxyHandlerCallback) {
        this.asyncCallback = asyncProxyHandlerCallback;
    }

    public AsyncCallback getAsyncCallback() {
        return this.asyncCallback;
    }

    public void registerInnerAttach(Object innerAttach) {
        this.innerAttach = innerAttach;
    }

    public Object getInnerAttach() {
        return this.innerAttach;
    }

    public void registerThrowable(Throwable ex) {
        if (this.throwables == null) {
            this.throwables = new ArrayList<Throwable>(1);
        }
        this.throwables.add(ex);
    }

    public synchronized void interrupt() {
        if (this.closeable != null) {
            for (Object obj : this.closeable) {
                CloseableHelper.closeSilently(obj);
            }
        }
        if (this.processThread != null) {
            this.processThread.interrupt();
        }
    }

    public void registerCloseable(Object obj) {
        if (this.closeable == null) {
            this.closeable = new HashSet<Object>(1);
        }
        this.closeable.add(obj);
    }

    public String getName() {
        return this.cmdMeta + (this.request == null ? "" : "-" + Integer.toHexString(this.request.hashCode())) + this.channelHandlerContext.getChannel().getRemoteAddress();
    }

    public String getTimeSpanInfo() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("\u89e3\u7801:").append(HumanReadableUtil.timeSpan(this.process - this.decode));
        if (this.encode > 0L) {
            tmp.append(" \u5904\u7406:").append(HumanReadableUtil.timeSpan(this.encode - this.process));
            if (this.complete > 0L) {
                tmp.append(" \u7f16\u7801:").append(HumanReadableUtil.timeSpan(this.complete - this.encode));
                tmp.append(" \u6240\u6709:").append(HumanReadableUtil.timeSpan(this.complete - this.decode));
            }
        }
        return tmp.toString();
    }

    public String toString() {
        return this.getName();
    }

    public void markWriteBegin() {
        this.encode = System.currentTimeMillis();
    }

    public long markWriteEnd() {
        long ori = this.complete;
        this.complete = System.currentTimeMillis();
        return ori == 0L ? -1L : this.complete - ori;
    }

    public XLContextAttachment(ChannelHandlerContext channelHandlerContext) {
        this.channelHandlerContext = channelHandlerContext;
        this.lastReadTime = this.lastWriteTime = System.currentTimeMillis();
    }

    public XLHttpRequest getRequest() {
        return this.request;
    }

    public XLHttpResponse getResponse() {
        return this.response;
    }

    public long getDecode() {
        return this.decode;
    }

    public long getProcess() {
        return this.process;
    }

    public long getEncode() {
        return this.encode;
    }

    public long getComplete() {
        return this.complete;
    }

    public CmdMappers.CmdMeta getCmdMeta() {
        return this.cmdMeta;
    }

    public void setCmdMeta(CmdMappers.CmdMeta cmdMeta) {
        this.cmdMeta = cmdMeta;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.channelHandlerContext;
    }

    public List<Throwable> getThrowables() {
        return this.throwables;
    }

    public void registerNewMessage(XLHttpResponse response) {
        this.response = response;
        this.process = response.getCreateTime();
    }

    public void registerNewMessage(XLHttpRequest request) {
        this.request = request;
        this.decode = request.getCreateTime();
        this.encode = 0L;
        this.complete = 0L;
        this.lastReadTime = this.decode;
        this.cmdMeta = null;
        this.closeable = null;
        this.throwables = null;
    }

    public Thread getProcessThread() {
        return this.processThread;
    }

    public synchronized void registerProcessThread() {
        this.processThread = Thread.currentThread();
    }

    public synchronized void unregisterProcessThread() {
        this.processThread = null;
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public long getLastWriteTime() {
        return this.lastWriteTime;
    }
}

