/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.cmd.common;

import com.xunlei.netty.httpserver.cmd.BaseCmd;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.spring.Config;
import com.xunlei.util.DateStringUtil;
import com.xunlei.util.codec.DigestUtils;
import org.springframework.stereotype.Service;

@Service
public class EchoCmd
extends BaseCmd {
    @Config(value="EchoCmd.now.key", resetable=true)
    String echoNowKey = "ECHONOWHASHKEY";

    @Override
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        StringBuilder responseContent = new StringBuilder();
        responseContent.append("WELCOME TO THE XUNLEI HTTPSERVER\n");
        responseContent.append((CharSequence)request.getDetailInfo());
        return responseContent.toString();
    }

    public Object now(XLHttpRequest request, XLHttpResponse response) throws Exception {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String pattern = request.getParameter("p", "default");
        String random = request.getParameter("r");
        StringBuilder result = new StringBuilder();
        if (pattern.equalsIgnoreCase("utc")) {
            result.append(System.currentTimeMillis() / 1000L);
        } else if (pattern.equalsIgnoreCase("millis")) {
            result.append(System.currentTimeMillis());
        } else if (pattern.equalsIgnoreCase("default")) {
            result.append(DateStringUtil.getInstance("yyyy-MM-dd HH:mm:ss").now());
        }
        if (random != null) {
            String verifyString = String.valueOf(result.toString()) + random + this.echoNowKey;
            String verifySecret = DigestUtils.md5Hex(verifyString.getBytes());
            result.append('\n').append(verifySecret);
        }
        return result;
    }
}

