/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.memcached.cached.impl;

import com.xunlei.memcached.cached.ICache;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCacheImpl
implements ICache<String, Object> {
    private static final Log Logger = LogFactory.getLog(DefaultCacheImpl.class);
    ConcurrentHashMap<String, Object>[] caches;
    ConcurrentHashMap<String, Long> expiryCache;
    private int expiryInterval = 10;
    private int moduleSize = 10;

    public DefaultCacheImpl() {
        this.init();
    }

    public DefaultCacheImpl(int expiryInterval, int moduleSize) {
        this.expiryInterval = expiryInterval;
        this.moduleSize = moduleSize;
        this.init();
    }

    private void init() {
        this.caches = new ConcurrentHashMap[this.moduleSize];
        int i = 0;
        while (i < this.moduleSize) {
            this.caches[i] = new ConcurrentHashMap();
            ++i;
        }
        this.expiryCache = new ConcurrentHashMap();
        if (Logger.isInfoEnabled()) {
            Logger.info("DefaultCache CheckService is start!");
        }
    }

    @Override
    public boolean clear() {
        if (this.caches != null) {
            ConcurrentHashMap<String, Object>[] concurrentHashMapArray = this.caches;
            int n = this.caches.length;
            int n2 = 0;
            while (n2 < n) {
                ConcurrentHashMap<String, Object> cache = concurrentHashMapArray[n2];
                cache.clear();
                ++n2;
            }
        }
        if (this.expiryCache != null) {
            this.expiryCache.clear();
        }
        return true;
    }

    @Override
    public Object get(String key) {
        this.checkValidate(key);
        return this.getCache(key).get(key);
    }

    @Override
    public Object put(String key, Object value) {
        Object result = this.getCache(key).put(key, value);
        this.expiryCache.put(key, -1L);
        return result;
    }

    public Object put(String key, Object value, Date expiry) {
        Object result = this.getCache(key).put(key, value);
        this.expiryCache.put(key, expiry.getTime());
        return result;
    }

    @Override
    public Object remove(String key) {
        Object result = this.getCache(key).remove(key);
        this.expiryCache.remove(key);
        return result;
    }

    @Override
    public int size() {
        this.checkAll();
        return this.expiryCache.size();
    }

    private ConcurrentHashMap<String, Object> getCache(String key) {
        long hashCode = key.hashCode();
        if (hashCode < 0L) {
            hashCode = -hashCode;
        }
        int moudleNum = (int)hashCode % this.moduleSize;
        return this.caches[moudleNum];
    }

    private void checkValidate(String key) {
        if (this.expiryCache.get(key) != null && this.expiryCache.get(key) != -1L && new Date(this.expiryCache.get(key)).before(new Date())) {
            this.getCache(key).remove(key);
            this.expiryCache.remove(key);
        }
    }

    private void checkAll() {
        for (String key : this.expiryCache.keySet()) {
            this.checkValidate(key);
        }
    }

    @Override
    public Object put(String key, Object value, int TTL) {
        Object result = this.getCache(key).put(key, value);
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, TTL);
        this.expiryCache.put(key, calendar.getTime().getTime());
        return result;
    }

    @Override
    public void destroy() {
        try {
            this.clear();
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    class CheckOutOfDateSchedule
    implements Runnable {
        ConcurrentHashMap<String, Object>[] caches;
        ConcurrentHashMap<String, Long> expiryCache;

        public CheckOutOfDateSchedule(ConcurrentHashMap<String, Object>[] caches, ConcurrentHashMap<String, Long> expiryCache) {
            this.caches = caches;
            this.expiryCache = expiryCache;
        }

        @Override
        public void run() {
            this.check();
        }

        public void check() {
            try {
                ConcurrentHashMap<String, Object>[] concurrentHashMapArray = this.caches;
                int n = this.caches.length;
                int n2 = 0;
                while (n2 < n) {
                    ConcurrentHashMap<String, Object> cache = concurrentHashMapArray[n2];
                    for (String key : cache.keySet()) {
                        long date;
                        if (this.expiryCache.get(key) == null || (date = this.expiryCache.get(key).longValue()) <= 0L || !new Date(date).before(new Date())) continue;
                        this.expiryCache.remove(key);
                        cache.remove(key);
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                Logger.info("DefaultCache CheckService is start!");
            }
        }
    }
}

