/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluatorBase;
import com.xunlei.util.Log;
import com.xunlei.util.concurrent.ConcurrentUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.MDC;

public class XLSmtpSimpleEvaluator
extends EventEvaluatorBase<ILoggingEvent> {
    private long lastFlushTime = 0L;
    private String relevanceLoggerName;
    private AtomicInteger counter = new AtomicInteger();
    private int eventNumLimit = 256;
    private int eventSecondLimit = 1200;
    private int _eventTimeLimit = this.eventSecondLimit * 1000;
    private String name;
    private static final Map<String, XLSmtpSimpleEvaluator> evaluatorMap = new HashMap<String, XLSmtpSimpleEvaluator>(0);
    private volatile boolean forceTrigger = false;
    private volatile String latestMailTitle = "";

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (XLSmtpSimpleEvaluator ev : evaluatorMap.values()) {
                    ev.trigger();
                }
            }
        });
        ConcurrentUtil.dameonScheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (evaluatorMap.isEmpty()) {
                    String msg = "cant find any XLSmtpSimpleEvaluator,stop its DaemonScanner";
                    System.err.println(msg);
                    throw new RuntimeException(msg);
                }
                for (XLSmtpSimpleEvaluator ev : evaluatorMap.values()) {
                    ev.check();
                }
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    private void trigger() {
        if (this.counter.get() > 0) {
            this.forceTrigger = true;
            MDC.put("mailTitle", this.latestMailTitle);
            Log.getLogger(this.relevanceLoggerName).error("XLSmtpSimpleEvaluator.DaemonScanner trigger");
        }
    }

    private void check() {
        try {
            if (System.currentTimeMillis() - this.lastFlushTime > (long)this._eventTimeLimit) {
                this.trigger();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean evaluate(ILoggingEvent e) throws EvaluationException {
        long now = e.getTimeStamp();
        if (this.lastFlushTime == 0L) {
            this.lastFlushTime = now;
            this.relevanceLoggerName = e.getLoggerName();
        }
        this.latestMailTitle = MDC.get("mailTitle");
        if (this.forceTrigger || this.counter.incrementAndGet() >= this.eventNumLimit || now - this.lastFlushTime > (long)this._eventTimeLimit) {
            this.reset(now);
            return true;
        }
        return false;
    }

    private void reset(long now) {
        this.forceTrigger = false;
        this.counter.set(0);
        this.lastFlushTime = now;
    }

    public int getEventNumLimit() {
        return this.eventNumLimit;
    }

    public void setEventNumLimit(int eventNumLimit) {
        this.eventNumLimit = eventNumLimit;
    }

    public int getEventSecondLimit() {
        return this.eventSecondLimit;
    }

    public void setEventSecondLimit(int eventSecondLimit) {
        this.eventSecondLimit = eventSecondLimit;
        this._eventTimeLimit = eventSecondLimit * 1000;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        evaluatorMap.put(name, this);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

