/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.logback;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class FixSizeMemAppender<E>
extends UnsynchronizedAppenderBase<E> {
    public static final Map<String, FixSizeLog> FIX_SIZE_LOG_MAP = new HashMap<String, FixSizeLog>();
    protected Layout<E> layout;
    protected int size = 100;

    public static FixSizeLog getFixSizeLog(String loggerName) {
        return FIX_SIZE_LOG_MAP.get(loggerName);
    }

    public static FixSizeLog getFixSizeLog(Logger log) {
        return FIX_SIZE_LOG_MAP.get(log.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void append(E e) {
        if (e instanceof LoggingEvent) {
            LoggingEvent le = (LoggingEvent)e;
            String loggerName = le.getLoggerName();
            FixSizeLog fsl = FIX_SIZE_LOG_MAP.get(loggerName);
            if (fsl == null) {
                FixSizeMemAppender fixSizeMemAppender = this;
                synchronized (fixSizeMemAppender) {
                    fsl = new FixSizeLog(loggerName, this.size);
                    FIX_SIZE_LOG_MAP.put(loggerName, fsl);
                }
            }
            fsl.log(this.layout.doLayout(e));
        }
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public int getSize() {
        return this.size;
    }

    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public static class FixSizeLog {
        private String loggerName;
        private String[] bufferedLog;
        private AtomicInteger index = new AtomicInteger(0);
        private int size;

        public FixSizeLog(String loggerName, int size) {
            this.loggerName = loggerName;
            this.size = size;
            this.bufferedLog = new String[size];
        }

        public List<String> getLogs() {
            ArrayList<String> result = new ArrayList<String>();
            int i = 0;
            while (i < this.size) {
                String item = this.bufferedLog[(i + this.index.get()) % this.size];
                if (item != null) {
                    result.add(item);
                }
                ++i;
            }
            return result;
        }

        public void log(String msg) {
            this.bufferedLog[this.index.getAndIncrement() % this.size] = msg;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (String a : this.getLogs()) {
                sb.append(a);
            }
            return sb.toString();
        }

        public String getLoggerName() {
            return this.loggerName;
        }
    }
}

