/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.plugin.UserToRolePluginable;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.vo.Roles;
import com.xunlei.common.vo.Users;
import com.xunlei.common.web.model.AbstractManagedBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.faces.component.UISelectOne;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FunRef(value="UserToRole")
public class UserToRoleManagedBean
extends AbstractManagedBean {
    private List<Roles> rolelist;
    private UISelectOne userlogintype;
    private String firstroleno;
    private String in2out_seqids;
    private String out2in_seqids;

    public List<Roles> getAllroles() {
        this.authenticateRun();
        if (this.rolelist == null) {
            this.rolelist = commfacade.getAllRoles();
            if (this.rolelist.size() > 0) {
                this.firstroleno = this.rolelist.get(0).getRoleno() + "," + this.rolelist.get(0).getRoletype();
            }
        }
        return this.rolelist;
    }

    private Roles findRole(String roleno) {
        String[] rt = roleno.split(",");
        if (rt == null || rt.length < 2) {
            return null;
        }
        for (Roles role : this.rolelist) {
            if (!role.getRoleno().equals(rt[0]) || !role.getRoletype().equals(rt[1])) continue;
            return role;
        }
        return null;
    }

    public List<Users> getInUsers() {
        this.authenticateRun();
        if (this.firstroleno == null) {
            return new ArrayList<Users>();
        }
        Roles role = this.findRole(this.getCurrentroleno());
        role.setUserlogintype(this.getCurrentUserlogintype());
        return commfacade.getAllUsersInRoles(role);
    }

    public List<Users> getOutUsers() {
        this.authenticateRun();
        if (this.firstroleno == null) {
            return new ArrayList<Users>();
        }
        Roles role = this.findRole(this.getCurrentroleno());
        role.setUserlogintype(this.getCurrentUserlogintype());
        return commfacade.getAllUsersNotInRoles(role);
    }

    public String forin2out() {
        this.authenticateEdit();
        String[] strseqids = this.getIn2out_seqids().split("\\|");
        long[] seqids = new long[strseqids.length];
        for (int i = 0; i < strseqids.length; ++i) {
            seqids[i] = Long.valueOf(strseqids[i]);
        }
        Roles role = this.findRole(this.getCurrentroleno());
        try {
            ServiceLoader<UserToRolePluginable> loader = ServiceLoader.load(UserToRolePluginable.class);
            Iterator<UserToRolePluginable> it = loader.iterator();
            while (it.hasNext()) {
                it.next().out(role, seqids);
            }
        }
        catch (Exception ex) {
            this.alertJS(ex.getMessage());
            return "";
        }
        commfacade.removeUsersfromUserToRoles(role, seqids);
        return "";
    }

    public String forout2in() {
        this.authenticateEdit();
        String[] strseqids = this.getOut2in_seqids().split("\\|");
        long[] seqids = new long[strseqids.length];
        for (int i = 0; i < strseqids.length; ++i) {
            seqids[i] = Long.valueOf(strseqids[i]);
        }
        Roles role = this.findRole(this.getCurrentroleno());
        try {
            ServiceLoader<UserToRolePluginable> loader = ServiceLoader.load(UserToRolePluginable.class);
            Iterator<UserToRolePluginable> it = loader.iterator();
            while (it.hasNext()) {
                it.next().in(role, seqids);
            }
        }
        catch (Exception ex) {
            this.alertJS(ex.getMessage());
            return "";
        }
        commfacade.addUsersInRoles(role, seqids);
        return "";
    }

    public String getIn2out_seqids() {
        return this.in2out_seqids;
    }

    public void setIn2out_seqids(String in2out) {
        this.in2out_seqids = in2out;
    }

    public String getOut2in_seqids() {
        return this.out2in_seqids;
    }

    public void setOut2in_seqids(String out2in) {
        this.out2in_seqids = out2in;
    }

    public String getCurrentroleno() {
        String para = this.findParameter("curRoleno");
        if (this.isEmpty(para)) {
            this.getAllroles();
            para = this.firstroleno;
        }
        return para;
    }

    public String getCurrentUserlogintype() {
        return (String)this.userlogintype.getValue();
    }

    public UISelectOne getUserlogintype() {
        return this.userlogintype;
    }

    public void setUserlogintype(UISelectOne userlogintype) {
        this.userlogintype = userlogintype;
        if (userlogintype.getValue() == null) {
            userlogintype.setValue((Object)"A");
        }
    }
}

