/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.util.ApplicationConfigUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.Functions;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.Menus;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.common.vo.UserToRole;
import com.xunlei.common.vo.Users;
import com.xunlei.common.web.model.AbstractManagedBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FunRef(value="Menus")
public class MenuManagedBean
extends AbstractManagedBean {
    private String moduleName = "";
    public static Map<String, List<SelectItem>> pmenusMap = new HashMap<String, List<SelectItem>>();
    public static Map<String, HashMap<String, String>> menusMap = new HashMap<String, HashMap<String, String>>();

    public void getOneMenuNo() {
        Menus menu = this.findBean(Menus.class);
        menu.setPmenuno(this.findParameter("one_pmenuno"));
        if (this.isEmpty(menu.getPmenuno())) {
            menu.setPmenuno("0");
        }
        if ("-1".equals(menu.getPmenuno())) {
            menu.setMenuno("0");
            return;
        }
        try {
            menu.setMenuno(commfacade.getMaxSubMenuNo(menu.getPmenuno()));
        }
        catch (XLRuntimeException e) {
            this.alertJS(e.getMessage());
        }
    }

    public SelectItem[] getAllParentMenuNos() {
        List<String> list = commfacade.getAllParentMenuString();
        if (list.size() == 0) {
            return new SelectItem[]{new SelectItem((Object)"0", "0")};
        }
        SelectItem[] items = new SelectItem[list.size()];
        int index = -1;
        for (String s : list) {
            String[] array = s.split("\\|");
            items[++index] = new SelectItem((Object)array[0], array[0] + " " + array[1]);
        }
        return items;
    }

    public SelectItem[] getAllModuleAndfunctions() {
        List<Functions> funlist = commfacade.getAllFunctions();
        List<LibClassD> modlist = commfacade.getLibClassDByClassNo("SysModule");
        SelectItem[] items = new SelectItem[funlist.size() + modlist.size()];
        int index = -1;
        for (LibClassD module : modlist) {
            items[++index] = new SelectItem((Object)module.getClassitemid(), module.getItemname());
            for (Functions func : funlist) {
                if (!module.getClassitemid().equals(func.getModuleno())) continue;
                items[++index] = new SelectItem((Object)func.getFuncno(), func.getFuncname());
            }
        }
        while (index < items.length - 1) {
            items[++index] = new SelectItem((Object)"", "");
        }
        return items;
    }

    public String getQueryMenuslist() {
        this.authenticateRun();
        PagedFliper fliper = this.getFliper();
        this.mergePagedDataModel(commfacade.queryMenus(this.findBean(Menus.class, 2), fliper), fliper);
        return "";
    }

    public String add() {
        this.authenticateAdd();
        Menus data = this.findBean(Menus.class);
        if (data.getMenuno().length() > 9) {
            this.mergeBean((Object)"\u83dc\u5355\u7ea7\u6570\u5df2\u7ecf\u8d85\u8fc7\u6700\u5927\u503c", "jsmessage");
            return "";
        }
        try {
            data.setMenuurl(data.getMenuurl().trim());
            commfacade.insertMenus(data);
        }
        catch (XLRuntimeException e) {
            this.mergeBean((Object)e.getMessage(), "jsmessage");
        }
        this.getQueryMenuslist();
        return "";
    }

    public String delete() {
        this.authenticateDel();
        commfacade.removeMenus(this.findParamSeqid());
        return "";
    }

    public String deleteSome() {
        this.authenticateDel();
        try {
            commfacade.removeMenus(this.findParamSeqids());
        }
        catch (XLRuntimeException e) {
            this.alertJS(e.getMessage());
        }
        this.getQueryMenuslist();
        return "";
    }

    public String edit() {
        this.authenticateEdit();
        Menus data = this.findBean(Menus.class);
        if (data.getMenuno().length() > 9) {
            this.mergeBean((Object)"\u83dc\u5355\u7ea7\u6570\u5df2\u7ecf\u8d85\u8fc7\u6700\u5927\u503c", "jsmessage");
            return "";
        }
        try {
            commfacade.editMenus(data);
        }
        catch (XLRuntimeException e) {
            this.mergeBean((Object)e.getMessage(), "jsmessage");
        }
        this.getQueryMenuslist();
        return "";
    }

    public String exchangeOrder() {
        String menuno = super.findParameter("exchangeOrder_no");
        String pmenuno = super.findParameter("exchangeOrder_pno");
        String displayno = super.findParameter("exchangeOrder_display");
        String way = super.findParameter("exchangeOrder_way");
        String waymsg = "1".equals(way) ? "\u4e0a\u79fb" : "\u4e0b\u79fb";
        System.out.println("\u83dc\u5355(" + menuno + ")\u663e\u793a\u987a\u5e8f(" + displayno + ")" + waymsg);
        boolean flag = commfacade.exchangeMenuOrder(menuno, pmenuno, displayno, way);
        if (flag) {
            this.alertJS(waymsg + "\u83dc\u5355\u6210\u529f");
        } else {
            this.alertJS("\u83dc\u5355\u4e0d\u80fd\u8fdb\u884c" + waymsg);
        }
        this.getQueryMenuslist();
        return "";
    }

    public String goedit() {
        long seqid = Long.valueOf(this.findParameter("seqid"));
        this.mergeBean(commfacade.getMenusById(seqid));
        return "go_edit";
    }

    public List<SelectItem> getPMenus() {
        ArrayList<SelectItem> list = (ArrayList<SelectItem>)this.getRequestAttribute("allpmenus");
        if (list == null) {
            list = new ArrayList<SelectItem>();
            List<Menus> menusList = commfacade.getAllPMenus();
            for (Menus m : menusList) {
                list.add(new SelectItem((Object)m.getMenuno(), m.getMenuname()));
            }
            this.setRequestAttribute("allpmenus", list);
        }
        return list;
    }

    public List<SelectItem> getUserPMenus() {
        UserInfo userInfo = this.currentUserInfo();
        if (pmenusMap.containsKey(userInfo.getUserlogno())) {
            return pmenusMap.get(userInfo.getUserlogno());
        }
        List lastlist = (List)this.getRequestAttribute("mypmenus");
        if (lastlist == null) {
            ArrayList<SelectItem> list = new ArrayList<SelectItem>();
            String defaultMenuno = null;
            Users users = new Users();
            users.setUserlogno(userInfo.getUserlogno());
            Sheet<UserToRole> sheet = commfacade.getRolesByUser(users, null);
            List roleList = (List)sheet.getDatas();
            if (roleList != null && roleList.size() > 0) {
                for (UserToRole u : roleList) {
                    if (!this.isNotEmpty(u.getClassitemid())) continue;
                    defaultMenuno = u.getClassitemid();
                }
                if (this.isEmpty(defaultMenuno)) {
                    defaultMenuno = ((UserToRole)roleList.get(0)).getClassitemid();
                }
            }
            if (userInfo.isSuperman()) {
                List<Menus> menusList = commfacade.getAllPMenus();
                for (Menus m : menusList) {
                    list.add(new SelectItem((Object)m.getMenuno(), m.getMenuname()));
                }
            } else {
                List<String> pList = commfacade.getRunPMenusByUserLogo(userInfo.getUserlogno());
                Menus parent = null;
                boolean isHave = false;
                for (String pmenuno : pList) {
                    isHave = false;
                    parent = commfacade.getMenusByMenuNo(pmenuno);
                    while (parent != null && !parent.getPmenuno().equals("0")) {
                        parent = commfacade.getMenusByMenuNo(parent.getPmenuno());
                    }
                    for (SelectItem item : list) {
                        if (!item.getValue().equals(parent.getMenuno())) continue;
                        isHave = true;
                        break;
                    }
                    if (isHave) continue;
                    list.add(new SelectItem((Object)parent.getMenuno(), parent.getMenuname()));
                }
            }
            if (this.isNotEmpty(defaultMenuno)) {
                for (SelectItem item : list) {
                    if (!defaultMenuno.equals(item.getValue())) continue;
                    list.add(0, new SelectItem(item.getValue(), "\u6211\u7684\u5de5\u4f5c\u53f0"));
                    list.remove(item);
                    break;
                }
            }
            this.setRequestAttribute("mypmenus", list);
            return list;
        }
        return lastlist;
    }

    public String getShowNavi() {
        boolean shownavi = ApplicationConfigUtil.getShownavi();
        String shownaviStr = this.getCookie("shownavi");
        if (StringTools.isNotEmpty(shownaviStr)) {
            shownavi = shownaviStr.equals("t");
        }
        return shownavi ? "true" : "false";
    }

    public String getMenusByUserModule() {
        String moduleNo = this.findParameter("moduleNo");
        if (this.isEmpty(moduleNo)) {
            boolean shownavi = ApplicationConfigUtil.getShownavi();
            String shownaviStr = this.getCookie("shownavi");
            if (StringTools.isNotEmpty(shownaviStr)) {
                boolean bl = shownavi = shownaviStr.equals("t");
            }
            if (shownavi) {
                List<SelectItem> userPMenus = this.getUserPMenus();
                if (userPMenus != null && userPMenus.size() > 0) {
                    moduleNo = userPMenus.get(0).getValue().toString();
                }
            } else {
                moduleNo = "0";
            }
        }
        String modulename = this.findParameter("moduleName");
        UserInfo userInfo = this.currentUserInfo();
        if (this.isEmpty(moduleNo)) {
            Users users = new Users();
            users.setUserlogno(userInfo.getUserlogno());
            Sheet<UserToRole> sheet = commfacade.getRolesByUser(users, null);
            List list = (List)sheet.getDatas();
            for (UserToRole u : list) {
                if (!this.isNotEmpty(u.getClassitemid())) continue;
                moduleNo = u.getClassitemid();
                this.moduleName = u.getItemname();
            }
            if (this.isEmpty(moduleNo) && list.size() > 0) {
                moduleNo = ((UserToRole)list.get(0)).getClassitemid();
                this.moduleName = ((UserToRole)list.get(0)).getItemname();
            }
        } else {
            this.moduleName = modulename;
        }
        return this.getANodeMenusString(moduleNo);
    }

    private String getANodeMenusString(String moduleNo) {
        UserInfo userInfo = this.currentUserInfo();
        if (menusMap.containsKey(userInfo.getUserlogno()) && menusMap.get(userInfo.getUserlogno()).containsKey(moduleNo)) {
            return menusMap.get(userInfo.getUserlogno()).get(moduleNo);
        }
        List<Menus> listMenus = null;
        if (userInfo.isSuperman()) {
            listMenus = commfacade.getAllMenusByPMenuno(moduleNo);
        } else {
            listMenus = commfacade.getRunMenusByPMenuno(userInfo.getUserlogno(), moduleNo);
            ArrayList<Menus> result = new ArrayList<Menus>(30);
            for (Menus menu : listMenus) {
                if (!result.contains(menu)) {
                    result.add(menu);
                }
                Menus parent = menu;
                while ((parent = commfacade.getMenusByMenuNo(parent.getPmenuno())) != null && !result.contains(parent)) {
                    result.add(parent);
                }
            }
            listMenus = result;
        }
        String v = this.formatMenus(listMenus, moduleNo);
        menusMap.get(userInfo.getUserlogno()).put(moduleNo, v);
        return v;
    }

    public void getMenusByPMenus(String menuno) {
        this.getANodeMenusString(menuno);
    }

    private String genTreeNode(List<Menus> menus, String parentno, String indent, int deep) {
        String root = this.getHttpServletRequest().getContextPath();
        StringBuilder sb = new StringBuilder();
        int currentLevelNodeCount = 0;
        String ci = indent + "         ";
        ArrayList<Menus> currentMenus = new ArrayList<Menus>();
        for (Menus m : menus) {
            if (!m.getPmenuno().equals(parentno)) continue;
            currentMenus.add(m);
            if (++currentLevelNodeCount == 1) {
                sb.append(ci);
                sb.append("<div class='treelist tldep");
                sb.append(deep);
                if (deep > 1) {
                    sb.append(" noroot");
                }
                sb.append("' deep='" + deep + "'>\r\n");
            }
            sb.append(ci);
            sb.append("<span class='treenode tndep");
            sb.append(deep);
            sb.append("' deep='" + deep + "' id='tn").append(m.getMenuno()).append("'>");
            sb.append("<a");
            if (StringTools.isNotEmpty(m.getMenutarget())) {
                sb.append(" target='").append(m.getMenutarget()).append("' ");
            }
            if (StringTools.isNotEmpty(m.getMenuurl())) {
                sb.append(" href='").append(root).append(m.getMenuurl()).append("' ");
            } else {
                sb.append(" href='javascript:void(0);' ");
            }
            sb.append(">");
            sb.append(m.getMenuname());
            sb.append("</a>");
            sb.append("</span>\r\n");
            sb.append(this.genTreeNode(menus, m.getMenuno(), ci, deep + 1));
        }
        if (currentLevelNodeCount > 0) {
            sb.append(ci);
            sb.append("</div>\r\n");
        }
        return sb.toString();
    }

    public String formatMenus(List<Menus> listMenus, String moduleNo) {
        String pno;
        if (listMenus == null || listMenus.size() == 0) {
            return "";
        }
        String trees = this.genTreeNode(listMenus, pno, "    ", "0".equals(pno = moduleNo) ? 1 : 2);
        trees = "\r\n<div id='treedata'>\r\n" + trees + "</div>\r\n";
        if (!menusMap.containsKey(this.currentUserInfo().getUserlogno())) {
            menusMap.put(this.currentUserInfo().getUserlogno(), new HashMap());
        }
        menusMap.get(this.currentUserInfo().getUserlogno()).put(moduleNo, trees);
        return trees;
    }

    public void constantMenus() {
        UserInfo userInfo = this.currentUserInfo();
        String userlogno = userInfo.getUserlogno();
        if (pmenusMap.containsKey(userlogno)) {
            pmenusMap.remove(userlogno);
        }
        pmenusMap.put(userlogno, this.getUserPMenus());
        if (menusMap.containsKey(userlogno)) {
            menusMap.remove(userlogno);
        }
        menusMap.put(userlogno, new HashMap());
        List<SelectItem> list = pmenusMap.get(userlogno);
        if (list != null) {
            for (SelectItem item : list) {
                this.getMenusByPMenus((String)item.getValue());
            }
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        if (this.isNotEmpty(moduleName)) {
            this.moduleName = moduleName;
        }
    }
}

