/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.common.vo.UserToRole;
import com.xunlei.common.vo.Users;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;

public abstract class LoginTool {
    public static UserInfo login(HttpServletRequest request, String userlogo) {
        Users user = null;
        try {
            user = IFacadeCommon.INSTANCE.getUsersByUserLogNo(userlogo);
        }
        catch (Exception ex) {
            return null;
        }
        if (user == null) {
            return null;
        }
        if (StringTools.isNotEmpty(user.getUpuserlogno())) {
            return null;
        }
        if (StringTools.isNotEmpty(user.getBindip())) {
            String[] strs = user.getBindip().split(",");
            String ip = request.getRemoteAddr();
            boolean illed = true;
            for (String s : strs) {
                if (!ip.equals(s.trim())) continue;
                illed = false;
                break;
            }
            if (illed) {
                return null;
            }
        }
        if (user.getInuse() != 1) {
            return null;
        }
        if (StringTools.isNotEmpty(user.getStartvaliddate()) && user.getStartvaliddate().compareTo(DatetimeUtil.today()) > 0) {
            return null;
        }
        if (StringTools.isNotEmpty(user.getEndvaliddate()) && user.getEndvaliddate().compareTo(DatetimeUtil.today()) < 0) {
            return null;
        }
        ArrayList<String> sysroles = new ArrayList<String>(3);
        ArrayList<String> recroles = new ArrayList<String>(3);
        for (UserToRole utr : user.getRoles()) {
            if ("SYS".equals(utr.getRoletype())) {
                sysroles.add(utr.getRoleno());
                continue;
            }
            if (!"REC".equals(utr.getRoletype())) continue;
            recroles.add(utr.getRoleno());
        }
        UserInfo userinfo = new UserInfo(userlogo, user.getTruename(), sysroles.toArray(new String[sysroles.size()]), recroles.toArray(new String[recroles.size()]), user.getSuperman() > 0, IFacadeCommon.INSTANCE.getIfMyDataOnly(userlogo), user.getWorkingplatform(), user.isBoolsinglelogin());
        String[] usermailclassid = IFacadeCommon.INSTANCE.queryMailclassidbyusername(userlogo);
        userinfo.setMailclassids(usermailclassid);
        return userinfo;
    }
}

