/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.vo;

import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.Extendable;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.LibClassD;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibClassM
implements Serializable {
    @Extendable
    private static Logger logger = Logger.getLogger(LibClassM.class);
    @Extendable
    private static Map<String, Map<String, LibClassD>> LibClassMMap = new HashMap<String, Map<String, LibClassD>>();
    private long seqid = 0L;
    private String classno;
    private String classname;
    private String remark = "";
    private String editby;
    private String edittime;

    public static void loadLibClassM(String classno) {
        if (LibClassMMap == null) {
            LibClassMMap = new HashMap<String, Map<String, LibClassD>>();
        }
        LibClassD lcd = new LibClassD();
        lcd.setClassno(classno);
        List list = (List)IFacadeCommon.INSTANCE.queryLibClassds(lcd, null).getDatas();
        if (list == null || list.size() == 0) {
            throw new XLRuntimeException("\u65e0\u5339\u914d\u7684LibClassD\u6570\u636e, classno=" + classno);
        }
        LinkedHashMap<String, LibClassD> libClassDMap = new LinkedHashMap<String, LibClassD>();
        for (LibClassD one : list) {
            libClassDMap.put(one.getItemno(), one);
        }
        LibClassMMap.put(classno, libClassDMap);
        logger.debug("\u8f7d\u5165 classno=" + classno + " \u7684\u53c2\u6570\u5b8c\u6210");
    }

    public static void clearLibClassM(String classno) {
        if (LibClassMMap == null) {
            return;
        }
        if (LibClassMMap.containsKey(classno)) {
            LibClassMMap.remove(classno);
        }
        logger.debug("\u7f6e\u7a7a classno=" + classno + " \u7684\u53c2\u6570\u5b8c\u6210");
    }

    public static Map<String, LibClassD> getLibClassDMap(String classno) {
        if (LibClassMMap == null || !LibClassMMap.containsKey(classno)) {
            LibClassM.loadLibClassM(classno);
        }
        return LibClassMMap.get(classno);
    }

    public static List<LibClassD> getLibClassDList(String classno) {
        Map<String, LibClassD> map = LibClassM.getLibClassDMap(classno);
        ArrayList<LibClassD> list = new ArrayList<LibClassD>();
        for (Map.Entry<String, LibClassD> entry : map.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }

    public static Map<String, String> getStringValues(String classno) {
        List<LibClassD> list = LibClassM.getLibClassDList(classno);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(list.size());
        for (LibClassD d : list) {
            map.put(d.getItemno(), d.getItemname());
        }
        return map;
    }

    public static LibClassD getLibClassDVo(String classno, String itemno) {
        Map<String, LibClassD> map = LibClassM.getLibClassDMap(classno);
        if (map == null || !map.containsKey(itemno)) {
            throw new XLRuntimeException("\u65e0\u5339\u914d\u53c2\u6570 LibClassD(classno, itemno)=(" + classno + ", " + itemno + ")");
        }
        return map.get(itemno);
    }

    public static String getLibClassDValue(String classno, String itemno) {
        return LibClassM.getLibClassDVo(classno, itemno).getItemvalue();
    }

    public LibClassM() {
    }

    public LibClassM(String classno, String classname, String editby, String edittime) {
        this.classno = classno;
        this.classname = classname;
        this.editby = editby;
        this.edittime = edittime;
    }

    public LibClassM(String classno, String classname, String remark, String editby, String edittime) {
        this.classno = classno;
        this.classname = classname;
        this.remark = remark;
        this.editby = editby;
        this.edittime = edittime;
    }

    public long getSeqid() {
        return this.seqid;
    }

    public void setSeqid(long seqid) {
        this.seqid = seqid;
    }

    public String getClassno() {
        return this.classno;
    }

    public void setClassno(String classno) {
        this.classno = classno;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getEditby() {
        return this.editby;
    }

    public void setEditby(String editby) {
        this.editby = editby;
    }

    public String getEdittime() {
        return this.edittime;
    }

    public void setEdittime(String edittime) {
        this.edittime = edittime;
    }
}

