/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import com.xunlei.common.util.MD5Hash;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.base64.BASE64Decoder;
import com.xunlei.common.util.base64.BASE64Encoder;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserCookie<T> {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String cookiePath = "/";
    private String cookieDomain = null;
    protected static final Logger logger = Logger.getLogger(UserCookie.class);

    public UserCookie(HttpServletRequest request, HttpServletResponse response, String cookiePath, String cookieDomain) {
        this.request = request;
        this.response = response;
        if (cookiePath != null) {
            this.cookiePath = cookiePath;
        }
        this.cookieDomain = cookieDomain;
    }

    public void addC(String name, String value, int maxage) {
        Cookie cookies = new Cookie(name, value);
        cookies.setPath(this.cookiePath);
        if (maxage > 0) {
            cookies.setMaxAge(maxage);
        } else {
            cookies.setMaxAge(-1);
        }
        if (StringTools.isNotEmpty(this.cookieDomain)) {
            cookies.setDomain(this.cookieDomain);
        }
        this.response.addCookie(cookies);
    }

    public void addDESC(String name, String value, int maxage) {
        try {
            BASE64Encoder base64Encoder = new BASE64Encoder();
            value = StringTools.encodeURL(base64Encoder.encode(value.getBytes()));
            Cookie cookies = new Cookie(name, value);
            if (maxage > 0) {
                cookies.setMaxAge(maxage);
            } else {
                cookies.setMaxAge(-1);
            }
            cookies.setPath(this.cookiePath);
            if (StringTools.isNotEmpty(this.cookieDomain)) {
                cookies.setDomain(this.cookieDomain);
            }
            this.response.addCookie(cookies);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addCByArrays(String[][] values, int maxage) {
        for (String[] value : values) {
            this.addDESC(value[0], value[1], maxage);
        }
    }

    public void addCByObject(Object obj, int maxage) {
        try {
            String fname = "";
            Method method = null;
            Class<?> clazz = obj.getClass();
            String cname = clazz.toString().substring(clazz.toString().lastIndexOf(46) + 1).toLowerCase();
            ArrayList<String> totalStringList = new ArrayList<String>();
            String fvalue = "";
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                fname = field.getName();
                method = clazz.getDeclaredMethod(UserCookie.capitalize(field), new Class[0]);
                fvalue = UserCookie.getValues(method.invoke(obj, new Object[0]));
                totalStringList.add(fvalue);
                this.addDESC(fname, fvalue, maxage);
            }
            String strs = StringTools.ArrayToSortString(totalStringList);
            logger.debug("before md5 str:" + strs);
            String hashed = MD5Hash.hash(strs);
            this.addC(cname, hashed, maxage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getCByobject(Class clazz) {
        try {
            String fname = "";
            String fvalue = null;
            Method method = null;
            String cname = clazz.toString().substring(clazz.toString().lastIndexOf(46) + 1).toLowerCase();
            ArrayList<String> totalStringList = new ArrayList<String>();
            BASE64Decoder base64Decoder = new BASE64Decoder();
            Object indata = clazz.newInstance();
            Cookie[] cookies = this.request.getCookies();
            Object[] in = new Object[1];
            boolean ishavecookie = false;
            if (cookies != null && cookies.length > 0) {
                for (Field field : clazz.getDeclaredFields()) {
                    ishavecookie = false;
                    if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                    fname = field.getName();
                    fvalue = "";
                    for (int i = 0; i < cookies.length; ++i) {
                        if (!fname.equals(cookies[i].getName())) continue;
                        ishavecookie = true;
                        if (cookies[i].getValue().isEmpty()) break;
                        fvalue = new String(base64Decoder.decodeBuffer(StringTools.decodeURL(cookies[i].getValue())));
                        totalStringList.add(fvalue);
                        break;
                    }
                    if (!ishavecookie || fvalue == null) continue;
                    method = clazz.getDeclaredMethod("set" + UserCookie.capitalize(fname), field.getType());
                    if (field.getType() == String.class) {
                        method.invoke(indata, fvalue);
                        continue;
                    }
                    if (field.getType() == Boolean.TYPE) {
                        method.invoke(indata, Boolean.valueOf(fvalue));
                        continue;
                    }
                    if (field.getType() == Byte.TYPE) {
                        method.invoke(indata, Byte.valueOf(fvalue));
                        continue;
                    }
                    if (field.getType() == Short.TYPE) {
                        method.invoke(indata, Short.valueOf(fvalue));
                        continue;
                    }
                    if (field.getType() == Integer.TYPE) {
                        method.invoke(indata, Integer.valueOf(fvalue));
                        continue;
                    }
                    if (field.getType() == Long.TYPE) {
                        method.invoke(indata, Long.valueOf(fvalue));
                        continue;
                    }
                    if (field.getType() == Float.TYPE) {
                        method.invoke(indata, Float.valueOf(fvalue));
                        continue;
                    }
                    if (field.getType() == Double.TYPE) {
                        method.invoke(indata, Double.valueOf(fvalue));
                        continue;
                    }
                    if (field.getType() != String[].class) continue;
                    String[] values = StringTools.isEmpty(fvalue) ? new String[]{} : fvalue.split("\\|");
                    in[0] = values;
                    method.invoke(indata, in);
                }
                for (int i = 0; i < cookies.length; ++i) {
                    if (!cname.equals(cookies[i].getName())) continue;
                    fvalue = new String(cookies[i].getValue());
                    break;
                }
            }
            if (StringTools.isEmpty(fvalue)) {
                return null;
            }
            String strs = StringTools.ArrayToSortString(totalStringList);
            logger.debug("before md5 str:" + strs);
            String hashed = MD5Hash.hash(strs);
            if (!fvalue.equals(hashed)) {
                return null;
            }
            return indata;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getCookie(String name, boolean isDecoder) {
        Cookie[] cookies = this.request.getCookies();
        Cookie sCookie = null;
        try {
            BASE64Decoder base64Decoder = new BASE64Decoder();
            if (cookies != null && cookies.length > 0) {
                for (int i = 0; i < cookies.length; ++i) {
                    sCookie = cookies[i];
                    if (!sCookie.getName().equals(name)) continue;
                    if (isDecoder) {
                        return new String(base64Decoder.decodeBuffer(sCookie.getValue()));
                    }
                    return sCookie.getValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String capitalize(Field field) {
        String pre = "get";
        String name = field.getName();
        if (field.getType() == Boolean.TYPE) {
            pre = "is";
        }
        return pre + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public void delObject(Class clazz) {
        String cname = clazz.toString().substring(clazz.toString().lastIndexOf(46) + 1).toLowerCase();
        Cookie cookie = new Cookie(cname, null);
        cookie.setMaxAge(0);
        cookie.setValue(null);
        cookie.setPath(this.cookiePath);
        this.response.addCookie(cookie);
    }

    private static String getValues(Object obj) {
        if (obj != null) {
            if (obj instanceof String[]) {
                String[] values;
                StringBuilder sb = new StringBuilder();
                for (String s : values = (String[])obj) {
                    sb.append(s).append("|");
                }
                if (sb.length() > 0) {
                    return sb.substring(0, sb.length() - 1);
                }
            } else {
                return obj.toString();
            }
        }
        return "";
    }

    public static void main(String[] args) {
        try {
            String value = "admin";
            BASE64Encoder base64Encoder = new BASE64Encoder();
            value = base64Encoder.encode(value.getBytes());
            System.out.println(value);
            BASE64Decoder base64Decoder = new BASE64Decoder();
            value = new String(base64Decoder.decodeBuffer("YzM2ZjI2NTQzZGZlY2M5Yzk1MTFmNGY2YTMxY2RlMWI="));
            System.out.println(value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

