/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import com.xunlei.common.util.MailHost;
import com.xunlei.common.util.MailParams;
import com.xunlei.common.util.XLMailException;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

public class MailUtil {
    private static Logger logger = Logger.getLogger(MailUtil.class);
    private Session session;
    private Transport transport;
    private MailParams mailparms;
    private MailHost user;
    private final String MAIL_SMTP_HOST = "mail.smtp.host";
    private final String MAIL_SMTP_AUTH = "mail.smtp.auth";

    public MailUtil(MailHost user) {
        this.user = user;
    }

    public MailUtil(String host, String username, String password) {
        MailHost user;
        this.user = user = new MailHost(host, username, password);
    }

    public MailUtil(String host, String username, String password, String fromaddress) {
        MailHost user;
        this.user = user = new MailHost(host, username, password, fromaddress);
    }

    private void init() {
        Authenticator auth = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailUtil.this.user.getUsername(), MailUtil.this.user.getPassword());
            }
        };
        Properties props = new Properties();
        props.put("mail.smtp.host", this.user.getHost());
        props.put("mail.smtp.auth", "true");
        this.session = Session.getDefaultInstance(props, auth);
        try {
            this.transport = this.session.getTransport("smtp");
            this.transport.connect(this.user.getHost(), this.user.getUsername(), this.user.getPassword());
            logger.info("\u4e0e " + this.user.getHost() + " \u6210\u529f\u5efa\u7acb\u4f1a\u8bdd");
        }
        catch (MessagingException e) {
            throw new XLMailException("\u4e0e\u90ae\u4ef6\u670d\u52a1\u5668\u5efa\u7acb\u8fde\u63a5\u5931\u8d25", "01");
        }
    }

    private Message createMessage() {
        MimeMessage message = new MimeMessage(this.session);
        try {
            String subject;
            message.setFrom(new InternetAddress(this.user.getFromaddress()));
            message.setSentDate(new Date());
            if (this.mailparms.getToaddress() == null || this.mailparms.getToaddress().length == 0) {
                throw new XLMailException("\u6536\u4ef6\u4eba\u5730\u5740\u4e0d\u5b58\u5728", "02");
            }
            if (!MailUtil.isEmail(this.mailparms.getToaddress())) {
                throw new XLMailException("\u6536\u4ef6\u4eba\u5730\u5740\u683c\u5f0f\u6709\u8bef", "03");
            }
            message.addRecipients(Message.RecipientType.TO, this.getAddress(this.mailparms.getToaddress()));
            if (this.mailparms.getCcaddress() != null && this.mailparms.getCcaddress().length > 0) {
                if (!MailUtil.isEmail(this.mailparms.getCcaddress())) {
                    throw new XLMailException("\u6284\u9001\u4eba\u5730\u5740\u683c\u5f0f\u6709\u8bef", "04");
                }
                message.addRecipients(Message.RecipientType.CC, this.getAddress(this.mailparms.getCcaddress()));
            }
            if (this.mailparms.getBccaddress() != null && this.mailparms.getBccaddress().length > 0) {
                if (!MailUtil.isEmail(this.mailparms.getBccaddress())) {
                    throw new XLMailException("\u6697\u9001\u4eba\u5730\u5740\u683c\u5f0f\u6709\u8bef", "05");
                }
                message.addRecipients(Message.RecipientType.BCC, this.getAddress(this.mailparms.getBccaddress()));
            }
            if ((subject = this.mailparms.getSubject()) == null) {
                subject = "";
            }
            message.setSubject(subject);
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart contentPart = new MimeBodyPart();
            String content = this.mailparms.getContent();
            if (content == null) {
                content = "";
            }
            if (this.mailparms.isMimeContent()) {
                contentPart.setContent(content, "text/html;charset=GBK");
            } else {
                contentPart.setText(content);
            }
            multipart.addBodyPart(contentPart);
            if (this.mailparms.isAffixFlag()) {
                String[] affixPaths = this.mailparms.getAffixPath();
                String[] affixNames = this.mailparms.getAffixName();
                if (null == affixPaths || affixPaths.length <= 0) {
                    throw new XLMailException("\u627e\u4e0d\u5230\u90ae\u4ef6\u9644\u4ef6", "06");
                }
                int index = 0;
                for (String path : affixPaths) {
                    MimeBodyPart affixBody = new MimeBodyPart();
                    File file = new File(path);
                    if (!file.exists()) {
                        throw new XLMailException("\u627e\u4e0d\u5230\u90ae\u4ef6\u9644\u4ef6", "06");
                    }
                    FileDataSource source = new FileDataSource(path);
                    affixBody.setDataHandler(new DataHandler(source));
                    BASE64Encoder enc = new BASE64Encoder();
                    String affixnameitem = "";
                    if (affixNames.length > index) {
                        affixnameitem = affixNames[index];
                    }
                    String fileName = "=?GBK?B?" + enc.encode(affixnameitem.getBytes()) + "?=";
                    affixBody.setFileName(fileName);
                    ++index;
                    multipart.addBodyPart(affixBody);
                }
            }
            message.setContent(multipart);
            message.saveChanges();
        }
        catch (MessagingException e) {
            throw new XLMailException(e.getCause(), "99");
        }
        return message;
    }

    private static boolean isEmail(String[] str) {
        Pattern p = Pattern.compile("[\\w-\\.]+@[\\w-]+(\\.[\\w-]+)");
        if (str != null || str.length > 0) {
            for (int i = 0; i < str.length; ++i) {
                Matcher m = p.matcher(str[i]);
                if (m.find()) continue;
                return false;
            }
        }
        return true;
    }

    private Address[] getAddress(String[] address) throws AddressException {
        Address[] addrs = new InternetAddress[address.length];
        for (int i = 0; i < address.length; ++i) {
            addrs[i] = new InternetAddress(address[i]);
        }
        return addrs;
    }

    private void setMailparams(MailParams params) {
        this.mailparms = params;
    }

    public String send(MailParams params) {
        String rtncode = "00";
        try {
            this.init();
            this.session.setDebug(true);
            this.setMailparams(params);
            Message message = this.createMessage();
            this.transport.sendMessage(message, message.getAllRecipients());
            logger.info("\n----------------------------------------------------------");
            logger.info("- \u90ae\u4ef6\u6210\u529f\u53d1\u9001\uff01");
            logger.info("- TO : " + Arrays.toString(this.mailparms.getToaddress()));
            logger.info("----------------------------------------------------------\n");
            this.close();
        }
        catch (XLMailException e) {
            rtncode = e.getCode();
        }
        catch (MessagingException e) {
            String errmsg = e.getMessage();
            rtncode = errmsg != null && errmsg.indexOf("Invalid Addresses") != -1 ? "02" : "99";
        }
        return rtncode;
    }

    private void close() throws MessagingException {
        if (null != this.transport) {
            this.transport.close();
        }
    }
}

