/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.testbase.DefaultDataSourceProvider;
import com.xunlei.common.testbase.InitJndiDataSource;
import com.xunlei.common.util.ScriptBlock;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.LibConfig;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InitDatabase {
    static final Pattern blockPattern = Pattern.compile("##begin\\s+(\\w+)\\[(\\w*)\\|(\\d*\\.*\\d*)\\|(\\w*)\\](.*)##end\\s+(\\1)", 32);
    static final String initScriptName = "InitScript";
    static ScriptBlock initScriptBlock = null;
    static ScriptBlock firstScriptBlock = null;
    static List<ScriptBlock> scriptBlocks = new ArrayList<ScriptBlock>();

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        double currentVersion = 0.0;
        boolean isSqlInfo = true;
        String url = null;
        String user = null;
        String pwd = null;
        String task = "C";
        double updateToVersion = 0.0;
        if (args != null) {
            for (String string : args) {
                if (string.startsWith("-url")) {
                    url = string.substring(4);
                    System.out.println("\u6570\u636e\u5e93\u8fde\u63a5\uff1a" + url);
                    continue;
                }
                if (string.startsWith("-user")) {
                    user = string.substring(5);
                    System.out.println("\u6570\u636e\u5e93\u8fde\u63a5\u7528\u6237\uff1a" + user);
                    continue;
                }
                if (string.startsWith("-pwd")) {
                    pwd = string.substring(4);
                    System.out.println("\u6570\u636e\u5e93\u8fde\u63a5\u5bc6\u7801\uff1a" + pwd);
                    continue;
                }
                if (string.startsWith("-task")) {
                    task = string.substring(5).toUpperCase();
                    System.out.println("\u64cd\u4f5c\u4efb\u52a1\uff1a" + task);
                    continue;
                }
                if (!string.startsWith("-uv")) continue;
                updateToVersion = Double.parseDouble(string.substring(3));
                System.out.println("\u5347\u7ea7\u5230\u7684\u7248\u672c\uff1a" + updateToVersion);
            }
        }
        if (StringTools.isEmpty(url) || StringTools.isEmpty(user) || StringTools.isEmpty(pwd)) {
            System.out.println("\u6570\u636e\u5e93\u8fde\u63a5\u7684\u76f8\u5173\u53c2\u6570\u4e0d\u80fd\u6709\u4e3a\u7a7a\uff01\u7a0b\u5e8f\u5c06\u9000\u51fa");
            System.exit(0);
        }
        StringBuilder sb = new StringBuilder();
        try {
            void var13_18;
            InputStream in = InitDatabase.class.getResourceAsStream("/initscript.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String string = br.readLine();
            while (var13_18 != null) {
                sb.append((String)var13_18).append("\r\n");
                String string2 = br.readLine();
            }
            br.close();
        }
        catch (Exception ex) {
            System.out.println("\u8bf7\u5728\u7c7b\u9ed8\u8ba4\u8def\u5f84\u4e0b\u786e\u8ba4\u6709initscript.txt\u8fd9\u4e2a\u6587\u4ef6");
            System.exit(0);
        }
        Matcher m = blockPattern.matcher(sb);
        while (m.find()) {
            ScriptBlock scriptBlock = new ScriptBlock(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5));
            if (m.group(1).equals(initScriptName)) {
                initScriptBlock = scriptBlock;
                continue;
            }
            scriptBlocks.add(scriptBlock);
        }
        for (ScriptBlock scriptBlock : scriptBlocks) {
            if (!StringTools.isNotEmpty(scriptBlock.getNextScriptName())) continue;
            scriptBlock.setNextBlock(InitDatabase.getScriptBlock(scriptBlock.getNextScriptName()));
        }
        for (ScriptBlock scriptBlock : scriptBlocks) {
            if (!InitDatabase.isFirstScriptBlock(scriptBlock)) continue;
            firstScriptBlock = scriptBlock;
            break;
        }
        new InitJndiDataSource(new DefaultDataSourceProvider(url, user, pwd)).init();
        IFacadeCommon facade = IFacadeCommon.INSTANCE;
        System.out.println("\u521d\u59cb\u5316\u6570\u636e\u5e93\u64cd\u4f5c\u5b8c\u6210");
        String string = LibConfig.getValue("Version");
        currentVersion = StringTools.isEmpty(string) ? 0.0 : Double.parseDouble(string);
        System.out.println("\u5f53\u524d\u6570\u636e\u5e93\u7248\u672c\u53f7\uff1a" + currentVersion + ",\u9700\u8981\u5347\u7ea7\u5230\u7684\u7248\u672c\u53f7\uff1a" + updateToVersion);
        if (currentVersion >= updateToVersion) {
            System.out.println("\u65e0\u6cd5\u964d\u7ea7\uff0c\u7a0b\u5e8f\u5c06\u9000\u51fa");
            System.exit(0);
        }
        for (ScriptBlock script = firstScriptBlock; script != null; script = script.getNextBlock()) {
            if (script.wantRun(task, currentVersion, updateToVersion)) {
                if (initScriptBlock != null) {
                    String initSql = initScriptBlock.getNextSql();
                    while (StringTools.isNotEmpty(initSql)) {
                        if (isSqlInfo) {
                            InitDatabase.outConsole(initSql);
                        }
                        facade.execUpdSql(initSql);
                        initSql = initScriptBlock.getNextSql();
                    }
                }
                System.out.println("\u6267\u884c\u811a\u672c\u6bb5\uff1a" + script.getScriptName());
                String sql = script.getNextSql();
                while (StringTools.isNotEmpty(sql)) {
                    if (isSqlInfo) {
                        InitDatabase.outConsole(sql);
                    }
                    facade.execUpdSql(sql);
                    sql = script.getNextSql();
                }
                continue;
            }
            System.out.println("\u4e0d\u6267\u884c\u811a\u672c\u6bb5\uff1a" + script.getScriptName());
        }
        System.out.println("\u6570\u636e\u5e93\u8868\u64cd\u4f5c\u5b8c\u6210");
    }

    private static ScriptBlock getScriptBlock(String name) {
        for (ScriptBlock s : scriptBlocks) {
            if (!s.getScriptName().equals(name)) continue;
            return s;
        }
        return null;
    }

    private static boolean isFirstScriptBlock(ScriptBlock s) {
        int nextCount = 0;
        for (ScriptBlock next = s.getNextBlock(); next != null; next = next.getNextBlock()) {
            ++nextCount;
        }
        return nextCount == scriptBlocks.size() - 1;
    }

    private static void outConsole(String sql) {
        System.out.println("\u6267\u884c\u811a\u672c\uff1a\r\n" + sql);
    }
}

