/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.testbase;

import com.xunlei.common.testbase.DataSourceProvider;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class InitJndiDataSource {
    private DataSourceProvider[] dataSources = null;
    private static final Logger logger = Logger.getLogger(InitJndiDataSource.class);

    public InitJndiDataSource(DataSourceProvider[] dataSources) {
        if (dataSources == null) {
            throw new RuntimeException("\u6570\u636e\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        this.dataSources = dataSources;
    }

    public InitJndiDataSource(DataSourceProvider dataSource) {
        if (dataSource == null) {
            throw new RuntimeException("\u6570\u636e\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        this.dataSources = new DataSourceProvider[]{dataSource};
    }

    public DataSourceProvider[] getDataSources() {
        return this.dataSources;
    }

    public void init() {
        if (this.getDataSources() == null || this.getDataSources().length == 0) {
            logger.warn("\u6ca1\u6709\u53ef\u4ee5\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u63d0\u4f9b\u8005\uff0c\u7a0b\u5e8f\u53ef\u80fd\u5931\u8d25");
            return;
        }
        logger.debug("\u7ed1\u5b9a\u6570\u636e\u6e90");
        System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "org.apache.naming");
        try {
            InitialContext context = new InitialContext();
            try {
                context.createSubcontext("java:comp").createSubcontext("env");
            }
            catch (Exception ex) {
                // empty catch block
            }
            Context subContext = (Context)context.lookup("java:comp/env/");
            for (DataSourceProvider dsp : this.getDataSources()) {
                String contextPath = "java:comp/env/" + dsp.getJndiName();
                try {
                    Object obj = context.lookup(contextPath);
                    if (obj != null) {
                        logger.debug("\u6570\u636e\u6e90" + contextPath + "\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u518d\u8fdb\u884c\u7ed1\u5b9a");
                        continue;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                logger.debug("jndi:" + dsp.getJndiName());
                String[] contextStrs = dsp.getJndiName().split("/");
                Context lastContext = subContext;
                for (int i = 0; i < contextStrs.length - 1; ++i) {
                    try {
                        lastContext = lastContext.createSubcontext(contextStrs[i]);
                        continue;
                    }
                    catch (Exception ex) {
                        lastContext = (Context)lastContext.lookup(contextStrs[i]);
                    }
                }
                lastContext.bind(contextStrs[contextStrs.length - 1], (Object)dsp.getDataSource());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("\u7ed1\u5b9a\u6570\u636e\u6e90\u65f6\u53d1\u751f\u9519\u8bef\uff01" + ex.getMessage());
        }
    }
}

