/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.dao;

import com.xunlei.common.dao.IRolesDao;
import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.Roles;
import com.xunlei.common.vo.Users;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class RolesDaoImpl
extends JdbcBaseDao
implements IRolesDao {
    @Override
    public boolean authByRole(String funno, String operate, String[] roles) {
        String sql = "";
        sql = StringTools.isCommonOperate(operate) ? "select sum(enable" + operate.toLowerCase() + ") from rolerights where funcno='" + funno + "' and ROLENO in " + RolesDaoImpl.unite(roles) : "select count(*) from rolerights where funcno='" + funno + "' and ROLENO in " + RolesDaoImpl.unite(roles) + " and enableplus like '%" + operate + "%'";
        return super.getSingleInt(sql) > 0;
    }

    @Override
    public boolean isNotDataControlByRoles(String[] roles) {
        String sql = "";
        sql = "select count(*) from roles where roleno in " + RolesDaoImpl.unite(roles) + " and datacontrol=0 and roletype='SYS' ";
        return super.getSingleInt(sql) > 0;
    }

    private static String unite(String[] roles) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < roles.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("'").append(roles[i]).append("'");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<Roles> getAllRoles() {
        return this.findObjects(new Roles(), null, null);
    }

    @Override
    public void insertRoles(Roles roles) {
        this.saveObject(roles);
    }

    @Override
    public void updateRoles(Roles roles) {
        this.updateObject(roles);
    }

    @Override
    public void removeRoles(Roles roles) {
        this.deleteObject(roles);
    }

    @Override
    @Deprecated
    public int getSysRolesViewCount(Roles role) {
        String sql = "select count(*) from roles where roletype = 'SYS'";
        return super.getSingleInt(sql);
    }

    @Override
    @Deprecated
    public List<Roles> getSysRolesView(Roles role, String sortColumn, int rowcount, int pagesize, int pageno) {
        final ArrayList<Roles> datas = new ArrayList<Roles>();
        String sql = "select seqid,roleno,rolename,mydataonly,remark from roles where roletype = 'SYS' ";
        if (this.isNotEmpty(sortColumn)) {
            sql = sql + "order by " + sortColumn;
        }
        sql = this.addLimitToSql(sql, rowcount, pagesize, pageno);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Roles data = new Roles();
                data.setSeqid(rs.getLong("seqid"));
                data.setRoleno(rs.getString("roleno"));
                data.setRolename(rs.getString("rolename"));
                data.setRemark(rs.getString("remark"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    @Deprecated
    public int getRecRolesViewCount(Roles role) {
        String sql = "select count(*) from roles where roletype = 'REC'";
        return super.getSingleInt(sql);
    }

    @Override
    @Deprecated
    public List<Roles> getRecRolesView(Roles role, String sortColumn, int rowcount, int pagesize, int pageno) {
        final ArrayList<Roles> datas = new ArrayList<Roles>();
        String sql = "select seqid,roleno,rolename,mydataonly,remark from roles where roletype = 'REC' ";
        if (this.isNotEmpty(sortColumn)) {
            sql = sql + "order by " + sortColumn;
        }
        sql = this.addLimitToSql(sql, rowcount, pagesize, pageno);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Roles data = new Roles();
                data.setSeqid(rs.getLong("seqid"));
                data.setRoleno(rs.getString("roleno"));
                data.setRolename(rs.getString("rolename"));
                data.setRemark(rs.getString("remark"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public Sheet<Roles> queryRecRoles(Roles roles, PagedFliper fliper) {
        StringBuilder where = new StringBuilder("");
        if (roles != null) {
            if (this.isNotEmpty(roles.getRoleno())) {
                where.append(" and roleno = '").append(roles.getRoleno()).append("'");
            }
            if (this.isNotEmpty(roles.getRolename())) {
                where.append(" and rolename like '%" + roles.getRolename() + "%' ");
            }
        }
        String countsql = " select count(*) from roles  where roletype = 'REC'";
        int rowcount = super.getSingleInt(countsql = countsql + where.toString());
        if (rowcount == 0) {
            return Sheet.EMPTY;
        }
        String sql = "select * from roles  where roletype = 'REC'";
        sql = sql + where.toString();
        if (fliper != null) {
            if (fliper.isNotEmptySortColumn()) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet<Roles>(rowcount, this.query(Roles.class, sql, new String[0]));
    }

    @Override
    public Sheet<Roles> querySysRoles(Roles roles, PagedFliper fliper) {
        StringBuilder where = new StringBuilder("");
        if (roles != null) {
            if (this.isNotEmpty(roles.getRoleno())) {
                where.append(" and roleno = '").append(roles.getRoleno()).append("'");
            }
            if (this.isNotEmpty(roles.getRolename())) {
                where.append(" and rolename like '%" + roles.getRolename() + "%' ");
            }
        }
        String countsql = " select count(*) from roles where roletype = 'SYS'";
        int rowcount = super.getSingleInt(countsql = countsql + where.toString());
        if (rowcount == 0) {
            return Sheet.EMPTY;
        }
        String sql = "select * from roles  where roletype = 'SYS'";
        sql = sql + where.toString();
        if (fliper != null) {
            if (fliper.isNotEmptySortColumn()) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet<Roles>(rowcount, this.query(Roles.class, sql, new String[0]));
    }

    @Override
    public List<Roles> getSysRolesByRoles(Roles roles) {
        List<Roles> roleList = null;
        if (roles != null) {
            StringBuilder countsql = new StringBuilder("select * from roles ");
            StringBuilder where = new StringBuilder(" where 1=1 ");
            if (this.isNotEmpty(roles.getRoleno())) {
                where.append(" and roleno='").append(roles.getRoleno()).append("'");
            }
            if (roles.getSeqid() > 0L) {
                where.append(" and seqid=").append(roles.getSeqid());
            }
            if (this.isNotEmpty(roles.getRolename())) {
                where.append(" and rolename='").append(roles.getRolename()).append("'");
            }
            if (this.isNotEmpty(roles.getRoletype())) {
                where.append(" and roletype='").append(roles.getRoletype()).append("'");
            }
            roleList = this.query(Roles.class, countsql.append((CharSequence)where).toString(), new String[0]);
        }
        return roleList;
    }

    @Override
    public List<Roles> getRoles(Roles r) {
        return this.findObjects(r, null, null);
    }

    @Override
    public Roles getARoles(Roles r) {
        return this.findObjectByCondition(r);
    }

    @Override
    public List<Roles> getAllRolesInUsers(Users u) {
        ArrayList<Roles> datas = new ArrayList();
        String sql = "select r.* from roles r where  r.roleno in (select ur.roleno from usertorole ur where userlogno='" + u.getUserlogno() + "')";
        datas = this.query(Roles.class, sql, new String[0]);
        return datas;
    }

    @Override
    public List<Roles> getAllRolesNotInUsers(Users u) {
        ArrayList<Roles> datas = new ArrayList();
        String sql = "select r.* from roles r where  r.roleno not in (select ur.roleno from usertorole ur where userlogno='" + u.getUserlogno() + "')";
        datas = this.query(Roles.class, sql, new String[0]);
        return datas;
    }
}

