/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.dao;

import com.xunlei.common.dao.IPlacardsDao;
import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.Placards;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class PlacardsDaoImpl
extends JdbcBaseDao
implements IPlacardsDao {
    @Override
    public Placards getPlacardsById(long seqid) {
        Placards p = new Placards();
        p.setSeqid(seqid);
        return this.findObject(p);
    }

    @Override
    public Placards insertPlacards(Placards data) {
        return this.saveObject(data);
    }

    @Override
    public void updatePlacards(Placards data) {
        this.updateObject(data);
    }

    @Override
    public void deletePlacardsById(long seqid) {
        Placards p = new Placards();
        p.setSeqid(seqid);
        this.deletePlacards(p);
    }

    @Override
    public void deletePlacards(Placards data) {
        this.deleteObjectByCondition(data, null);
    }

    @Override
    public Sheet<Placards> queryPlacards(Placards data, PagedFliper fliper) {
        int rowcount;
        String sql = "select p.*,pc.classname,pc.previewurl from placards p left join placardclass pc on p.classid = pc.classid and p.flatno = pc.flatno ";
        String countsql = "select count(p.seqid) from placards p left join placardclass pc on p.classid = pc.classid and p.flatno = pc.flatno ";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (null != data) {
            if (this.isNotEmpty(data.getFlatno())) {
                where.append(" and p.flatno = '").append(data.getFlatno()).append("'");
            }
            if (this.isNotEmpty(data.getClassid())) {
                where.append(" and p.classid = '").append(data.getClassid()).append("'");
            }
            if (this.isNotEmpty(data.getPlacardid())) {
                where.append(" and p.placardid = '").append(data.getPlacardid()).append("'");
            }
            if (this.isNotEmpty(data.getTitlelike())) {
                where.append(" and title like '%").append(StringTools.escapeSql(data.getTitlelike())).append("%' ");
            }
            if (data.getQueryinuse() == -1) {
                where.append(" and p.inuse=0");
            } else if (data.getQueryinuse() == 1) {
                where.append(" and p.inuse=1");
            }
            if (data.getQuerycontentflag() == -1) {
                where.append(" and p.contentflag=0");
            } else if (data.getQuerycontentflag() == 1) {
                where.append(" and p.contentflag=1");
            }
            if (data.getQuerydeletedtype() == -1) {
                where.append(" and deleted=0");
            } else if (data.getQuerydeletedtype() == 1) {
                where.append(" and deleted=1");
            }
            if (this.isNotEmpty(data.getSerialid())) {
                where.append(" and p.serialid = '").append(data.getSerialid()).append("'");
            }
            if (data.getQueryserialnumtype() == 1) {
                where.append(" and serialnum=").append(data.getSerialnum()).append("");
            }
        }
        if ((rowcount = this.getSingleInt(countsql = countsql + where.toString())) <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        if (null != fliper) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet<Placards>(rowcount, this.query(Placards.class, sql, "classname", "previewurl"));
    }

    @Override
    public synchronized int getMaxserialnum(String serialid) {
        String sql = "select max(SerialNum) as serialsum from placards where SerialId='" + serialid + "'";
        final ArrayList<Integer> maxSerialNum = new ArrayList<Integer>();
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                try {
                    maxSerialNum.add(rs.getInt("serialsum"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        if (maxSerialNum.size() == 0) {
            maxSerialNum.add(new Integer(0));
        }
        int result = (Integer)maxSerialNum.get(0);
        return result;
    }
}

