/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.dao;

import com.xunlei.common.util.AssemInterceptor;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.Extendable;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.SimpleMapEntry;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.StringInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JdbcBaseDao
extends JdbcDaoSupport {
    protected static final Logger logger = Logger.getLogger(JdbcBaseDao.class);

    public JdbcBaseDao() {
        logger.debug(this.getClass().getName() + "\u521d\u59cb\u5316");
    }

    public <T> List<T> queryToList(String sql) {
        final ArrayList datas = new ArrayList();
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                datas.add(rs.getObject(1));
            }
        });
        return datas;
    }

    public <K, V> Map<K, V> queryToMap(String sql) {
        return this.queryToMap(sql, null, null);
    }

    public <K, V> Map<K, V> queryToMap(String sql, K key, V value) {
        final LinkedHashMap<K, V> datas = new LinkedHashMap<K, V>();
        if (key != null && value != null) {
            datas.put(key, value);
        }
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                datas.put(rs.getObject(1), rs.getObject(2));
            }
        });
        return datas;
    }

    @Deprecated
    protected <K, V> List<Map.Entry<K, V>> queryToMapList(String sql, SimpleMapEntry<K, V> entry) {
        final ArrayList<Map.Entry<K, V>> datas = new ArrayList<Map.Entry<K, V>>();
        if (entry != null) {
            datas.add(entry);
        }
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                datas.add(new SimpleMapEntry<Object, Object>(rs.getObject(1), rs.getObject(2)));
            }
        });
        return datas;
    }

    @Deprecated
    protected <K, V> List<Map.Entry<K, V>> queryToMapList(String sql) {
        final ArrayList<Map.Entry<K, V>> datas = new ArrayList<Map.Entry<K, V>>();
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                datas.add(new SimpleMapEntry<Object, Object>(rs.getObject(1), rs.getObject(2)));
            }
        });
        return datas;
    }

    public int executeUpdate(String sql) {
        logger.debug("update sql:" + sql);
        return this.getJdbcTemplate().update(sql);
    }

    public int[] batchUpdate(String ... sqls) {
        return this.getJdbcTemplate().batchUpdate(sqls);
    }

    public void execute(String sql) {
        logger.debug("execute sql:" + sql);
        this.getJdbcTemplate().execute(sql);
    }

    public int getSingleInt(String sql) {
        try {
            logger.debug("get int sql:" + sql);
            return this.getJdbcTemplate().queryForInt(sql);
        }
        catch (DataAccessException e) {
            return 0;
        }
    }

    public long getSingleLong(String sql) {
        try {
            logger.debug("get long sql:" + sql);
            return this.getJdbcTemplate().queryForLong(sql);
        }
        catch (DataAccessException e) {
            return 0L;
        }
    }

    public double getSingleDouble(String sql) {
        try {
            logger.debug("get double sql:" + sql);
            Double d = (Double)this.getJdbcTemplate().queryForObject(sql, Double.class);
            if (null != d) {
                return d;
            }
            return 0.0;
        }
        catch (DataAccessException e) {
            return 0.0;
        }
    }

    public String getSingleString(String sql) {
        try {
            logger.debug("get String sql:" + sql);
            String data = (String)this.getJdbcTemplate().queryForObject(sql, String.class);
            if (this.isEmpty(data)) {
                data = "";
            }
            return data;
        }
        catch (DataAccessException e) {
            return "";
        }
    }

    public void insertObject(Object data) {
        this.saveObject(data);
    }

    public void deleteObject(String table, long ... seqids) {
        String sql = "delete from " + table + " where seqid in (" + JdbcBaseDao.toString(seqids) + ") ";
        this.getJdbcTemplate().execute(sql);
    }

    public String createNextId(String table, String idname, int len) {
        int d = 1;
        for (int i = 0; i < len - 1; ++i) {
            d *= 10;
        }
        String sql = "select (ifnull(max(" + idname + "), '" + d + "')+1) as 'nextid' from " + table + " ";
        String str = String.valueOf(this.getJdbcTemplate().queryForInt(sql));
        String result = "";
        for (int i = 0; i < len - str.length(); ++i) {
            result = result + "0";
        }
        return result + str;
    }

    public <T> T queryOne(Class<T> clazz, String sql, String ... exargs) {
        return this.queryOne(clazz, sql, (AssemInterceptor<T>)null, exargs);
    }

    public <T> T queryOne(Class<T> clazz, String sql, AssemInterceptor<T> interceptor, String ... exargs) {
        List<T> list = this.query(clazz, sql, interceptor, exargs);
        return list.size() < 1 ? null : (T)list.get(0);
    }

    public <T> List<T> query(Class<T> clazz, String sql, String ... exargs) {
        return this.query(clazz, sql, (AssemInterceptor<T>)null, exargs);
    }

    public <T> List<T> query(Class<T> clazz, String sql, AssemInterceptor<T> interceptor, String ... exargs) {
        return this.query(clazz, sql, interceptor, (String[])null, (String[])null, exargs);
    }

    public <T> List<T> query(final Class<T> clazz, String sql, final AssemInterceptor<T> interceptor, final String[] excludeFields, final String[] includeFields, final String ... exargs) {
        final ArrayList datas = new ArrayList();
        logger.debug("query sql:" + sql);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String fname = "";
                Method method = null;
                try {
                    Object indata = clazz.newInstance();
                    for (Field field : clazz.getDeclaredFields()) {
                        if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                        fname = field.getName();
                        if (field.getAnnotation(Extendable.class) != null && JdbcBaseDao.isNotContains(fname, exargs) || includeFields != null && JdbcBaseDao.isNotContains(fname, includeFields) || excludeFields != null && !JdbcBaseDao.isNotContains(fname, excludeFields)) continue;
                        method = clazz.getDeclaredMethod("set" + JdbcBaseDao.capitalize(fname), field.getType());
                        if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                            method.invoke(indata, rs.getBoolean(fname));
                            continue;
                        }
                        if (field.getType() == Byte.TYPE || field.getType() == Byte.class) {
                            method.invoke(indata, rs.getByte(fname));
                            continue;
                        }
                        if (field.getType() == Short.TYPE || field.getType() == Short.class) {
                            method.invoke(indata, rs.getShort(fname));
                            continue;
                        }
                        if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                            method.invoke(indata, rs.getInt(fname));
                            continue;
                        }
                        if (field.getType() == Long.TYPE || field.getType() == Long.class) {
                            method.invoke(indata, rs.getLong(fname));
                            continue;
                        }
                        if (field.getType() == Float.TYPE || field.getType() == Float.class) {
                            method.invoke(indata, Float.valueOf(rs.getFloat(fname)));
                            continue;
                        }
                        if (field.getType() == Double.TYPE || field.getType() == Double.class) {
                            method.invoke(indata, rs.getDouble(fname));
                            continue;
                        }
                        method.invoke(indata, rs.getString(fname));
                    }
                    if (interceptor != null) {
                        interceptor.hold(indata);
                    }
                    datas.add(indata);
                }
                catch (Exception ex) {
                    throw new RuntimeException("query list error (field: " + fname + ").", ex);
                }
            }
        });
        return datas;
    }

    private static boolean isNotContains(String one, String[] arrays) {
        if (arrays == null) {
            return true;
        }
        for (String str : arrays) {
            if (!one.equalsIgnoreCase(str)) continue;
            return false;
        }
        return true;
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected static String toString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : list) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append("'").append(s).append("'");
        }
        return sb.toString();
    }

    protected static String toString(String[] arrays) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : arrays) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append("'").append(s).append("'");
        }
        if (sb.length() < 1) {
            return "'null_'";
        }
        return sb.toString();
    }

    protected static String toString(long[] arrays) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (long s : arrays) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    protected boolean isEmpty(String str) {
        return StringTools.isEmpty(str);
    }

    protected boolean isNotEmpty(String str) {
        return StringTools.isNotEmpty(str);
    }

    @Deprecated
    protected int computeStartRowNo(int rowcount, int pagesize, int pageno) {
        if (rowcount < 0 || pagesize < 1 || pageno < 1) {
            throw new RuntimeException("\u7528\u4e8e\u8ba1\u7b97\u7ffb\u9875\u8d77\u59cb\u884c\u7684\u53c2\u6570\u4e0d\u6b63\u786e!");
        }
        int startrowno = (pageno - 1) * pagesize;
        if (rowcount == 0) {
            startrowno = 0;
        } else if (startrowno >= rowcount) {
            startrowno = rowcount % pagesize == 0 ? rowcount - pagesize : rowcount / pagesize * pagesize;
        }
        return startrowno;
    }

    @Deprecated
    protected String addLimitToSql(String sql, int rowcount, int pagesize, int pageno) {
        int startrowno = this.computeStartRowNo(rowcount, pagesize, pageno);
        String sqls = sql + " limit " + startrowno + "," + pagesize;
        return sqls;
    }

    public <T> void updateObject(T object) {
        this.updateObject(object, null, null);
    }

    public <T> void updateObjectExcludeFields(T object, String[] excludeFields) {
        this.updateObject(object, excludeFields, null);
    }

    public <T> void updateObjectIncludeFields(T object, String[] includeFields) {
        this.updateObject(object, null, includeFields);
    }

    public <T> void updateObject(T object, String[] excludeFields, String[] includeFields) {
        Class<?> clazz = object.getClass();
        String className = clazz.toString().substring(clazz.toString().lastIndexOf(46) + 1).toLowerCase();
        StringBuilder sql = new StringBuilder("update ").append(className).append(" set ");
        StringBuilder sqlValue = new StringBuilder();
        try {
            Field[] fields = clazz.getDeclaredFields();
            String fname = null;
            Method method = null;
            Object fieldValue = null;
            Class<?> type = null;
            long keyValue = 0L;
            for (Field field : fields) {
                fname = field.getName();
                if (field.getAnnotation(Extendable.class) != null) {
                    logger.debug(fname + "\u6807\u8bb0\u4e3a@Extendable\uff0c\u4e0d\u66f4\u65b0\u6b64\u5b57\u6bb5");
                    continue;
                }
                if (!fname.equalsIgnoreCase("seqid") && includeFields != null && JdbcBaseDao.isNotContains(fname, includeFields)) {
                    logger.debug(fname + "\"\u4e0d\"\u5305\u542b\u5728\u9700\u8981\u66f4\u65b0\u7684\u53c2\u6570\u5217\u8868\uff0c\u4e0d\u66f4\u65b0\u6b64\u5b57\u6bb5");
                    continue;
                }
                if (!JdbcBaseDao.isNotContains(fname, excludeFields)) {
                    logger.debug(fname + "\u5305\u542b\u5728\u4e0d\u9700\u8981\u66f4\u65b0\u7684\u53c2\u6570\u5217\u8868\uff0c\u4e0d\u66f4\u65b0\u6b64\u5b57\u6bb5");
                    continue;
                }
                method = clazz.getDeclaredMethod("get" + JdbcBaseDao.capitalize(fname), new Class[0]);
                fieldValue = method.invoke(object, new Object[0]);
                if (fname.equalsIgnoreCase("seqid")) {
                    logger.debug(fname + "\u4e3a\u81ea\u589e\u4e3b\u952e\uff0c\u4e0d\u7528\u66f4\u65b0");
                    keyValue = Long.parseLong(fieldValue.toString());
                    continue;
                }
                type = field.getType();
                if (this.isNumType(type)) {
                    sqlValue.append(fname).append("=").append(fieldValue.toString()).append(",");
                    continue;
                }
                if (type == Date.class) {
                    sqlValue.append(fname).append("='").append(DatetimeUtil.formatyyyyMMddHHmmss((Date)fieldValue)).append("',");
                    continue;
                }
                sqlValue.append(fname).append("='").append(StringTools.escapeSql(fieldValue)).append("',");
            }
            String finalSql = sql.toString() + sqlValue.substring(0, sqlValue.length() - 1) + " where seqid=" + keyValue;
            this.executeUpdate(finalSql);
        }
        catch (Exception ex) {
            logger.error(ex);
            new XLRuntimeException(ex);
        }
    }

    public <T> T saveObject(T object) {
        Class<?> clazz = object.getClass();
        String className = clazz.toString().substring(clazz.toString().lastIndexOf(46) + 1).toLowerCase();
        StringBuilder sqlColumn = new StringBuilder("(");
        StringBuilder sqlValue = new StringBuilder("(");
        String fname = "";
        Method method = null;
        Object fieldValue = null;
        Class<?> type = null;
        try {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                fname = field.getName();
                if (field.getAnnotation(Extendable.class) != null) {
                    logger.debug(fname + "\u6807\u8bb0\u4e3a@Extendable\uff0c\u4e0d\u4fdd\u5b58\u6b64\u5b57\u6bb5");
                    continue;
                }
                if (fname.equalsIgnoreCase("seqid")) {
                    logger.debug(fname + "\u4e3a\u81ea\u589e\u4e3b\u952e\uff0c\u4e0d\u7528\u63d2\u5165");
                    continue;
                }
                method = clazz.getDeclaredMethod("get" + JdbcBaseDao.capitalize(fname), new Class[0]);
                fieldValue = method.invoke(object, new Object[0]);
                sqlColumn.append(fname);
                type = field.getType();
                if (this.isNumType(type)) {
                    sqlValue.append(fieldValue.toString());
                } else if (field.getType() == Date.class) {
                    sqlValue.append("'").append(DatetimeUtil.formatyyyyMMddHHmmss((Date)fieldValue)).append("'");
                } else {
                    sqlValue.append("'").append(StringTools.escapeSql(fieldValue)).append("'");
                }
                sqlColumn.append(",");
                sqlValue.append(",");
            }
            String sqlInsert = "insert into " + className + sqlColumn.substring(0, sqlColumn.length() - 1) + ") values" + sqlValue.substring(0, sqlValue.length() - 1) + ")";
            String sqlGetSeqid = "select seqid from " + className + " order by seqid desc limit 0,1";
            this.execute(sqlInsert);
            long seqid = this.getSingleLong(sqlGetSeqid);
            logger.debug("\u65b0\u7eaa\u5f55\u7684seqid\u4e3a\uff1a" + seqid);
            method = clazz.getDeclaredMethod("setSeqid", Long.TYPE);
            Object o = method.invoke(object, seqid);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            new XLRuntimeException(ex);
        }
        return object;
    }

    public <T> void deleteObject(T object) {
        if (object == null) {
            throw new XLRuntimeException("\u5220\u9664\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Class<?> clazz = object.getClass();
        String className = clazz.toString().substring(clazz.toString().lastIndexOf(46) + 1).toLowerCase();
        try {
            Method method = clazz.getDeclaredMethod("getSeqid", new Class[0]);
            String sql = "delete from " + className + " where seqid=" + method.invoke(object, new Object[0]);
            this.execute(sql);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            throw new XLRuntimeException("\u6ca1\u6709\u5b9a\u4e49getSeqid\u65b9\u6cd5", ex);
        }
    }

    public <T> void deleteObjectByCondition(T object, String exwheresql) {
        Class<?> clazz = object.getClass();
        String className = clazz.toString().substring(clazz.toString().lastIndexOf(46) + 1).toLowerCase();
        String sql = "delete from " + className;
        StringBuilder sqlWhere = new StringBuilder(" where 1=1 ");
        String fname = "";
        Method method = null;
        Object fieldValue = null;
        Class<?> type = null;
        try {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.getAnnotation(Extendable.class) != null) continue;
                fname = field.getName();
                method = clazz.getDeclaredMethod("get" + JdbcBaseDao.capitalize(fname), new Class[0]);
                type = field.getType();
                if (!this.isSupportType(type)) continue;
                fieldValue = method.invoke(object, new Object[0]);
                if (type == String.class) {
                    if (!StringTools.isNotEmpty((String)fieldValue)) continue;
                    sqlWhere.append(" and ").append(fname).append("='").append(StringTools.escapeSql((String)fieldValue)).append("' ");
                    continue;
                }
                if (type == Date.class) {
                    sqlWhere.append(" and ").append(fname).append("='").append(DatetimeUtil.formatyyyyMMddHHmmss((Date)fieldValue)).append("' ");
                    continue;
                }
                if (0.0 == StringTools.tryParseDouble(fieldValue)) continue;
                sqlWhere.append(" and ").append(fname).append("=").append(fieldValue).append(" ");
            }
            if (StringTools.isNotEmpty(exwheresql)) {
                sqlWhere.append(" ").append(exwheresql).append(" ");
            }
            sql = sql + sqlWhere.toString();
            this.execute(sql);
        }
        catch (Exception ex) {
            logger.debug(sql + sqlWhere.toString());
            logger.error(ex);
            throw new XLRuntimeException(ex);
        }
    }

    public <T> List<T> findObjects(T object, String exwheresql, String orderbysql) {
        return (List)this.findPagedObjects(object, exwheresql, orderbysql, null).getDatas();
    }

    public <T> T findObject(T object) {
        T o = null;
        try {
            Class<?> clazz = object.getClass();
            String className = clazz.toString().substring(clazz.toString().lastIndexOf(46) + 1).toLowerCase();
            Method method = clazz.getDeclaredMethod("getSeqid", new Class[0]);
            Long seqid = (Long)method.invoke(object, new Object[0]);
            String sql = "select * from " + className + " where seqid=" + seqid;
            o = (T)this.queryOne(clazz, sql, new String[0]);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            new XLRuntimeException(ex);
        }
        return o;
    }

    public <T> T findObjectByCondition(T object) {
        PagedFliper fliper = new PagedFliper();
        fliper.setPageNo(1);
        fliper.setPageSize(1);
        List list = (List)this.findPagedObjects(object, null, fliper).getDatas();
        if (list != Collections.EMPTY_LIST) {
            return (T)list.get(0);
        }
        return null;
    }

    public <T> Sheet<T> findPagedObjects(T object, String exwheresql, PagedFliper fliper) {
        return this.findPagedObjects(object, exwheresql, null, fliper);
    }

    public <T> Sheet<T> findPagedObjects(T object, String exwheresql, String orderbysql, PagedFliper fliper) {
        return this.findPagedObjects(object, exwheresql, orderbysql, fliper, null, null);
    }

    public <T> Sheet<T> findPagedObjectsIncludeFields(T object, String exwheresql, String orderbysql, PagedFliper fliper, String[] includeFields) {
        return this.findPagedObjects(object, exwheresql, orderbysql, fliper, null, includeFields);
    }

    public <T> Sheet<T> findPagedObjectsIncludeFields(T object, PagedFliper fliper, String[] includeFields) {
        return this.findPagedObjects(object, null, null, fliper, null, includeFields);
    }

    public <T> Sheet<T> findPagedObjectsExcludeFields(T object, String exwheresql, String orderbysql, PagedFliper fliper, String[] excludeFields) {
        return this.findPagedObjects(object, exwheresql, orderbysql, fliper, excludeFields, null);
    }

    public <T> Sheet<T> findPagedObjectsExcludeFields(T object, PagedFliper fliper, String[] excludeFields) {
        return this.findPagedObjects(object, null, null, fliper, excludeFields, null);
    }

    public <T> Sheet<T> findPagedObjects(T object, String exwheresql, String orderbysql, PagedFliper fliper, String[] excludeFields, String[] includeFields) {
        Class<?> clazz = object.getClass();
        Sheet datas = Sheet.EMPTY;
        String className = clazz.toString().substring(clazz.toString().lastIndexOf(46) + 1).toLowerCase();
        StringBuilder queryFields = new StringBuilder("select ");
        StringBuilder sql = new StringBuilder(" from ");
        StringBuilder sqlCount = new StringBuilder("select count(1) from ");
        sql.append(className);
        sqlCount.append(className);
        StringBuilder sqlWhere = new StringBuilder(" where 1=1 ");
        String fname = "";
        Method method = null;
        Object fieldValue = null;
        Class<?> type = null;
        try {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.getAnnotation(Extendable.class) != null) continue;
                fname = field.getName();
                method = clazz.getDeclaredMethod("get" + JdbcBaseDao.capitalize(fname), new Class[0]);
                if (excludeFields == null && includeFields == null) {
                    queryFields.append(fname).append(",");
                } else if (!(excludeFields != null && !JdbcBaseDao.isNotContains(fname, excludeFields) || includeFields != null && JdbcBaseDao.isNotContains(fname, includeFields))) {
                    queryFields.append(fname).append(",");
                }
                type = field.getType();
                if (!this.isSupportType(type) || (fieldValue = method.invoke(object, new Object[0])) == null) continue;
                if (type == String.class) {
                    if (!StringTools.isNotEmpty((String)fieldValue)) continue;
                    sqlWhere.append(" and ").append(fname).append("='").append(StringTools.escapeSql((String)fieldValue)).append("' ");
                    continue;
                }
                if (Date.class == type) {
                    sqlWhere.append(" and ").append(fname).append("='").append(DatetimeUtil.formatyyyyMMddHHmmss((Date)fieldValue)).append("' ");
                    continue;
                }
                if (0.0 == StringTools.tryParseDouble(fieldValue)) continue;
                sqlWhere.append(" and ").append(fname).append("=").append(fieldValue).append(" ");
            }
            if (StringTools.isNotEmpty(exwheresql)) {
                sqlWhere.append(" ").append(exwheresql).append(" ");
            }
            sqlCount.append((CharSequence)sqlWhere);
            sql.append((CharSequence)sqlWhere);
            String fieldString = queryFields.toString();
            fieldString = fieldString.substring(0, fieldString.length() - 1);
            sql = new StringBuilder(fieldString).append((CharSequence)sql);
            int rowCount = 0;
            List<?> list = null;
            if (fliper != null) {
                logger.debug("\u5bf9" + className + "\u8fdb\u884c\u5206\u9875\u67e5\u8be2");
                if (fliper.isNotEmptySortColumn()) {
                    sql.append(" order by ").append(fliper.getSortColumn());
                }
                rowCount = this.getSingleInt(sqlCount.toString());
                sql.append(fliper.limitsql(rowCount));
                list = rowCount == 0 ? Collections.EMPTY_LIST : this.query((Class<T>)clazz, sql.toString(), (AssemInterceptor<T>)null, excludeFields, includeFields, new String[0]);
            } else {
                logger.debug("\u5bf9" + className + "\u8fdb\u884c\u4e0d\u5206\u9875\u7684\u67e5\u8be2");
                if (StringTools.isNotEmpty(orderbysql)) {
                    sql.append(" order by ").append(orderbysql);
                }
                if ((rowCount = (list = this.query((Class<T>)clazz, sql.toString(), (AssemInterceptor<T>)null, excludeFields, includeFields, new String[0])).size()) == 0) {
                    list = Collections.EMPTY_LIST;
                }
            }
            datas = new Sheet(rowCount, list);
        }
        catch (Exception ex) {
            logger.debug("current sql:" + sql);
            logger.error(ex);
            throw new XLRuntimeException("current sql:" + sql.toString(), ex);
        }
        return datas;
    }

    public String getMaxNewSn(String tableName, String fieldName, int fieldLength) {
        return this.getNewSn(tableName, fieldName, fieldLength, null, null, true, 0);
    }

    public String getSmoothNewSn(String tableName, String fieldName, int fieldLength, int noMaxStep) {
        return this.getNewSn(tableName, fieldName, fieldLength, null, null, false, noMaxStep);
    }

    public String getNewSn(String tableName, String fieldName, int fieldLength, String snprefix, String sntail, boolean maxFirst) {
        return this.getNewSn(tableName, fieldName, fieldLength, snprefix, sntail, maxFirst, 100);
    }

    public String getNewSn(String tableName, String fieldName, int fieldLength, String snprefix, String sntail, boolean maxFirst, int noMaxStep) {
        String newSn = null;
        if (snprefix == null) {
            snprefix = "";
        }
        if (sntail == null) {
            sntail = "";
        }
        int prefixLength = 0;
        int tailLength = 0;
        prefixLength = snprefix.length();
        tailLength = sntail.length();
        if (maxFirst) {
            String sql = "select max(" + fieldName + ") from " + tableName;
            String sn = this.getSingleString(sql);
            sn = StringTools.isNotEmpty(sn) ? sn.substring(0, sn.length() - sntail.length()).substring(snprefix.length()) : "0";
            long newsnValue = Long.parseLong(sn) + 1L;
            newSn = snprefix + StringTools.toLenString(newsnValue, fieldLength - prefixLength - tailLength) + sntail;
        } else {
            String sql;
            List<StringInfo> stringInfo;
            if (noMaxStep == 0) {
                noMaxStep = 100;
            }
            int currentPageNo = 0;
            long lastValue = 0L;
            boolean found = false;
            while (!found && (stringInfo = this.query(StringInfo.class, sql = "select " + fieldName + " as fieldValue from " + tableName + " order by " + fieldName + " asc limit " + currentPageNo * noMaxStep + "," + noMaxStep, new String[0])).size() > 0) {
                for (StringInfo si : stringInfo) {
                    long currentValue = Long.parseLong(si.getFieldValue().substring(0, si.getFieldValue().length() - sntail.length()).substring(snprefix.length()));
                    if (currentValue > lastValue + 1L) {
                        found = true;
                        break;
                    }
                    lastValue = currentValue;
                }
                ++currentPageNo;
            }
            newSn = snprefix + StringTools.toLenString(lastValue + 1L, fieldLength - prefixLength - tailLength) + sntail;
        }
        return newSn;
    }

    protected static String uniteForIn(String[] strArray) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (strArray == null || strArray.length == 0) {
            logger.debug("\u7ec4\u6210in\u5b50\u53e5\u65f6\u7684\u5b57\u7b26\u4e32\u6570\u7ec4\u4e3a\u7a7a\uff0c\u5982\u679c\u4e3a()\u4f1a\u4ea7\u751fsql\u9519\u8bef\uff0c\u66ff\u6362\u6210(null)");
            sb.append("null");
        } else {
            for (int i = 0; i < strArray.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append("'").append(StringTools.escapeSql(strArray[i])).append("'");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Resource(name="dataSource")
    public void setDataS(DataSource dataSource) {
        this.setDataSource(dataSource);
        logger.debug("\u5728" + this.getClass().getName() + ",dataSource\u88ab\u6ce8\u5165");
    }

    public boolean isSupportType(Class type) {
        if (type == String.class) {
            return true;
        }
        if (this.isNumType(type)) {
            return true;
        }
        return type == Date.class;
    }

    public boolean isNumType(Class type) {
        if (type == Short.TYPE || type == Short.class) {
            return true;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return true;
        }
        if (type == Long.TYPE || type == Long.class) {
            return true;
        }
        if (type == Float.TYPE || type == Float.class) {
            return true;
        }
        if (type == Double.TYPE || type == Double.class) {
            return true;
        }
        return type == Date.class;
    }
}

