/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.dao;

import com.xunlei.common.dao.JdbcBaseDao;
import java.io.Serializable;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDao
extends JdbcBaseDao {
    private HibernateTemplate hibernateTemplate;

    public <T> T findObject(Class<T> clazz, long seqid) {
        try {
            return (T)this.getHibernateTemplate().load(clazz, (Serializable)Long.valueOf(seqid));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void insertObject(Object data) {
        this.getHibernateTemplate().save(data);
    }

    public void deleteObject(Object data) {
        this.getHibernateTemplate().delete(data);
    }

    public void updateObject(Object data) {
        this.getHibernateTemplate().update(data);
    }

    public final void setSessionFactory(SessionFactory sessionFactory) {
        logger.debug("\u5728" + this.getClass().getName() + "\u4e2d\uff0csessionFactory\u88ab\u6ce8\u5165");
        this.hibernateTemplate = this.createHibernateTemplate(sessionFactory);
    }

    protected HibernateTemplate createHibernateTemplate(SessionFactory sessionFactory) {
        return new HibernateTemplate(sessionFactory);
    }

    public final SessionFactory getSessionFactory() {
        return this.hibernateTemplate != null ? this.hibernateTemplate.getSessionFactory() : null;
    }

    public final void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public final HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    protected final Session getSession() throws DataAccessResourceFailureException, IllegalStateException {
        return this.getSession(this.hibernateTemplate.isAllowCreate());
    }

    protected final Session getSession(boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return !allowCreate ? SessionFactoryUtils.getSession(this.getSessionFactory(), false) : SessionFactoryUtils.getSession(this.getSessionFactory(), this.hibernateTemplate.getEntityInterceptor(), this.hibernateTemplate.getJdbcExceptionTranslator());
    }
}

