/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.bo;

import com.xunlei.common.bo.BaseBo;
import com.xunlei.common.bo.IUsersBo;
import com.xunlei.common.dao.IUsersDao;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.Constants;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.Functions;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.OnlineUserInfoShow;
import com.xunlei.common.vo.UserRights;
import com.xunlei.common.vo.UserToRole;
import com.xunlei.common.vo.Users;
import com.xunlei.common.vo.Usertobizno;
import com.xunlei.common.vo.Usertofunction;
import com.xunlei.common.vo.Usertomailclass;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class UsersBoImpl
extends BaseBo
implements IUsersBo {
    @Autowired
    private IUsersDao usersDao;
    private static Logger logger = Logger.getLogger(UsersBoImpl.class);

    public IUsersDao getUsersDao() {
        return this.usersDao;
    }

    @Override
    public void setUsersDao(IUsersDao usersDao) {
        this.usersDao = usersDao;
    }

    @Override
    public Users getUsersById(Long id) {
        Users u = new Users();
        u.setSeqid(id);
        return this.getUsersDao().getAUsers(u);
    }

    @Override
    public Users getUsersByUserLogNo(String userlogno) {
        for (String s : Constants.EXCLUDE_USERS) {
            if (!s.equalsIgnoreCase(userlogno)) continue;
            throw new XLRuntimeException("\u4e0d\u5141\u8bb8\u4f7f\u7528" + userlogno + "\u5e10\u53f7");
        }
        Users data = this.getUsersDao().getUsersByUserLogNo(userlogno);
        if (data != null) {
            List<UserToRole> utrs = IFacadeCommon.INSTANCE.getUserToRoleByUserLogo(userlogno);
            data.setRoles(utrs.toArray(new UserToRole[utrs.size()]));
        }
        return data;
    }

    @Override
    public void insertUsers(Users data) {
        if (this.getUsersByUserLogNo(data.getUserlogno()) != null) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u5e10\u53f7\u7684\u7528\u6237");
        }
        if (!(StringTools.isEmpty(data.getCopartnerno()) || StringTools.isEmpty(data.getUpuserlogno()) || this.getUsersByUserLogNo(data.getUpuserlogno()) == null || data.getCopartnerno().equals(this.getUsersByUserLogNo(data.getUpuserlogno()).getCopartnerno()))) {
            throw new XLRuntimeException("\u5b50\u5e10\u53f7\u5408\u4f5c\u5546\u548c\u4e0a\u7ea7\u4e3b\u5e10\u53f7\u7684\u5408\u4f5c\u5546\u4e0d\u7b26");
        }
        for (String s : Constants.EXCLUDE_USERS) {
            if (!s.equalsIgnoreCase(data.getUserlogno())) continue;
            throw new XLRuntimeException("\u4e0d\u5141\u8bb8\u65b0\u589e" + data.getUserlogno() + "\u5e10\u53f7");
        }
        this.getUsersDao().insertUsers(data);
    }

    @Override
    public void updateUsers(Users data) {
        Users otherdata = this.getUsersByUserLogNo(data.getUserlogno());
        if (otherdata != null && otherdata.getSeqid() != data.getSeqid()) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u5e10\u53f7\u7684\u7528\u6237");
        }
        this.getUsersDao().updateUsers(data);
    }

    @Override
    public void removeUsers(Users data) {
        Users users = this.findUsers(data);
        this.removeUsers(users.getSeqid());
    }

    @Override
    public void removeUsers(long seqid) {
        Users data = this.getUsersById(seqid);
        if (IFacadeCommon.INSTANCE.getUserToRoleByUserLogNo(data.getUserlogno()) > 0) {
            throw new XLRuntimeException("\u7528\u6237(" + data.getUserlogno() + ")\u5df2\u88ab\u7528\u6237\u89d2\u8272\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        Usertomailclass utmc = new Usertomailclass();
        utmc.setUserlogno(data.getUserlogno());
        Sheet<Usertomailclass> sheet1 = IFacadeCommon.INSTANCE.queryUsertomailclass(utmc, null);
        if (sheet1.getRowcount() > 0) {
            throw new XLRuntimeException("\u7528\u6237(" + data.getUserlogno() + ")\u5df2\u88ab\u7528\u6237\u7528\u6237\u90ae\u7bb1\u7ec4\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        Users queryuser = new Users();
        queryuser.setUpuserlogno(data.getUserlogno());
        Sheet<Users> sheet = this.getUsersDao().queryUsers(queryuser, null);
        if (sheet.getRowcount() > 0) {
            throw new XLRuntimeException("\u8bf7\u5148\u5220\u9664\u7528\u6237(" + data.getUserlogno() + ")\u7684\u5b50\u5e10\u53f7");
        }
        if (StringTools.isNotEmpty(data.getUpuserlogno())) {
            Usertofunction forDel = new Usertofunction();
            forDel.setUserlogno(data.getUserlogno());
            IFacadeCommon.INSTANCE.deleteUsertofunction(forDel);
            Usertobizno forDelbizno = new Usertobizno();
            forDelbizno.setUserlogno(data.getUserlogno());
            IFacadeCommon.INSTANCE.deleteUsertobizno(forDelbizno);
        }
        this.getUsersDao().removeUsers(data);
    }

    @Override
    public Map<String, String> getCopartnerNoAndName() {
        return this.getUsersDao().getCopartnerNoAndName();
    }

    public UserRights getUserRightsByFuncNo(String userlogno, String funcno) {
        IFacadeCommon service = IFacadeCommon.INSTANCE;
        Users user = this.getUsersByUserLogNo(userlogno);
        Functions funs = service.getFunctionsByFuncNo(funcno).get(0);
        UserRights data = new UserRights(user, funs);
        if (user.getSuperman() == 1) {
            return data;
        }
        return data;
    }

    @Override
    @Deprecated
    public int getUsersViewCount(Users u) {
        return this.getUsersDao().getUsersViewCount(u);
    }

    @Override
    @Deprecated
    public List<Users> getUsersView(Users u, int rowcount, int pagesize, int pageno, String orderfield) {
        return this.getUsersDao().getUsersView(u, rowcount, pagesize, pageno, orderfield);
    }

    @Override
    public boolean getIfMyDataOnly(String userlogno) {
        return this.getUsersDao().getIfMyDataOnly(userlogno);
    }

    @Override
    public List<String> getAllUserLogo() {
        return this.getUsersDao().getAllUserLogo();
    }

    @Override
    public Sheet<Users> querySysUsers(Users u, PagedFliper fliper) {
        return this.getUsersDao().querySysUsers(u, fliper);
    }

    @Override
    public Sheet<Users> queryCopUsers(Users u, PagedFliper fliper) {
        return this.getUsersDao().queryCopUsers(u, fliper);
    }

    @Override
    public Sheet<Users> queryAllUsers(Users u, PagedFliper fliper) {
        return this.getUsersDao().queryAllUsers(u, fliper);
    }

    @Override
    public int getCountUsers(Users data) {
        return this.getUsersDao().getCountUsers(data);
    }

    @Override
    public boolean isSuperMan(Users u) {
        return this.getUsersDao().isSuperMan(u);
    }

    @Override
    public Users findUsers(Users data) {
        return this.getUsersDao().findAUsers(data);
    }

    @Override
    public Sheet<Users> querySubUsers(String fatheruser, PagedFliper fliper) {
        Users u = new Users();
        u.setUpuserlogno(fatheruser);
        return this.getUsersDao().queryUsers(u, fliper);
    }

    @Override
    public Map<String, String> getUpuserlognolist() {
        return this.getUsersDao().getUpuserlognolist();
    }

    @Override
    public Users getAUsers(Users u) {
        return this.getUsersDao().getAUsers(u);
    }

    @Override
    public Users findAUsers(Users users) {
        return this.findUsers(users);
    }

    @Override
    public boolean isSubAccountof(String subaccount, String fatheraccount) {
        Users user = new Users();
        user.setUserlogno(subaccount);
        user.setUpuserlogno(fatheraccount);
        user = this.findAUsers(user);
        return user != null;
    }

    @Override
    public String[] getFrontUsersLognoAndTrueName() {
        return this.getUsersDao().getFrontUsersLognoAndTrueName();
    }

    @Override
    public Sheet<OnlineUserInfoShow> queryAllUsersWithOnlineInfo(OnlineUserInfoShow onlineUserInfoShow, PagedFliper fliper) {
        return this.getUsersDao().queryAllUsersWithOnlineInfo(onlineUserInfoShow, fliper);
    }

    @Override
    public List<LibClassD> getAllmodules(Users user) {
        if (this.isEmpty(user.getUserlogno()) && this.isEmpty(user.getTruename())) {
            return null;
        }
        if (this.isSuperMan(user)) {
            throw new XLRuntimeException("\u6b64\u7528\u6237\u5177\u6709\u7ba1\u7406\u5458\u6743\u9650\uff01");
        }
        Users subuser = this.findAUsers(user);
        if (subuser != null && subuser.getUpuserlogno() != null && !subuser.getUpuserlogno().equals("")) {
            return IFacadeCommon.INSTANCE.getModelNoBySubuser(user);
        }
        return IFacadeCommon.INSTANCE.getModelNoByUser(user);
    }

    @Override
    public void updatePassword(String userlogno, String oldPassword, String newPassword, String tel, String qq, String mail) {
        Users user = this.getUsersByUserLogNo(userlogno);
        if (!user.getDecodePassword().equals(oldPassword)) {
            throw new XLRuntimeException("\u8f93\u5165\u7684\u65e7\u5bc6\u7801\u4e0d\u6b63\u786e.");
        }
        user.setDecodePassword(newPassword);
        user.setEditby(user.getUserlogno());
        user.setEdittime(UsersBoImpl.now());
        user.setTel(tel);
        user.setQq(qq);
        user.setEmail(mail);
        this.updateUsers(user);
    }

    @Override
    public void resetPassword(long seqid, String password) {
        Users user = this.getUsersById(seqid);
        user.setDecodePassword(password);
        user.setEditby(user.getUserlogno());
        user.setEdittime(UsersBoImpl.now());
        this.updateUsers(user);
    }

    @Override
    public void editUsers(Users data) {
        if (this.isEmpty(data.getCopartnerno())) {
            data.setCopartnerno("");
        }
        Users oldusers = this.getUsersByUserLogNo(data.getUserlogno());
        data.setUserpassword(oldusers.getUserpassword());
        data.setUserlogintype(oldusers.getUserlogintype());
        data.setEdittime(UsersBoImpl.now());
        if (data.isSubaccount()) {
            data.setUserlogintype("B");
        }
        this.updateUsers(data);
    }

    @Override
    public void editSubaccount(String subaccount, String functions, String dms, String editby) {
        Users subuser = this.getUsersByUserLogNo(subaccount);
        if (subuser == null || StringTools.isEmpty(subuser.getUpuserlogno())) {
            throw new XLRuntimeException("\u975e\u6cd5\u7684\u5b50\u8d26\u6237\u4fe1\u606f\u3002");
        }
        Usertofunction forDel = new Usertofunction();
        forDel.setUserlogno(subaccount);
        IFacadeCommon.INSTANCE.deleteUsertofunction(forDel);
        if (StringTools.isNotEmpty(functions)) {
            String[] funArray = functions.split("\\|");
            Usertofunction utf = new Usertofunction();
            utf.setEditby(editby);
            utf.setEdittime(UsersBoImpl.now());
            utf.setUserlogno(subaccount);
            for (String s : funArray) {
                utf.setFuncno(s);
                IFacadeCommon.INSTANCE.insertUsertofunction(utf);
            }
        }
        Usertobizno forDelbizno = new Usertobizno();
        forDelbizno.setUserlogno(subaccount);
        IFacadeCommon.INSTANCE.deleteUsertobizno(forDelbizno);
        if (StringTools.isNotEmpty(dms)) {
            String[] dm = dms.split("\\|\\|");
            Usertobizno utb = new Usertobizno();
            utb.setEditby(editby);
            utb.setEdittime(UsersBoImpl.now());
            utb.setUserlogno(subaccount);
            for (String adm : dm) {
                String[] item = adm.split("\\|");
                utb.setTablename(item[0]);
                utb.setBizvalue(item[1]);
                IFacadeCommon.INSTANCE.insertUsertobizno(utb);
            }
        }
    }
}

