/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.bo;

import com.xunlei.common.bo.BaseBo;
import com.xunlei.common.bo.IMenusBo;
import com.xunlei.common.dao.IMenusDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.Menus;
import com.xunlei.common.vo.UserInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class MenusBoImpl
extends BaseBo
implements IMenusBo {
    @Autowired
    private IMenusDao menusDao;

    public IMenusDao getMenusDao() {
        return this.menusDao;
    }

    @Override
    public void setMenusDao(IMenusDao menusDao) {
        this.menusDao = menusDao;
    }

    @Override
    public int countMenus(Menus menu) {
        return this.getMenusDao().countMenus(menu);
    }

    @Override
    public List<Menus> getAllMenus(Short inuse) {
        return this.getMenusDao().getAllMenus(inuse);
    }

    @Override
    public Menus getMenusById(Long id) {
        Menus m = new Menus();
        m.setSeqid(id);
        return this.getMenusDao().getAMenus(m);
    }

    @Override
    public Menus getMenusByMenuNo(String menuno) {
        return this.getMenusDao().getMenusByMenuNo(menuno);
    }

    @Override
    public void insertMenus(Menus data) {
        Menus searchobj = new Menus();
        searchobj.setMenuno(data.getMenuno());
        if (this.countMenus(searchobj) > 0) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u83dc\u5355");
        }
        Menus searchobj2 = new Menus();
        searchobj2.setDisplayorder(Long.parseLong("1" + data.getMenuno()));
        if (this.countMenus(searchobj2) > 0) {
            data.setDisplayorder(this.getMenusDao().getMaxSubDisplayOrder(data.getPmenuno()).intValue());
        } else {
            data.setDisplayorder(Integer.parseInt("1" + data.getMenuno()));
        }
        data.setMenuid(data.getPmenuno() + data.getMenuno());
        this.getMenusDao().insertMenus(data);
    }

    @Override
    public void updateMenus(Menus data) {
        Menus searchobj = new Menus();
        searchobj.setSeqid(data.getSeqid());
        searchobj.setMenuno(data.getMenuno());
        Menus searchobj2 = new Menus();
        searchobj2.setMenuno(data.getMenuno());
        if (this.countMenus(searchobj2) != this.countMenus(searchobj)) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u83dc\u5355");
        }
        data.setMenuid(data.getPmenuno() + data.getMenuno());
        this.getMenusDao().updateMenus(data);
    }

    @Override
    public void removeMenus(Menus data) {
        this.removeMenus(data.getSeqid());
    }

    @Override
    public void removeMenus(long seqid) {
        List<Menus> sonmenu;
        Menus m = new Menus();
        m = this.getMenusById(seqid);
        if (m != null && (sonmenu = this.getAllMenusByPMenuno(m.getMenuno())) != null && sonmenu.size() > 0) {
            throw new XLRuntimeException("\u83dc\u5355\u8282\u70b9\u88ab\u5176\u5b83\u83dc\u5355\u8282\u70b9\u6240\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002");
        }
        this.getMenusDao().removeMenus(seqid);
    }

    @Override
    public List<Menus> getRunMenusByUserLogo(UserInfo info) {
        if (info.isSuperman()) {
            return this.getMenusDao().getAllMenus((short)1);
        }
        return this.getMenusDao().getRunMenusByUserLogo(info.getUserlogno());
    }

    private boolean checkEmptyMenu(String menuno, List menus) {
        for (int i = 0; i < menus.size(); ++i) {
            Menus m = (Menus)menus.get(i);
            if (m.getFlag() != 1 || !m.getPmenuno().equals(menuno)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getAllMenuNos() {
        return this.getMenusDao().getAllMenuNos();
    }

    @Override
    public String getMaxSubMenuNo(String pMenuNo) {
        return this.getMenusDao().getMaxSubMenuNo(pMenuNo);
    }

    @Override
    public boolean exchangeMenuOrder(String menuno, String pmenuno, String displayno, String way) {
        return this.getMenusDao().exchangeMenuOrder(menuno, pmenuno, displayno, way);
    }

    @Override
    public Sheet<Menus> queryMenus(Menus menu, PagedFliper fliper) {
        return this.getMenusDao().queryMenus(menu, fliper);
    }

    @Override
    public void removeMenus(long[] seqids) {
        if (seqids != null) {
            for (long seqid : seqids) {
                this.removeMenus(seqid);
            }
        }
    }

    @Override
    @Deprecated
    public List<Menus> getMenusByModule(String moduleno) {
        return this.getMenusDao().getMenusByModule(moduleno);
    }

    @Override
    @Deprecated
    public List<Menus> getRunMenusByUserModule(String userlogo, String moduleno) {
        return this.getMenusDao().getRunMenusByUserModule(userlogo, moduleno);
    }

    @Override
    public List<Menus> getAllPMenus() {
        return this.getMenusDao().getAllPMenus();
    }

    @Override
    public List<String> getRunPMenusByUserLogo(String userlogo) {
        return this.getMenusDao().getRunPMenusByUserLogo(userlogo);
    }

    @Override
    public List<Menus> getAllMenusByPMenuno(String pMenuno) {
        return this.getMenusDao().getAllMenusByPMenuno(pMenuno);
    }

    @Override
    public List<Menus> getRunMenusByPMenuno(String userlogo, String pMenuno) {
        return this.getMenusDao().getRunMenusByPMenuno(userlogo, pMenuno);
    }

    @Override
    public List<String> getAllParentMenuString() {
        return this.getMenusDao().getAllParentMenuString();
    }

    @Override
    public List<Menus> getFrontFatherAccountMenus(String account) {
        ArrayList<Menus> result = new ArrayList<Menus>();
        List<Menus> menus = this.getMenusDao().getFrontFatherAccountMenus(account);
        Menus parent = null;
        for (Menus m : menus) {
            if (!result.contains(m)) {
                result.add(m);
            }
            parent = this.getMenusByMenuNo(m.getPmenuno());
            while (parent != null && !result.contains(parent)) {
                result.add(parent);
                parent = this.getMenusByMenuNo(parent.getPmenuno());
            }
        }
        return result;
    }

    @Override
    public List<Menus> getFrontSubAccountMenus(String account) {
        ArrayList<Menus> result = new ArrayList<Menus>();
        List<Menus> menus = this.getMenusDao().getFrontSubAccountMenus(account);
        Menus parent = null;
        for (Menus m : menus) {
            if (!result.contains(m)) {
                result.add(m);
            }
            parent = this.getMenusByMenuNo(m.getPmenuno());
            while (parent != null && !result.contains(parent)) {
                result.add(parent);
                parent = this.getMenusByMenuNo(parent.getPmenuno());
            }
        }
        return result;
    }

    @Override
    public void editMenus(Menus menu) {
        menu.setMenuurl(menu.getMenuurl().trim());
        if (menu.getOldpmenuno().equals(menu.getPmenuno())) {
            this.updateMenus(menu);
        } else {
            long seqid = menu.getSeqid();
            this.insertMenus(menu);
            this.removeMenus(seqid);
        }
    }
}

