/*
 * Decompiled with CFR 0.152.
 */
package com.ferret.common.dao.vo;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Order;
import java.util.ArrayList;
import java.util.List;

public class Page {
    private int pageNo = 0;
    private int pageSize = 20;
    private List<Order> orderList = new ArrayList<Order>();

    public Page() {
    }

    public Page(int pageNo) {
        this.pageNo = pageNo;
    }

    public Page(int pageNo, int pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    public boolean isPage() {
        if (this.pageNo <= 0) {
            return false;
        }
        return this.pageSize > 0;
    }

    public boolean isOrder() {
        return this.orderList.size() > 0;
    }

    public void clearOrder() {
        this.orderList = new ArrayList<Order>();
    }

    public void addOrder(String orderName, OrderType type) {
        if (orderName == null) {
            return;
        }
        if (type == null) {
            type = OrderType.DESC;
        }
        this.removeOrder(orderName);
        Order order = new Order();
        order.setOrderName(orderName);
        order.setType(type);
        this.orderList.add(order);
    }

    public void removeOrder(String orderName) {
        if (orderName == null) {
            return;
        }
        int i = 0;
        while (i < this.orderList.size()) {
            Order order = this.orderList.get(i);
            if (orderName.equals(order.getOrderName())) {
                this.orderList.remove(i);
                continue;
            }
            ++i;
        }
    }

    public String toOrderString() {
        StringBuilder sb = new StringBuilder();
        for (Order order : this.orderList) {
            sb.append(",").append(order.getOrderName()).append(" ");
            if (order.getType() == OrderType.DESC) {
                sb.append("desc");
                continue;
            }
            sb.append("asc");
        }
        String orderStr = sb.toString();
        if (orderStr.startsWith(",")) {
            return orderStr.substring(1);
        }
        return orderStr;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public List<Order> getOrderList() {
        return this.orderList;
    }
}

