/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit38;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.annotation.ProfileValueSource;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.test.annotation.Repeat;
import org.springframework.test.annotation.Timed;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;

@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class, DirtiesContextTestExecutionListener.class})
public abstract class AbstractJUnit38SpringContextTests
extends TestCase
implements ApplicationContextAware {
    private static int disabledTestCount = 0;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected ApplicationContext applicationContext;
    protected final ProfileValueSource profileValueSource;
    private final TestContextManager testContextManager = new TestContextManager(this.getClass());

    public static int getDisabledTestCount() {
        return disabledTestCount;
    }

    public AbstractJUnit38SpringContextTests() {
        this.profileValueSource = ProfileValueUtils.retrieveProfileValueSource(this.getClass());
    }

    public AbstractJUnit38SpringContextTests(String name) {
        super(name);
        this.profileValueSource = ProfileValueUtils.retrieveProfileValueSource(this.getClass());
    }

    public final void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void runBare() throws Throwable {
        this.testContextManager.prepareTestInstance(this);
        final Method testMethod = this.getTestMethod();
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment(this.profileValueSource, testMethod, this.getClass())) {
            this.recordDisabled(testMethod);
            return;
        }
        this.runTestTimed(new TestExecutionCallback(){

            public void run() throws Throwable {
                AbstractJUnit38SpringContextTests.this.runManaged(testMethod);
            }
        }, testMethod);
    }

    private Method getTestMethod() {
        AbstractJUnit38SpringContextTests.assertNotNull("TestCase.getName() cannot be null", this.getName());
        Method testMethod = null;
        try {
            testMethod = this.getClass().getMethod(this.getName(), null);
        }
        catch (NoSuchMethodException ex) {
            AbstractJUnit38SpringContextTests.fail("Method \"" + this.getName() + "\" not found");
        }
        if (!Modifier.isPublic(testMethod.getModifiers())) {
            AbstractJUnit38SpringContextTests.fail("Method \"" + this.getName() + "\" should be public");
        }
        return testMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestTimed(TestExecutionCallback tec, Method testMethod) throws Throwable {
        Timed timed = testMethod.getAnnotation(Timed.class);
        if (timed == null) {
            this.runTest(tec, testMethod);
        } else {
            long startTime = System.currentTimeMillis();
            try {
                this.runTest(tec, testMethod);
            }
            finally {
                long elapsed = System.currentTimeMillis() - startTime;
                if (elapsed > timed.millis()) {
                    AbstractJUnit38SpringContextTests.fail("Took " + elapsed + " ms; limit was " + timed.millis());
                }
            }
        }
    }

    private void runTest(TestExecutionCallback tec, Method testMethod) throws Throwable {
        ExpectedException expectedExceptionAnnotation = testMethod.getAnnotation(ExpectedException.class);
        boolean exceptionIsExpected = expectedExceptionAnnotation != null && expectedExceptionAnnotation.value() != null;
        Class<? extends Throwable> expectedException = exceptionIsExpected ? expectedExceptionAnnotation.value() : null;
        Repeat repeat = testMethod.getAnnotation(Repeat.class);
        int runs = repeat != null && repeat.value() > 1 ? repeat.value() : 1;
        for (int i = 0; i < runs; ++i) {
            try {
                if (runs > 1 && this.logger.isInfoEnabled()) {
                    this.logger.info("Repetition " + (i + 1) + " of test " + testMethod.getName());
                }
                tec.run();
                if (!exceptionIsExpected) continue;
                AbstractJUnit38SpringContextTests.fail("Expected exception: " + expectedException.getName());
                continue;
            }
            catch (Throwable ex) {
                if (!exceptionIsExpected) {
                    throw ex;
                }
                if (expectedException.isAssignableFrom(ex.getClass())) continue;
                AssertionFailedError assertionError = new AssertionFailedError("Unexpected exception, expected <" + expectedException.getName() + "> but was <" + ex.getClass().getName() + ">");
                assertionError.initCause(ex);
                throw assertionError;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runManaged(Method testMethod) throws Throwable {
        Throwable exception = null;
        boolean reachedTest = false;
        try {
            this.testContextManager.beforeTestMethod(this, testMethod);
            this.setUp();
            reachedTest = true;
            this.runTest();
        }
        catch (Throwable ex) {
            exception = ex;
        }
        finally {
            try {
                if (reachedTest) {
                    this.tearDown();
                }
            }
            catch (Throwable ex) {
                if (exception == null) {
                    exception = ex;
                }
            }
            finally {
                block42: {
                    try {
                        this.testContextManager.afterTestMethod(this, testMethod, exception);
                    }
                    catch (Throwable ex) {
                        if (exception != null) break block42;
                        exception = ex;
                    }
                }
            }
        }
        if (exception == null) {
            return;
        }
        if (exception.getCause() instanceof AssertionError) {
            exception = exception.getCause();
        }
        throw exception;
    }

    protected void recordDisabled(Method testMethod) {
        ++disabledTestCount;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("**** " + this.getClass().getName() + "." + this.getName() + "() is disabled in this environment. " + "Total disabled tests = " + AbstractJUnit38SpringContextTests.getDisabledTestCount());
        }
    }

    private static interface TestExecutionCallback {
        public void run() throws Throwable;
    }
}

