/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public abstract class AssertThrows {
    private final Class expectedException;
    private String failureMessage;
    private Exception actualException;

    public AssertThrows(Class expectedException) {
        this(expectedException, null);
    }

    public AssertThrows(Class expectedException, String failureMessage) {
        if (expectedException == null) {
            throw new IllegalArgumentException("The 'expectedException' argument is required");
        }
        if (!Exception.class.isAssignableFrom(expectedException)) {
            throw new IllegalArgumentException("The 'expectedException' argument is not an Exception type (it obviously must be)");
        }
        this.expectedException = expectedException;
        this.failureMessage = failureMessage;
    }

    protected Class getExpectedException() {
        return this.expectedException;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    protected String getFailureMessage() {
        return this.failureMessage;
    }

    public abstract void test() throws Exception;

    public void runTest() {
        try {
            this.test();
            this.doFail();
        }
        catch (Exception actualException) {
            this.actualException = actualException;
            this.checkExceptionExpectations(actualException);
        }
    }

    protected void doFail() {
        Assert.fail(this.createMessageForNoExceptionThrown());
    }

    protected String createMessageForNoExceptionThrown() {
        StringBuffer sb = new StringBuffer();
        sb.append("Should have thrown a [").append(this.getExpectedException()).append("]");
        if (this.getFailureMessage() != null) {
            sb.append(": ").append(this.getFailureMessage());
        }
        return sb.toString();
    }

    protected void checkExceptionExpectations(Exception actualException) {
        if (!this.getExpectedException().isAssignableFrom(actualException.getClass())) {
            AssertionFailedError error = new AssertionFailedError(this.createMessageForWrongThrownExceptionType(actualException));
            error.initCause(actualException);
            throw error;
        }
    }

    protected String createMessageForWrongThrownExceptionType(Exception actualException) {
        StringBuffer sb = new StringBuffer();
        sb.append("Was expecting a [").append(this.getExpectedException().getName());
        sb.append("] to be thrown, but instead a [").append(actualException.getClass().getName());
        sb.append("] was thrown.");
        return sb.toString();
    }

    public final Exception getActualException() {
        return this.actualException;
    }
}

