/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util.stat;

import com.xunlei.util.HumanReadableUtil;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstarctTimeSpanStat {
    public static final String timeStatFmt = "%-21s %-8s %-20s %-8s %-20s %-20s %-20s %-20s\n";
    public static final String tableHeader = String.format("%-21s %-8s %-20s %-8s %-20s %-20s %-20s %-20s\n", "\u7c7b\u522b", "times", "avg", "slow", "slow_avg", "max", "slow_span", "all_span");
    protected String name;
    protected AtomicLong all_num = new AtomicLong();
    protected AtomicLong all_span = new AtomicLong();
    protected AtomicLong slow_num = new AtomicLong();
    protected AtomicLong slow_span = new AtomicLong();
    protected volatile long max_span;

    public AbstarctTimeSpanStat(String name) {
        this.name = name;
    }

    public String toString() {
        long all_numTMP = this.all_num.get();
        long all_spanTMP = this.all_span.get();
        long slow_numTMP = this.slow_num.get();
        long slow_spanTMP = this.slow_span.get();
        long allAvg = all_numTMP > 0L ? all_spanTMP / all_numTMP : 0L;
        long slowAvg = slow_numTMP > 0L ? slow_spanTMP / slow_numTMP : 0L;
        return String.format(timeStatFmt, this.name, all_numTMP, HumanReadableUtil.timeSpan(allAvg), slow_numTMP, HumanReadableUtil.timeSpan(slowAvg), HumanReadableUtil.timeSpan(this.max_span), HumanReadableUtil.timeSpan(slow_spanTMP), HumanReadableUtil.timeSpan(all_spanTMP));
    }

    public long getAllNum() {
        return this.all_num.get();
    }
}

