/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util.concurrent;

import com.xunlei.springutil.MailTemplate;
import com.xunlei.util.EmptyChecker;
import com.xunlei.util.HttpUtil;
import com.xunlei.util.concurrent.BaseRunnable;

public abstract class BaseRunnableWithMail
extends BaseRunnable {
    @Override
    public void afterProcess() {
        super.afterProcess();
        this.sendMail();
    }

    public String getMailContent() {
        return this.toString();
    }

    public String getMailSubject() {
        return "[" + HttpUtil.getLocalSampleIP() + "]" + this.getClass().getSimpleName() + " process result";
    }

    public abstract MailTemplate getMailTemplate();

    public abstract String[] getMailTo();

    public void sendMail() {
        Object[] mailTo = this.getMailTo();
        if (EmptyChecker.isNotEmpty(mailTo)) {
            this.getMailTemplate().sendTextMail(this.getMailTo(), this.getMailSubject(), this.getMailContent());
        }
    }
}

