/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util.codec.crypt;

import com.xunlei.util.Log;
import com.xunlei.util.StringHelper;
import com.xunlei.util.codec.DigestUtils;
import com.xunlei.util.codec.crypt.AESCrypt;
import org.slf4j.Logger;

public class AESCryptUtil {
    public static final ThreadLocal<AESCrypt> aesCryptFactory = new ThreadLocal<AESCrypt>(){

        @Override
        protected synchronized AESCrypt initialValue() {
            try {
                AESCrypt aes = new AESCrypt();
                return aes;
            }
            catch (Exception e) {
                log.error("", e);
                return null;
            }
        }
    };
    private static final Logger log = Log.getLogger();

    public static byte[] aesDecode(byte[] aesSecretKey, byte[] needDecodeContent) throws Exception {
        AESCrypt aes = aesCryptFactory.get();
        aes.setSecretKey(aesSecretKey);
        return aes.decode(needDecodeContent);
    }

    public static byte[] aesEncode(byte[] aesSecretKey, byte[] needEncodeContent) throws Exception {
        AESCrypt aes = aesCryptFactory.get();
        aes.setSecretKey(aesSecretKey);
        return aes.encode(needEncodeContent);
    }

    public static AESCrypt getAesByMd5(byte[] needMd5ToSecretKey) {
        AESCrypt aes = aesCryptFactory.get();
        aes.setSecretKey(AESCryptUtil.getSecretKeyByMd5(needMd5ToSecretKey));
        return aes;
    }

    public static AESCrypt getAesByMd5(Object ... needMd5ToSecretKey) {
        AESCrypt aes = aesCryptFactory.get();
        aes.setSecretKey(AESCryptUtil.getSecretKeyByMd5(needMd5ToSecretKey));
        return aes;
    }

    public static byte[] getSecretKeyByMd5(byte[] needMd5ToSecretKey) {
        return DigestUtils.md5(needMd5ToSecretKey);
    }

    public static byte[] getSecretKeyByMd5(Object ... needMd5ToSecretKey) {
        return DigestUtils.md5(StringHelper.concate(needMd5ToSecretKey));
    }
}

