/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util.codec;

import java.nio.ByteOrder;

public abstract class ByteTranscoder {
    public static final BigEndianTranscoder bigEndianTranscoder = new BigEndianTranscoder();
    public static final LittleEndianTranscoder littleEndianTranscoder = new LittleEndianTranscoder();

    public static ByteTranscoder getInstance(ByteOrder endian) {
        return endian == ByteOrder.BIG_ENDIAN ? bigEndianTranscoder : littleEndianTranscoder;
    }

    public int decodeChar(byte[] array) {
        return (char)this.getShort(array, 0);
    }

    public double decodeDouble(byte[] array) {
        return this.getDouble(array, 0);
    }

    public float decodeFloat(byte[] array) {
        return this.getFloat(array, 0);
    }

    public int decodeInt(byte[] array) {
        return this.getInt(array, 0);
    }

    public long decodeLong(byte[] array) {
        return this.getLong(array, 0);
    }

    public int decodeMedium(byte[] array) {
        return this.getMedium(array, 0);
    }

    public short decodeShort(byte[] array) {
        return this.getShort(array, 0);
    }

    public short decodeUnsignedByte(byte b) {
        return (short)(b & 0xFF);
    }

    public long decodeUnsignedInt(byte[] array) {
        return this.getUnsignedInt(array, 0);
    }

    public int decodeUnsignedMedium(byte[] array) {
        return this.getUnsignedMedium(array, 0);
    }

    public int decodeUnsignedShort(byte[] array) {
        return this.getUnsignedShort(array, 0);
    }

    public byte[] encodeChar(int value) {
        return this.encodeShort(value);
    }

    public byte[] encodeDouble(double value) {
        byte[] array = new byte[8];
        this.setDouble(array, 0, value);
        return array;
    }

    public byte[] encodeFloat(float value) {
        byte[] array = new byte[4];
        this.setFloat(array, 0, value);
        return array;
    }

    public byte[] encodeInt(int value) {
        byte[] array = new byte[4];
        this.setInt(array, 0, value);
        return array;
    }

    public byte[] encodeLong(long value) {
        byte[] array = new byte[8];
        this.setLong(array, 0, value);
        return array;
    }

    public byte[] encodeMedium(int value) {
        byte[] array = new byte[3];
        this.setMedium(array, 0, value);
        return array;
    }

    public byte[] encodeShort(int value) {
        byte[] array = new byte[2];
        this.setShort(array, 0, value);
        return array;
    }

    public byte getByte(byte[] array, int index) {
        return array[index];
    }

    public char getChar(byte[] array, int index) {
        return (char)this.getShort(array, index);
    }

    public double getDouble(byte[] array, int index) {
        return Double.longBitsToDouble(this.getLong(array, index));
    }

    public abstract ByteOrder getEndian();

    public float getFloat(byte[] array, int index) {
        return Float.intBitsToFloat(this.getInt(array, index));
    }

    public abstract int getInt(byte[] var1, int var2);

    public abstract long getLong(byte[] var1, int var2);

    public int getMedium(byte[] array, int index) {
        int value = this.getUnsignedMedium(array, index);
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return value;
    }

    public abstract short getShort(byte[] var1, int var2);

    public short getUnsignedByte(byte[] array, int index) {
        return (short)(this.getByte(array, index) & 0xFF);
    }

    public long getUnsignedInt(byte[] array, int index) {
        return (long)this.getInt(array, index) & 0xFFFFFFFFL;
    }

    public abstract int getUnsignedMedium(byte[] var1, int var2);

    public int getUnsignedShort(byte[] array, int index) {
        return this.getShort(array, index) & 0xFFFF;
    }

    public void setChar(byte[] array, int index, int value) {
        this.setShort(array, index, value);
    }

    public void setDouble(byte[] array, int index, double value) {
        this.setLong(array, index, Double.doubleToRawLongBits(value));
    }

    public void setFloat(byte[] array, int index, float value) {
        this.setInt(array, index, Float.floatToRawIntBits(value));
    }

    public abstract void setInt(byte[] var1, int var2, int var3);

    public abstract void setLong(byte[] var1, int var2, long var3);

    public abstract void setMedium(byte[] var1, int var2, int var3);

    public abstract void setShort(byte[] var1, int var2, int var3);

    public static class BigEndianTranscoder
    extends ByteTranscoder {
        private BigEndianTranscoder() {
        }

        @Override
        public ByteOrder getEndian() {
            return ByteOrder.BIG_ENDIAN;
        }

        @Override
        public int getInt(byte[] array, int index) {
            return (array[index] & 0xFF) << 24 | (array[index + 1] & 0xFF) << 16 | (array[index + 2] & 0xFF) << 8 | (array[index + 3] & 0xFF) << 0;
        }

        @Override
        public long getLong(byte[] array, int index) {
            return ((long)array[index] & 0xFFL) << 56 | ((long)array[index + 1] & 0xFFL) << 48 | ((long)array[index + 2] & 0xFFL) << 40 | ((long)array[index + 3] & 0xFFL) << 32 | ((long)array[index + 4] & 0xFFL) << 24 | ((long)array[index + 5] & 0xFFL) << 16 | ((long)array[index + 6] & 0xFFL) << 8 | ((long)array[index + 7] & 0xFFL) << 0;
        }

        @Override
        public short getShort(byte[] array, int index) {
            return (short)(array[index] << 8 | array[index + 1] & 0xFF);
        }

        @Override
        public int getUnsignedMedium(byte[] array, int index) {
            return (array[index] & 0xFF) << 16 | (array[index + 1] & 0xFF) << 8 | (array[index + 2] & 0xFF) << 0;
        }

        @Override
        public void setInt(byte[] array, int index, int value) {
            array[index] = (byte)(value >>> 24);
            array[index + 1] = (byte)(value >>> 16);
            array[index + 2] = (byte)(value >>> 8);
            array[index + 3] = (byte)(value >>> 0);
        }

        @Override
        public void setLong(byte[] array, int index, long value) {
            array[index] = (byte)(value >>> 56);
            array[index + 1] = (byte)(value >>> 48);
            array[index + 2] = (byte)(value >>> 40);
            array[index + 3] = (byte)(value >>> 32);
            array[index + 4] = (byte)(value >>> 24);
            array[index + 5] = (byte)(value >>> 16);
            array[index + 6] = (byte)(value >>> 8);
            array[index + 7] = (byte)(value >>> 0);
        }

        @Override
        public void setMedium(byte[] array, int index, int value) {
            array[index] = (byte)(value >>> 16);
            array[index + 1] = (byte)(value >>> 8);
            array[index + 2] = (byte)(value >>> 0);
        }

        @Override
        public void setShort(byte[] array, int index, int value) {
            array[index] = (byte)(value >>> 8);
            array[index + 1] = (byte)(value >>> 0);
        }
    }

    public static class LittleEndianTranscoder
    extends ByteTranscoder {
        private LittleEndianTranscoder() {
        }

        @Override
        public ByteOrder getEndian() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        @Override
        public int getInt(byte[] array, int index) {
            return (array[index] & 0xFF) << 0 | (array[index + 1] & 0xFF) << 8 | (array[index + 2] & 0xFF) << 16 | (array[index + 3] & 0xFF) << 24;
        }

        @Override
        public long getLong(byte[] array, int index) {
            return ((long)array[index] & 0xFFL) << 0 | ((long)array[index + 1] & 0xFFL) << 8 | ((long)array[index + 2] & 0xFFL) << 16 | ((long)array[index + 3] & 0xFFL) << 24 | ((long)array[index + 4] & 0xFFL) << 32 | ((long)array[index + 5] & 0xFFL) << 40 | ((long)array[index + 6] & 0xFFL) << 48 | ((long)array[index + 7] & 0xFFL) << 56;
        }

        @Override
        public short getShort(byte[] array, int index) {
            return (short)(array[index] & 0xFF | array[index + 1] << 8);
        }

        @Override
        public int getUnsignedMedium(byte[] array, int index) {
            return (array[index] & 0xFF) << 0 | (array[index + 1] & 0xFF) << 8 | (array[index + 2] & 0xFF) << 16;
        }

        @Override
        public void setInt(byte[] array, int index, int value) {
            array[index] = (byte)(value >>> 0);
            array[index + 1] = (byte)(value >>> 8);
            array[index + 2] = (byte)(value >>> 16);
            array[index + 3] = (byte)(value >>> 24);
        }

        @Override
        public void setLong(byte[] array, int index, long value) {
            array[index] = (byte)(value >>> 0);
            array[index + 1] = (byte)(value >>> 8);
            array[index + 2] = (byte)(value >>> 16);
            array[index + 3] = (byte)(value >>> 24);
            array[index + 4] = (byte)(value >>> 32);
            array[index + 5] = (byte)(value >>> 40);
            array[index + 6] = (byte)(value >>> 48);
            array[index + 7] = (byte)(value >>> 56);
        }

        @Override
        public void setMedium(byte[] array, int index, int value) {
            array[index] = (byte)(value >>> 0);
            array[index + 1] = (byte)(value >>> 8);
            array[index + 2] = (byte)(value >>> 16);
        }

        @Override
        public void setShort(byte[] array, int index, int value) {
            array[index] = (byte)(value >>> 0);
            array[index + 1] = (byte)(value >>> 8);
        }
    }
}

