/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util;

import com.xunlei.util.Log;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;

public class ResourceBundleUtil {
    private static final Logger log = Log.getLogger();
    private static final NoCacheResourceBundleControl noCacheResourceBundleControl = new NoCacheResourceBundleControl();

    public static ResourceBundle reload(String filterName) {
        try {
            return ResourceBundle.getBundle(filterName, Locale.ENGLISH, noCacheResourceBundleControl);
        }
        catch (MissingResourceException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private static class NoCacheResourceBundleControl
    extends ResourceBundle.Control {
        private NoCacheResourceBundleControl() {
        }

        @Override
        public long getTimeToLive(String baseName, Locale locale) {
            return -1L;
        }
    }
}

