/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;

public class HttpUtil {
    private static Set<String> localIPSet;
    private static String localSampleIP;

    public static String getIP(InetSocketAddress inetSocketAddress) {
        InetAddress addr;
        if (inetSocketAddress != null && (addr = inetSocketAddress.getAddress()) != null) {
            return addr.getHostAddress();
        }
        return "";
    }

    public static Set<String> getLocalIP() {
        if (localIPSet == null) {
            localIPSet = new LinkedHashSet<String>(3);
            try {
                Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
                while (e1.hasMoreElements()) {
                    NetworkInterface ni = e1.nextElement();
                    Enumeration<InetAddress> e2 = ni.getInetAddresses();
                    while (e2.hasMoreElements()) {
                        InetAddress ia = e2.nextElement();
                        if (ia instanceof Inet6Address) continue;
                        localIPSet.add(ia.getHostAddress());
                    }
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
        return localIPSet;
    }

    public static String getLocalSampleIP() {
        if (localSampleIP == null) {
            Set<String> set = HttpUtil.getLocalIP();
            for (String str : set) {
                if (str.equals("127.0.0.1")) continue;
                localSampleIP = str;
                break;
            }
        }
        return localSampleIP;
    }

    public static Set<String> getIPByDomainName(String domainName) {
        LinkedHashSet<String> domainIPSet = new LinkedHashSet<String>(2);
        try {
            InetAddress[] inets;
            InetAddress[] inetAddressArray = inets = InetAddress.getAllByName(domainName);
            int n = inets.length;
            int n2 = 0;
            while (n2 < n) {
                InetAddress inetAddress = inetAddressArray[n2];
                domainIPSet.add(inetAddress.getHostAddress());
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainIPSet;
    }
}

