/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util;

import com.xunlei.util.DateUtilHelper;
import com.xunlei.util.DateUtils;
import com.xunlei.util.UnitConverter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    public static final String DF_yyyyMMddHHmmss = "yyyyMMddHHmmss";
    public static final String DF_yyMMddHHmmss = "yyMMddHHmmss";
    public static final String DF_yyyyMMdd = "yyyyMMdd";
    public static final String DF_yyMMdd = "yyMMdd";
    public static final String DF_yyyy_MM_dd_HHmmss = "yyyy-MM-dd HH:mm:ss";
    public static final String DF_yy_MM_dd_HHmmss = "yy-MM-dd HH:mm:ss";
    public static final String DF_yyyy_MM_dd = "yyyy-MM-dd";
    public static final String DF_yy_MM_dd = "yy-MM-dd";
    public static final String DF_DEFAULT = "yyyy-MM-dd HH:mm:ss";
    public static final String DF_DEFAULT_DAY = "yyyy-MM-dd";
    public static final String DF_DEFAULT_GMT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final DateFormat UNSAFE_DF_yyyyMMddHHmmss = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final DateFormat UNSAFE_DF_yyMMddHHmmss = new SimpleDateFormat("yyMMddHHmmss");
    public static final DateFormat UNSAFE_DF_yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
    public static final DateFormat UNSAFE_DF_yyMMdd = new SimpleDateFormat("yyMMdd");
    public static final DateFormat UNSAFE_DF_yyyy_MM_dd_HHmmss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final DateFormat UNSAFE_DF_yy_MM_dd_HHmmss = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
    public static final DateFormat UNSAFE_DF_yyyy_MM_dd = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat UNSAFE_DF_yy_MM_dd = new SimpleDateFormat("yy-MM-dd");
    public static final DateFormat UNSAFE_DF_DEFAULT = UNSAFE_DF_yyyy_MM_dd_HHmmss;
    public static final DateFormat UNSAFE_DF_DEFAULT_DAY = UNSAFE_DF_yyyy_MM_dd;
    public static final ThreadLocal<DateFormat> DEFAULT_DF_FACOTRY = DateUtil.makeDateFormatPerThread("yyyy-MM-dd HH:mm:ss");
    public static final ThreadLocal<DateFormat> DEFAULT_DAY_DF_FACOTRY = DateUtil.makeDateFormatPerThread("yyyy-MM-dd");
    public static final ThreadLocal<DateFormat> GMT_DF_FACOTRY = DateUtil.makeDateFormatPerThread("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US, true, TimeZone.getTimeZone("GMT"));
    private static final int DEFAULT_COMPARE_YEAR = 1986;

    public static ThreadLocal<DateFormat> makeDateFormatPerThread(final String pattern, final Locale locale, final boolean lenient, final TimeZone zone) {
        return new ThreadLocal<DateFormat>(){

            @Override
            protected synchronized DateFormat initialValue() {
                try {
                    SimpleDateFormat df = locale == null ? new SimpleDateFormat(pattern) : new SimpleDateFormat(pattern, locale);
                    df.setLenient(lenient);
                    if (zone != null) {
                        df.setTimeZone(zone);
                    }
                    return df;
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
    }

    public static ThreadLocal<DateFormat> makeDateFormatPerThread(String pattern) {
        return DateUtil.makeDateFormatPerThread(pattern, null, true, null);
    }

    public static Calendar set(Calendar calendar, int calendarField, int amount) {
        calendar.set(calendarField, amount);
        return calendar;
    }

    public static Date set(Date date, int calendarField, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendarField, amount);
        return calendar.getTime();
    }

    public static long set(long timeMillis, int calendarField, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeMillis);
        calendar.set(calendarField, amount);
        return calendar.getTimeInMillis();
    }

    public static Calendar add(Calendar calendar, int calendarField, int amount) {
        calendar.add(calendarField, amount);
        return calendar;
    }

    public static Date add(Date date, int calendarField, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(calendarField, amount);
        return calendar.getTime();
    }

    public static long add(long timeMillis, int calendarField, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeMillis);
        calendar.add(calendarField, amount);
        return calendar.getTimeInMillis();
    }

    public static Calendar roll(Calendar calendar, int calendarField, int amount) {
        calendar.roll(calendarField, amount);
        return calendar;
    }

    public static Date roll(Date date, int calendarField, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.roll(calendarField, amount);
        return calendar.getTime();
    }

    public static long roll(long timeMillis, int calendarField, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeMillis);
        calendar.roll(calendarField, amount);
        return calendar.getTimeInMillis();
    }

    public static Calendar ceil(Calendar calendar, int calendarField) {
        DateUtils.modify(calendar, calendarField, 2);
        return calendar;
    }

    public static Date ceil(Date date, int calendarField) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, calendarField, 2);
        return calendar.getTime();
    }

    public static long ceil(long timeMillis, int calendarField) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeMillis);
        DateUtils.modify(calendar, calendarField, 2);
        return calendar.getTimeInMillis();
    }

    public static Calendar round(Calendar calendar, int calendarField) {
        DateUtils.modify(calendar, calendarField, 1);
        return calendar;
    }

    public static Date round(Date date, int calendarField) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, calendarField, 1);
        return calendar.getTime();
    }

    public static long round(long timeMillis, int calendarField) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeMillis);
        DateUtils.modify(calendar, calendarField, 1);
        return calendar.getTimeInMillis();
    }

    public static Calendar truncate(Calendar calendar, int calendarField) {
        DateUtils.modify(calendar, calendarField, 0);
        return calendar;
    }

    public static Date truncate(Date date, int calendarField) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, calendarField, 0);
        return calendar.getTime();
    }

    public static long truncate(long timeMillis, int calendarField) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeMillis);
        DateUtils.modify(calendar, calendarField, 0);
        return calendar.getTimeInMillis();
    }

    public static Calendar oper(Calendar calendar, long ... opers) {
        long[] lArray = opers;
        int n = opers.length;
        int n2 = 0;
        while (n2 < n) {
            long operMagic = lArray[n2];
            int amount = DateUtilHelper.getAmount(operMagic);
            int operType = DateUtilHelper.getOperType(operMagic);
            int calendarField = DateUtilHelper.getCalendarField(operMagic);
            switch (operType) {
                case 5: {
                    calendar.set(calendarField, amount);
                    break;
                }
                case 4: {
                    calendar.add(calendarField, amount);
                    break;
                }
                case 3: {
                    calendar.roll(calendarField, amount);
                    break;
                }
                case 2: {
                    DateUtils.modify(calendar, calendarField, operType);
                    break;
                }
                case 1: {
                    DateUtils.modify(calendar, calendarField, operType);
                    break;
                }
                case 0: {
                    DateUtils.modify(calendar, calendarField, operType);
                }
            }
            ++n2;
        }
        return calendar;
    }

    public static Date oper(Date date, long ... opers) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar r = DateUtil.oper(calendar, opers);
        return r.getTime();
    }

    public static long oper(long timeMillis, long ... opers) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeMillis);
        Calendar r = DateUtil.oper(calendar, opers);
        return r.getTimeInMillis();
    }

    public static long getInterval(Date date1, Date date2, UnitConverter.TimeUnit timeUnit, boolean ceil) {
        if (timeUnit == UnitConverter.TimeUnit.month) {
            return DateUtil.getMonthsBetween(date1, date2, ceil);
        }
        if (timeUnit == UnitConverter.TimeUnit.year) {
            return DateUtil.getYearsBetween(date1, date2, ceil);
        }
        return (long)UnitConverter.convertTime(date1.getTime() - date2.getTime(), UnitConverter.TimeUnit.millisecond, timeUnit, ceil);
    }

    public static long getInterval(Date date1, Date date2, UnitConverter.TimeUnit timeUnit) {
        return DateUtil.getInterval(date1, date2, timeUnit, false);
    }

    private static long getYearsBetween(Date date1, Date date2, boolean ceil) {
        Calendar c = Calendar.getInstance();
        c.setTime(date1);
        int year1 = c.get(1);
        c.set(1, 1986);
        long time1 = c.getTimeInMillis();
        c.setTime(date2);
        int year2 = c.get(1);
        c.set(1, 1986);
        long time2 = c.getTimeInMillis();
        long result = year1 - year2;
        return DateUtil.ceil(result, time1, time2, ceil);
    }

    private static long getMonthsBetween(Date date1, Date date2, boolean ceil) {
        Calendar c = Calendar.getInstance();
        c.setTime(date1);
        int month1 = c.get(2);
        int year1 = c.get(1);
        c.set(2, 0);
        c.set(1, 1986);
        long time1 = c.getTimeInMillis();
        c.setTime(date2);
        int month2 = c.get(2);
        int year2 = c.get(1);
        c.set(2, 0);
        c.set(1, 1986);
        long time2 = c.getTimeInMillis();
        long result = (long)(year1 - year2) * 12L + (long)(month1 - month2);
        return DateUtil.ceil(result, time1, time2, ceil);
    }

    private static long ceil(long result, long time1, long time2, boolean ceil) {
        long diff;
        long ret = result;
        if (ceil) {
            if (ret == 0L) {
                long diff2 = time1 - time2;
                if (diff2 > 0L) {
                    ret = 1L;
                } else if (diff2 < 0L) {
                    ret = -1L;
                }
            }
        } else if (ret != 0L && (diff = time1 - time2) != 0L) {
            if (ret > 0L && diff < 0L) {
                --ret;
            } else if (ret < 0L && diff > 0L) {
                ++ret;
            }
        }
        return ret;
    }
}

