/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.usercentre.util;

import com.xunlei.server.common.util.CommonUtil;
import com.xunlei.server.register.proxy.GameUserException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class SocketUtil {
    private static int READ_LENGTH_MAX = 1024;

    public static void release(Socket socket) {
        if (null != socket) {
            try {
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            socket = null;
        }
    }

    public static void release(OutputStream out) {
        if (null != out) {
            try {
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            out = null;
        }
    }

    public static void release(InputStream in) {
        if (null != in) {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            in = null;
        }
    }

    public static byte[] commonRequest2(String server, int port, int timeout, byte[] lengthBytes, byte[] data) throws GameUserException {
        byte[] requestByte = new byte[lengthBytes.length + data.length];
        System.arraycopy(lengthBytes, 0, requestByte, 0, lengthBytes.length);
        System.arraycopy(data, 0, requestByte, lengthBytes.length, data.length);
        return SocketUtil.commonRequest2(server, port, timeout, requestByte);
    }

    public static byte[] commonRequest2(String server, int port, int timeout, byte[] requestBytes) throws GameUserException {
        Socket socket = null;
        try {
            socket = new Socket(server, port);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(timeout);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            output.write(requestBytes);
            byte[] readLengthBytes = new byte[4];
            input.read(readLengthBytes);
            int readLength = CommonUtil.byteArrayToInt(readLengthBytes);
            if (readLength <= 0) {
                throw new GameUserException("Invalid package length: " + readLength);
            }
            byte[] readData = new byte[readLength];
            input.read(readData);
            byte[] retByte = new byte[4 + readData.length];
            System.arraycopy(readLengthBytes, 0, retByte, 0, 4);
            System.arraycopy(readData, 0, retByte, 4, readData.length);
            byte[] byArray = retByte;
            return byArray;
        }
        catch (Exception e) {
            throw new GameUserException(e);
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] commonRequest(String server, int port, int timeout, byte[] requestBytes) throws UnknownHostException, IOException {
        byte[] byArray;
        Socket socket = null;
        try {
            socket = new Socket(server, port);
            socket.setSoTimeout(timeout);
            OutputStream out = socket.getOutputStream();
            InputStream in = socket.getInputStream();
            out.write(requestBytes);
            byte[] buf = new byte[READ_LENGTH_MAX];
            int length = in.read(buf);
            byte[] ret = new byte[length];
            System.arraycopy(buf, 0, ret, 0, length);
            byArray = ret;
        }
        catch (Throwable throwable) {
            SocketUtil.release(socket);
            throw throwable;
        }
        SocketUtil.release(socket);
        return byArray;
    }
}

