/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.common.util;

import com.xunlei.server.common.util.BigArrayListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigArrayList<T>
implements Collection<T>,
Cloneable {
    private ArrayList<T[]> data;
    private T[] currentArray;
    private int eachSize;
    private int size = 0;
    private int currentArrayPos = 0;

    public BigArrayList(int eachSize) {
        this.eachSize = eachSize;
        this.data = new ArrayList();
        this.currentArray = new Object[eachSize];
    }

    public BigArrayList() {
        this(20000);
    }

    @Override
    public Iterator<T> iterator() {
        return new BigArrayListIterator(this);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean add(T o) {
        this.currentArray[this.currentArrayPos] = o;
        ++this.size;
        ++this.currentArrayPos;
        if (this.currentArrayPos >= this.eachSize) {
            this.currentArrayPos = 0;
            this.data.add(this.currentArray);
            this.currentArray = new Object[this.eachSize];
        }
        return true;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends T> c) {
        if (c != null) {
            for (T t : c) {
                this.add(t);
            }
        }
        return true;
    }

    @Override
    public synchronized void clear() {
        this.data.clear();
        this.size = 0;
        this.currentArrayPos = 0;
        this.data = new ArrayList();
        this.currentArray = new Object[this.eachSize];
    }

    private boolean contains(Object o, T[] array) {
        for (T t : array) {
            if (t == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!o.equals(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        boolean contain = this.contains(o, this.currentArray);
        if (!contain) {
            for (T[] row : this.data) {
                if (!this.contains(o, row)) continue;
                contain = true;
                break;
            }
        }
        return contain;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty() && (this.currentArray == null || this.currentArray.length == 0);
    }

    public Object clone() throws CloneNotSupportedException {
        return this.duplicate();
    }

    public synchronized BigArrayList<T> duplicate() {
        BigArrayList<T> clone = new BigArrayList<T>(this.eachSize);
        for (T[] row : this.data) {
            clone.data.add((T[])row.clone());
        }
        clone.currentArray = (Object[])this.currentArray.clone();
        clone.size = this.size;
        clone.currentArrayPos = this.currentArrayPos;
        return clone;
    }

    T[] getCurrentArray() {
        return this.currentArray;
    }

    ArrayList<T[]> getData() {
        return this.data;
    }

    public synchronized ArrayList<T> removeHeaderList() {
        if (this.data.size() <= 0) {
            throw new IndexOutOfBoundsException("Size(" + this.size() + ") is less than " + this.eachSize);
        }
        T[] removedArray = this.data.remove(0);
        int len = removedArray.length;
        this.size -= len;
        ArrayList<T> array = new ArrayList<T>(len);
        for (T o : removedArray) {
            array.add(o);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<T> removeRandomList(List<T> list) {
        int rows = this.data.size();
        ArrayList removedDataForEachArray = new ArrayList(this.data.size());
        ArrayList<Integer> removedDataForCurrentArray = new ArrayList<Integer>();
        int removeArraySize = list.size() / rows * 2;
        ArrayList<T> removedList = new ArrayList<T>(list.size());
        List<T> list2 = list;
        synchronized (list2) {
            for (int i = 0; i < rows; ++i) {
                ArrayList<Integer> removeArray = new ArrayList<Integer>(removeArraySize);
                removedDataForEachArray.add(removeArray);
                T[] dataArray = this.data.get(i);
                int len = dataArray.length;
                block4: for (int j = 0; j < len; ++j) {
                    T o = dataArray[j];
                    for (T r : list) {
                        if (!o.equals(r)) continue;
                        removeArray.add(j);
                        removedList.add(o);
                        continue block4;
                    }
                }
            }
            int len = this.currentArrayPos;
            block6: for (int j = 0; j < len; ++j) {
                T o = this.currentArray[j];
                for (T r : list) {
                    if (!o.equals(r)) continue;
                    removedDataForCurrentArray.add(j);
                    removedList.add(o);
                    continue block6;
                }
            }
        }
        for (int i = 0; i < rows; ++i) {
            ArrayList removeArray = (ArrayList)removedDataForEachArray.get(i);
            T[] dataArray = this.data.get(i);
            T[] copyArray = this.removeElements(dataArray, removeArray);
            if (copyArray == null) continue;
            this.data.set(i, copyArray);
        }
        T[] copyArray = this.removeElementsNoCopy(this.currentArray, removedDataForCurrentArray);
        if (copyArray != null) {
            this.currentArray = copyArray;
        }
        this.size -= removedList.size();
        this.currentArrayPos -= removedDataForCurrentArray.size();
        this.combine();
        return removedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<T> removeSequenceList(List<T> list) {
        int listsize = list.size();
        int rows = this.data.size();
        ArrayList removedDataForEachArray = new ArrayList(rows);
        int removeArraySize = rows != 0 ? (int)((double)(list.size() / rows) * 1.1) : list.size();
        ArrayList<T> removedList = new ArrayList<T>(list.size());
        List<T> list2 = list;
        synchronized (list2) {
            int dataArrayLen;
            T[] dataArray;
            if (rows > 0) {
                dataArray = this.data.get(0);
                dataArrayLen = dataArray.length;
            } else {
                dataArray = this.currentArray;
                dataArrayLen = this.currentArrayPos;
            }
            ArrayList<Integer> removeArray = new ArrayList<Integer>(removeArraySize);
            removedDataForEachArray.add(removeArray);
            int pos4List = 0;
            int rowNo = 0;
            int currentPos = 0;
            block3: while (pos4List < listsize) {
                T o = list.get(pos4List);
                if (currentPos >= dataArrayLen) {
                    if (++rowNo > rows) break;
                    if (rowNo == rows) {
                        dataArray = this.currentArray;
                        dataArrayLen = this.currentArrayPos;
                    } else {
                        dataArray = this.data.get(rowNo);
                        dataArrayLen = dataArray.length;
                    }
                    removeArray = new ArrayList(removeArraySize);
                    removedDataForEachArray.add(removeArray);
                    currentPos = 0;
                }
                for (int j = currentPos; j < dataArrayLen; ++j) {
                    T t = dataArray[j];
                    if (!t.equals(o)) continue;
                    removeArray.add(j);
                    removedList.add(o);
                    ++pos4List;
                    currentPos = ++j;
                    continue block3;
                }
                currentPos = dataArrayLen;
            }
        }
        int modifiedRows = removedDataForEachArray.size();
        for (int i = 0; i < rows && i < modifiedRows; ++i) {
            T[] dataArray;
            T[] copyArray;
            ArrayList removeArray = (ArrayList)removedDataForEachArray.get(i);
            if (removeArray.size() == 0 || (copyArray = this.removeElements(dataArray = this.data.get(i), removeArray)) == null) continue;
            this.data.set(i, copyArray);
        }
        if (modifiedRows > this.data.size()) {
            T[] copyArray = this.removeElementsNoCopy(this.currentArray, (ArrayList)removedDataForEachArray.get(rows));
            if (copyArray != null) {
                this.currentArray = copyArray;
            }
            this.currentArrayPos -= ((ArrayList)removedDataForEachArray.get(rows)).size();
        }
        this.size -= removedList.size();
        this.combine();
        return removedList;
    }

    private T[] removeElements(T[] src, ArrayList<Integer> positionList) {
        if (positionList.size() <= 0) {
            return null;
        }
        for (Integer pos : positionList) {
            src[pos.intValue()] = null;
        }
        int len = src.length;
        Object[] copyArray = new Object[len - positionList.size()];
        int j2 = 0;
        for (int j = 0; j < len; ++j) {
            T o = src[j];
            if (o == null) continue;
            copyArray[j2++] = o;
        }
        return copyArray;
    }

    private T[] removeElementsNoCopy(T[] src, ArrayList<Integer> positionList) {
        if (positionList.size() <= 0) {
            return null;
        }
        for (Integer pos : positionList) {
            src[pos.intValue()] = null;
        }
        int len = src.length;
        int j2 = 0;
        for (int j = 0; j < len; ++j) {
            T o = src[j];
            if (o == null) {
                ++j2;
                continue;
            }
            if (j2 == 0) continue;
            src[j - j2] = src[j];
        }
        return src;
    }

    private void combine() {
        int rows = this.data.size();
        for (int i = 0; i < rows - 1; ++i) {
            int j;
            T[] row2;
            int len2;
            T[] row1 = this.data.get(i);
            int len1 = row1.length;
            int totalLen = len1 + (len2 = (row2 = this.data.get(i + 1)).length);
            if (!((double)totalLen <= (double)this.eachSize * 1.1)) continue;
            Object[] array = new Object[totalLen];
            for (j = 0; j < len1; ++j) {
                array[j] = row1[j];
            }
            for (j = 0; j < len2; ++j) {
                array[j + len1] = row2[j];
            }
            this.data.set(i, array);
            this.data.remove(i + 1);
            --rows;
        }
    }

    public synchronized int getRows() {
        return this.data.size() + 1;
    }

    public synchronized ArrayList<T> getRow(int rowNo) {
        if (this.data.size() < rowNo) {
            throw new IndexOutOfBoundsException("rows(" + (this.data.size() + 1) + ")");
        }
        T[] resultArray = rowNo == this.data.size() ? this.currentArray : this.data.remove(rowNo);
        int len = resultArray.length;
        this.size -= len;
        ArrayList<T> array = new ArrayList<T>(len);
        for (T o : resultArray) {
            array.add(o);
        }
        return array;
    }
}

