/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.common.socketpool;

import com.xunlei.server.common.socketpool.XLSocket;
import com.xunlei.server.common.socketpool.XLSocketPoolConfig;
import com.xunlei.server.common.socketpool.XLSocketPoolObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public final class XLSocketPool {
    private GenericObjectPool socketPool;
    private boolean longLink;
    private XLSocketPoolConfig config;

    public XLSocketPool(XLSocketPoolConfig config) {
        if (config == null) {
            return;
        }
        this.longLink = config.isLongLink();
        this.config = config;
        if (this.longLink) {
            this.socketPool = new GenericObjectPool(new XLSocketPoolObjectFactory(config));
            this.socketPool.setMaxActive(config.getMaxActive());
            this.socketPool.setMaxIdle(config.getMaxIddle());
            this.socketPool.setMinEvictableIdleTimeMillis(config.getMinEvictableIdleTimeMillis());
            this.socketPool.setTimeBetweenEvictionRunsMillis(config.getTimeBetweenEvictionRunsMillis());
            this.socketPool.setTestWhileIdle(true);
            this.socketPool.setMaxWait(config.getMaxWaitMillis());
            this.socketPool.setTestOnReturn(true);
            this.socketPool.setWhenExhaustedAction((byte)1);
        }
    }

    public XLSocket borrowSocket() throws Exception {
        if (this.longLink) {
            return (XLSocket)this.socketPool.borrowObject();
        }
        XLSocket socket = new XLSocket(this.config.getServer(), this.config.getPort());
        socket.setTimeout(this.config.getTimeoutMillis());
        return socket;
    }

    public void returnSocket(XLSocket socket) throws Exception {
        if (socket != null) {
            if (this.longLink) {
                this.socketPool.returnObject(socket);
            } else {
                socket.close();
            }
        }
    }

    public void closeConnections() {
        if (this.longLink) {
            this.socketPool.clear();
        }
    }

    public int getActiveConnections() {
        return this.longLink ? this.socketPool.getNumActive() : 0;
    }

    public int getIdleConnections() {
        return this.longLink ? this.socketPool.getNumIdle() : 0;
    }
}

