/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.common.socketpool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class XLSocket {
    private Socket socket;
    private boolean isOK;

    public XLSocket(String server, int port) throws IOException {
        this.socket = new Socket(server, port);
        this.isOK = true;
    }

    public InputStream getInput() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutput() throws IOException {
        return this.socket.getOutputStream();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public int hashCode() {
        return this.socket.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getSocket().equals(((XLSocket)obj).getSocket());
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        try {
            this.socket.getInputStream();
        }
        catch (Exception e) {
            return false;
        }
        return this.socket.isConnected();
    }

    public boolean isOK() {
        return this.isOK;
    }

    public void setOK(boolean isOK) {
        this.isOK = isOK;
    }

    public void setTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }
}

