/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy.socket.std;

import com.xunlei.proxy.socket.std.XLDecoderHelper;
import com.xunlei.proxy.socket.std.XLStandardCodecConfig;
import com.xunlei.proxy.socket.std.msg.HeaderContentSplit;
import com.xunlei.proxy.socket.std.msg.XLMessage;
import com.xunlei.proxy.socket.std.msg.XLMessageHeader;
import com.xunlei.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.slf4j.Logger;

public class XLStandardDecoder
extends FrameDecoder {
    private static final Logger log = Log.getLogger();
    private Class<? extends XLMessageHeader> headerClazz;
    private Field[] fields;
    private XLMessageHeader mh;
    private int state;
    private XLStandardCodecConfig config = XLStandardCodecConfig.DEFAULT;

    public XLStandardDecoder(Class<? extends XLMessageHeader> headerClazz, XLStandardCodecConfig config) {
        this.config = config;
        this.fields = headerClazz.getDeclaredFields();
        this.headerClazz = headerClazz;
        try {
            this.mh = this.headerClazz.newInstance();
            this.state = 0;
        }
        catch (Exception e) {
            throw new RuntimeException("init XLMessageHeader fail!", e);
        }
    }

    public XLStandardDecoder(Class<? extends XLMessageHeader> headerClazz) {
        this(headerClazz, XLStandardCodecConfig.DEFAULT);
    }

    public void decodeHeader(Field[] fields, XLMessageHeader mh, ChannelBuffer cb, XLStandardCodecConfig config) throws Exception {
        while (this.state < fields.length) {
            Field f = fields[this.state];
            HeaderContentSplit hcs = f.getAnnotation(HeaderContentSplit.class);
            if (hcs != null) break;
            XLDecoderHelper.setValue(f, mh, cb, config);
            ++this.state;
        }
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer cb) throws Exception {
        block5: {
            if (cb.readable()) break block5;
            return null;
        }
        try {
            if (this.mh == null) {
                this.state = 0;
                this.mh = this.headerClazz.newInstance();
            }
            this.decodeHeader(this.fields, this.mh, cb, this.config);
            int contentLen = XLDecoderHelper.getContentLength(this.mh, this.config);
            ChannelBuffer content = XLDecoderHelper.readBytes(cb, contentLen);
            content = XLDecoderHelper.decodeContentByAes(this.mh, content, this.config);
            XLMessage m = XLDecoderHelper.decodeContent(this.state, this.fields, this.mh, content, this.config);
            this.mh = null;
            log.debug("decode:{},channel:{}", m, (Object)channel);
            return m;
        }
        catch (XLStandardCodecConfig.ReplayError e) {
            return null;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("XLMessage decode fail!", e.getTargetException());
        }
    }

    @Deprecated
    protected Object decode_bak(ChannelHandlerContext ctx, Channel channel, ChannelBuffer cb) throws Exception {
        block10: {
            if (cb.readable()) break block10;
            return null;
        }
        try {
            if (this.mh == null) {
                this.state = 0;
                this.mh = this.headerClazz.newInstance();
            }
            while (this.state < this.fields.length) {
                XLDecoderHelper.setValue(this.fields[this.state], this.mh, cb, this.config);
                ++this.state;
            }
            int contentLen = this.mh.getMessageLength() - this.config.getCommondHeaderLength();
            if (contentLen < 0) {
                throw new IllegalStateException("XLMessageHeader decode fail! messageLen:" + contentLen);
            }
            ChannelBuffer content = XLDecoderHelper.readBytes(cb, contentLen);
            try {
                XLMessage m = this.mh.getDecodeMessage();
                m.setXlMessageHeader(this.mh);
                Field[] fieldArray = m.getClass().getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    XLDecoderHelper.setValueIncludeArray(f, m, content, this.config);
                    ++n2;
                }
                this.mh = null;
                log.debug("decode:{},channel:{}", m, (Object)channel);
                return m;
            }
            catch (Throwable e) {
                throw new IllegalStateException("XLMessage decode fail!", e);
            }
        }
        catch (XLStandardCodecConfig.ReplayError e) {
            return null;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("XLMessage decode fail!", e.getTargetException());
        }
    }
}

