/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy.socket.std;

import com.xunlei.proxy.socket.std.XLStandardCodecConfig;
import com.xunlei.proxy.socket.std.msg.HeaderContentSplit;
import com.xunlei.proxy.socket.std.msg.Unsigned;
import com.xunlei.proxy.socket.std.msg.XLMessage;
import com.xunlei.proxy.socket.std.msg.XLMessageHeader;
import com.xunlei.proxy.socket.std.msg.XLMessageStruct;
import com.xunlei.util.EmptyChecker;
import com.xunlei.util.Log;
import com.xunlei.util.ReflectConvention;
import com.xunlei.util.codec.crypt.AESCryptUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.springframework.util.ReflectionUtils;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class XLDecoderHelper {
    private static final Logger log = Log.getLogger();

    private XLDecoderHelper() {
    }

    public static void checkReadableBytes(ChannelBuffer buffer, int readableBytes) {
        if (buffer.readableBytes() < readableBytes) {
            throw XLStandardCodecConfig.REPLAY;
        }
    }

    public static Type getActualType(Field f) {
        Type genericType = f.getGenericType();
        assert (genericType != f.getType());
        ParameterizedTypeImpl pt = (ParameterizedTypeImpl)genericType;
        Type[] collectionArgsType = pt.getActualTypeArguments();
        Type realType = collectionArgsType[0];
        return realType;
    }

    public static Collection newCollection(Class<?> rawType) throws Exception {
        boolean isFieldTypeAbstarct;
        Class<?> type = rawType;
        int mod = type.getModifiers();
        boolean bl = isFieldTypeAbstarct = Modifier.isInterface(mod) || Modifier.isAbstract(mod);
        Class<?> collectionType = isFieldTypeAbstarct ? (Set.class.isAssignableFrom(type) ? HashSet.class : ArrayList.class) : type;
        return (Collection)collectionType.newInstance();
    }

    public static byte readByte(ChannelBuffer cb) {
        XLDecoderHelper.checkReadableBytes(cb, 1);
        return cb.readByte();
    }

    public static ChannelBuffer readBytes(ChannelBuffer cb, int len) {
        XLDecoderHelper.checkReadableBytes(cb, len);
        return cb.readBytes(len);
    }

    public static int readInt(ChannelBuffer cb) {
        XLDecoderHelper.checkReadableBytes(cb, 4);
        return cb.readInt();
    }

    public static long readLong(ChannelBuffer cb) {
        XLDecoderHelper.checkReadableBytes(cb, 8);
        return cb.readLong();
    }

    public static short readShort(ChannelBuffer cb) {
        XLDecoderHelper.checkReadableBytes(cb, 2);
        return cb.readShort();
    }

    public static short readUnsignedByte(ChannelBuffer cb) {
        XLDecoderHelper.checkReadableBytes(cb, 1);
        return cb.readUnsignedByte();
    }

    public static long readUnsignedInt(ChannelBuffer cb) {
        XLDecoderHelper.checkReadableBytes(cb, 4);
        return cb.readUnsignedInt();
    }

    public static int readUnsignedShort(ChannelBuffer cb) {
        XLDecoderHelper.checkReadableBytes(cb, 2);
        return cb.readUnsignedShort();
    }

    public static Collection readArray0(Class<?> rawType, Type actualType, ChannelBuffer cb, boolean unsigned, XLStandardCodecConfig config) throws Exception {
        Collection collection;
        block19: {
            int size;
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block18: {
                                    size = config.isLixianCodec() ? (int)cb.readLong() : cb.readInt();
                                    collection = XLDecoderHelper.newCollection(rawType);
                                    if (actualType != String.class) break block18;
                                    int i = 0;
                                    while (i < size) {
                                        collection.add(XLDecoderHelper.readString0(cb, config));
                                        ++i;
                                    }
                                    break block19;
                                }
                                if (actualType != Integer.class) break block20;
                                if (unsigned) {
                                    int i = 0;
                                    while (i < size) {
                                        collection.add(cb.readUnsignedShort());
                                        ++i;
                                    }
                                } else {
                                    int i = 0;
                                    while (i < size) {
                                        collection.add(cb.readInt());
                                        ++i;
                                    }
                                }
                                break block19;
                            }
                            if (actualType != Long.class) break block21;
                            if (unsigned) {
                                int i = 0;
                                while (i < size) {
                                    collection.add(cb.readUnsignedInt());
                                    ++i;
                                }
                            } else {
                                int i = 0;
                                while (i < size) {
                                    collection.add(cb.readLong());
                                    ++i;
                                }
                            }
                            break block19;
                        }
                        if (actualType != Byte.class) break block22;
                        int i = 0;
                        while (i < size) {
                            collection.add(cb.readByte());
                            ++i;
                        }
                        break block19;
                    }
                    if (actualType != Short.class) break block23;
                    if (unsigned) {
                        int i = 0;
                        while (i < size) {
                            collection.add(cb.readUnsignedByte());
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < size) {
                            collection.add(cb.readShort());
                            ++i;
                        }
                    }
                    break block19;
                }
                if (!(actualType instanceof Class)) break block24;
                Class realClass = (Class)actualType;
                if (!XLMessageStruct.class.isAssignableFrom(realClass)) break block19;
                int i = 0;
                while (i < size) {
                    XLMessageStruct st = XLDecoderHelper.readStruct0(cb, realClass, config);
                    collection.add(st);
                    ++i;
                }
                break block19;
            }
            if (actualType instanceof ParameterizedTypeImpl) {
                ParameterizedTypeImpl pt = (ParameterizedTypeImpl)actualType;
                Type rawType0 = pt.getRawType();
                Type actualType0 = pt.getActualTypeArguments()[0];
                if (Collection.class.isAssignableFrom((Class<?>)rawType0)) {
                    int i = 0;
                    while (i < size) {
                        collection.add(XLDecoderHelper.readArray0(rawType0, actualType0, cb, unsigned, config));
                        ++i;
                    }
                }
            }
        }
        return collection;
    }

    public static String readString(ChannelBuffer cb, XLStandardCodecConfig config) {
        int flag = 4;
        XLDecoderHelper.checkReadableBytes(cb, flag);
        int len = cb.getInt(cb.readerIndex());
        XLDecoderHelper.checkReadableBytes(cb, len + flag);
        cb.skipBytes(flag);
        byte[] arr = new byte[len];
        cb.readBytes(arr);
        return new String(arr, config.getStringCharset());
    }

    public static String readString0(ChannelBuffer cb, XLStandardCodecConfig config) {
        int len = cb.readInt();
        byte[] arr = new byte[len];
        cb.readBytes(arr);
        return new String(arr, config.getStringCharset());
    }

    public static XLMessageStruct readStruct(ChannelBuffer cb, Class<?> type, XLStandardCodecConfig config) throws Exception {
        ChannelBuffer buf = cb;
        if (!config.isLixianCodec()) {
            int flag = 4;
            XLDecoderHelper.checkReadableBytes(cb, flag);
            int len = cb.getInt(cb.readerIndex());
            XLDecoderHelper.checkReadableBytes(cb, len + flag);
            cb.skipBytes(flag);
            buf = XLDecoderHelper.readBytes(cb, len);
        }
        Object struct = type.newInstance();
        Field[] fieldArray = type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f0 = fieldArray[n2];
            XLDecoderHelper.setValueIncludeArray(f0, struct, buf, config);
            ++n2;
        }
        return (XLMessageStruct)struct;
    }

    public static XLMessageStruct readStruct0(ChannelBuffer cb, Class<?> type, XLStandardCodecConfig config) throws Exception {
        ChannelBuffer buf = cb;
        if (!config.isLixianCodec()) {
            int len = cb.readInt();
            buf = cb.readBytes(len);
        }
        Object struct = type.newInstance();
        Field[] fieldArray = type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f0 = fieldArray[n2];
            XLDecoderHelper.setValueIncludeArray(f0, struct, buf, config);
            ++n2;
        }
        return (XLMessageStruct)struct;
    }

    private static void setFieldValue(Field field, Object bean, Object setRealValue) throws Exception {
        boolean setField = false;
        try {
            Method setter = ReflectConvention.buildSetterMethod(bean.getClass(), field, field.getType());
            if (setter == null) {
                setField = true;
            } else {
                setter.invoke(bean, setRealValue);
            }
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            setField = true;
        }
        if (setField) {
            ReflectionUtils.setField(field, bean, setRealValue);
        }
    }

    public static void setValue(Field f, Object obj, ChannelBuffer cb, XLStandardCodecConfig config) throws Exception {
        f.setAccessible(true);
        Class<?> type = f.getType();
        if (type == String.class) {
            XLDecoderHelper.setFieldValue(f, obj, XLDecoderHelper.readString(cb, config));
        } else if (type == Integer.TYPE || type == Integer.class) {
            if (f.getAnnotation(Unsigned.class) == null) {
                XLDecoderHelper.setFieldValue(f, obj, XLDecoderHelper.readInt(cb));
            } else {
                XLDecoderHelper.setFieldValue(f, obj, XLDecoderHelper.readUnsignedShort(cb));
            }
        } else if (type == Long.TYPE || type == Long.class) {
            if (f.getAnnotation(Unsigned.class) == null) {
                XLDecoderHelper.setFieldValue(f, obj, XLDecoderHelper.readLong(cb));
            } else {
                XLDecoderHelper.setFieldValue(f, obj, XLDecoderHelper.readUnsignedInt(cb));
            }
        } else if (type == Short.TYPE || type == Short.class) {
            if (f.getAnnotation(Unsigned.class) == null) {
                XLDecoderHelper.setFieldValue(f, obj, XLDecoderHelper.readShort(cb));
            } else {
                XLDecoderHelper.setFieldValue(f, obj, XLDecoderHelper.readUnsignedByte(cb));
            }
        } else if (type == Byte.TYPE || type == Byte.class) {
            XLDecoderHelper.setFieldValue(f, obj, XLDecoderHelper.readByte(cb));
        } else if (XLMessageStruct.class.isAssignableFrom(type)) {
            XLDecoderHelper.setFieldValue(f, obj, XLDecoderHelper.readStruct(cb, type, config));
        }
    }

    public static void setValueIncludeArray(Field f, Object obj, ChannelBuffer cb, XLStandardCodecConfig config) throws Exception {
        Class<?> rawType = f.getType();
        if (Collection.class.isAssignableFrom(rawType)) {
            f.setAccessible(true);
            boolean unsigned = f.getAnnotation(Unsigned.class) != null;
            XLDecoderHelper.setFieldValue(f, obj, XLDecoderHelper.readArray0(rawType, XLDecoderHelper.getActualType(f), cb, unsigned, config));
        } else {
            XLDecoderHelper.setValue(f, obj, cb, config);
        }
    }

    public static int decodeHeader(int state, Field[] fields, XLMessageHeader mh, ChannelBuffer cb, XLStandardCodecConfig config) throws Exception {
        while (state < fields.length) {
            Field f = fields[state];
            HeaderContentSplit hcs = f.getAnnotation(HeaderContentSplit.class);
            if (hcs != null) break;
            XLDecoderHelper.setValue(f, mh, cb, config);
            ++state;
        }
        return state;
    }

    public static int getContentLength(XLMessageHeader mh, XLStandardCodecConfig config) throws Exception {
        int contentLen = mh.getMessageLength() - config.getCommondHeaderLength();
        if (contentLen < 0) {
            throw new IllegalStateException("XLMessageHeader decode fail! messageLen:" + contentLen);
        }
        return contentLen;
    }

    public static ChannelBuffer decodeContentByAes(XLMessageHeader mh, ChannelBuffer content, XLStandardCodecConfig config) throws Exception {
        byte[] aesSecretKey = mh.getAesSecretKey();
        byte[] encodeContent = null;
        byte[] oriContent = null;
        if (EmptyChecker.isNotEmpty(aesSecretKey)) {
            encodeContent = content.array();
            oriContent = AESCryptUtil.aesDecode(aesSecretKey, encodeContent);
            content = ChannelBuffers.copiedBuffer(config.getEndian(), oriContent);
        }
        return content;
    }

    public static XLMessage decodeContent(int state, Field[] fields, XLMessageHeader mh, ChannelBuffer content, XLStandardCodecConfig config) throws Exception {
        while (state < fields.length) {
            Field f = fields[state];
            XLDecoderHelper.setValue(f, mh, content, config);
            ++state;
        }
        try {
            XLMessage m = mh.getDecodeMessage();
            m.setXlMessageHeader(mh);
            Field[] fieldArray = m.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                XLDecoderHelper.setValueIncludeArray(f, m, content, config);
                ++n2;
            }
            return m;
        }
        catch (Throwable e) {
            throw new IllegalStateException("XLMessage decode fail!", e);
        }
    }
}

