/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy.socket.std;

import org.jboss.netty.buffer.ChannelBuffer;

public class NumberUtils {
    public static String getBinary(long num) {
        long base = Long.MIN_VALUE;
        StringBuilder sb = new StringBuilder();
        do {
            if ((num & base) != 0L) {
                sb.append("1");
                continue;
            }
            sb.append("0");
        } while ((base >>>= 1) != 0L);
        return sb.toString();
    }

    public static String getBinary(int num) {
        int base = Integer.MIN_VALUE;
        StringBuilder sb = new StringBuilder();
        do {
            if ((num & base) != 0) {
                sb.append("1");
                continue;
            }
            sb.append("0");
        } while ((base >>>= 1) != 0);
        return sb.toString();
    }

    public static String getBinary(short num) {
        int base = 32768;
        StringBuilder sb = new StringBuilder();
        do {
            if ((num & base) != 0) {
                sb.append("1");
                continue;
            }
            sb.append("0");
        } while ((base >>>= 1) != 0);
        return sb.toString();
    }

    public static String getBinary(byte num) {
        int base = 128;
        StringBuilder sb = new StringBuilder();
        do {
            if ((num & base) != 0) {
                sb.append("1");
                continue;
            }
            sb.append("0");
        } while ((base >>>= 1) != 0);
        return sb.toString();
    }

    public static byte toUnsignedByte(short num) {
        int base = -256;
        if ((num & base) != 0) {
            throw new IllegalArgumentException("input number out of range");
        }
        return (byte)num;
    }

    public static short toUnsignedShort(int num) throws IllegalArgumentException {
        int base = -65536;
        if ((num & base) != 0) {
            throw new IllegalArgumentException("input number out of range");
        }
        return (short)num;
    }

    public static int toUnsignedInt(long num) {
        long base = -4294967296L;
        if ((num & base) != 0L) {
            throw new IllegalArgumentException("input number out of range");
        }
        return (int)num;
    }

    public static short fromUnsignedByte(byte unsignedNum) {
        return (short)(unsignedNum & 0xFF);
    }

    public static int fromUnsignedShort(short unsignedNum) {
        return unsignedNum & 0xFFFF;
    }

    public static long fromUnsignedInt(int unsignedNum) {
        return (long)unsignedNum & 0xFFFFFFFFL;
    }

    public static Number reverseBytes(Number num) throws IllegalArgumentException {
        if (num instanceof Short) {
            return Short.reverseBytes((Short)num);
        }
        if (num instanceof Integer) {
            return Integer.reverseBytes((Integer)num);
        }
        if (num instanceof Long) {
            return Long.reverseBytes((Long)num);
        }
        throw new IllegalArgumentException("Argument should be short/int/long");
    }

    public static short reverseBytes(short num) {
        return Short.reverseBytes(num);
    }

    public static int reverseBytes(int num) {
        return Integer.reverseBytes(num);
    }

    public static int reverse(int num) {
        return Integer.reverse(num);
    }

    public static long reverseBytes(long num) {
        return Long.reverseBytes(num);
    }

    public static long reverse(long num) {
        return Long.reverse(num);
    }

    public static void writeUnsignedInt(ChannelBuffer channelBuffer, long num) {
        channelBuffer.writeInt(NumberUtils.toUnsignedInt(num));
    }

    public static void writeUnsignedShort(ChannelBuffer channelBuffer, int num) {
        channelBuffer.writeShort(NumberUtils.toUnsignedShort(num));
    }

    public static void writeUnsignedByte(ChannelBuffer channelBuffer, short num) {
        channelBuffer.writeByte(NumberUtils.toUnsignedByte(num));
    }
}

