/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy.http;

import com.xunlei.proxy.HttpClientUtil;
import com.xunlei.spring.Config;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import com.xunlei.util.ValueUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VipProxy {
    private static final Logger log = Log.getLogger();
    @Config(value="vip.host")
    private String host;
    @Autowired
    private HttpClient httpClient;
    @Config(value="vip.port")
    private int port;
    @Config(value="vipextra.host")
    private String vipextraHost;
    @Config(value="vipextra.port")
    private int vipextraPort;
    public static final String EVER_VIP = "ret=0";
    public static final String NEVER_VIP = "ret=404";

    @Deprecated
    public Collection<VipInfo> getUserVas(Map<String, Byte> userMap) {
        String result = this.getUserVasToString(userMap);
        if (result == null) {
            return Collections.emptyList();
        }
        if (result.contains(EVER_VIP)) {
            ArrayList<VipInfo> list = new ArrayList<VipInfo>();
            String key = "user_vas=";
            int b = result.indexOf(key);
            if (b > -1) {
                String[] rrr = result.substring(b + key.length()).split("\\|");
                int i = 0;
                while (i < rrr.length) {
                    if (!rrr[i].isEmpty()) {
                        VipInfo info = new VipInfo(rrr[i]);
                        list.add(info);
                    }
                    ++i;
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    public VipInfo getUserVas(String user, byte type) {
        String key;
        int b;
        String result = this.getUserVasToString(user, type);
        if (result == null) {
            return new VipInfo();
        }
        if (result.contains(EVER_VIP) && (b = result.indexOf(key = "user_vas=")) > -1) {
            VipInfo info = new VipInfo(result.substring(b + key.length()));
            return info;
        }
        return new VipInfo();
    }

    @Deprecated
    public String getUserVasToString(Map<String, Byte> userMap) {
        URI uri = null;
        HttpRequestBase httpget = null;
        StringBuilder sb = new StringBuilder("vip_get_user_vas=");
        for (Map.Entry<String, Byte> e : userMap.entrySet()) {
            sb.append(e.getKey()).append(':').append(e.getValue()).append(",");
        }
        try {
            uri = URIUtils.createURI("http", this.host, this.port, "/vip", sb.toString(), null);
            log.debug("httpget url:{}", uri);
            httpget = new HttpGet(uri);
            HttpResponse response = this.httpClient.execute(httpget);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString(entity, "utf-8");
            log.debug("{}", (Object)result);
            String string = result;
            return string;
        }
        catch (Exception e) {
            log.error("httpget -ERROR- " + uri, e);
        }
        finally {
            httpget.abort();
        }
        return null;
    }

    public String getUserVasToString(String user, byte type) {
        URI uri = null;
        HttpRequestBase httpget = null;
        try {
            uri = URIUtils.createURI("http", this.host, this.port, "/vip", "vip_get_user_vas=" + user + ":" + type, null);
            log.debug("httpget url:{}", uri);
            httpget = new HttpGet(uri);
            HttpResponse response = this.httpClient.execute(httpget);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString(entity, "utf-8");
            log.debug("{}", (Object)result);
            String string = result;
            return string;
        }
        catch (Exception e) {
            log.error("httpget -ERROR- " + uri, e);
        }
        finally {
            httpget.abort();
        }
        return null;
    }

    public VipState getVipState(long userId) {
        URI uri = null;
        HttpRequestBase httpget = null;
        try {
            uri = URIUtils.createURI("http", this.host, this.port, "/cache", "userid=" + userId, null);
            log.debug("httpget url:{}", uri);
            httpget = new HttpGet(uri);
            HttpResponse response = this.httpClient.execute(httpget);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString(entity, "utf-8").trim();
            log.debug("{}", (Object)result);
            VipState vipState = new VipState(result);
            return vipState;
        }
        catch (Exception e) {
            log.error("httpget -ERROR- " + uri, e);
        }
        finally {
            httpget.abort();
        }
        return new VipState(null);
    }

    public boolean used2be(long userId) {
        URI uri = null;
        try {
            uri = URIUtils.createURI("http", this.vipextraHost, this.vipextraPort, "", "cmd=used2be&userid=" + userId, null);
            String result = HttpClientUtil.httpGet(uri.toString());
            return EVER_VIP.equals(result);
        }
        catch (Exception e) {
            log.error("httpget -ERROR- " + uri, e);
            return false;
        }
    }

    public class VipInfo {
        private boolean autopay;
        private int expiredate = 19000000;
        private int growvalue;
        private boolean isvip = false;
        private int paytype;
        private String retbody;
        private long userid;
        private boolean vip_404 = true;

        public VipInfo() {
        }

        public VipInfo(String retbody) {
            this.vip_404 = false;
            this.retbody = retbody;
            if (retbody != null) {
                retbody = retbody.trim();
                String[] arr = retbody.split(",");
                try {
                    this.userid = Long.valueOf(arr[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.isvip = !"0".equals(arr[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.growvalue = Integer.valueOf(arr[2]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.paytype = Integer.valueOf(arr[3]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.expiredate = Integer.valueOf(arr[4]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.autopay = !"0".equals(arr[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public int getExpiredate() {
            return this.expiredate;
        }

        public int getGrowvalue() {
            return this.growvalue;
        }

        public int getPaytype() {
            return this.paytype;
        }

        public String getRetbody() {
            return this.retbody;
        }

        public long getUserid() {
            return this.userid;
        }

        public boolean isAutopay() {
            return this.autopay;
        }

        public boolean isIsvip() {
            return this.isvip;
        }

        public boolean isOK() {
            return !this.vip_404;
        }

        public void setAutopay(boolean autopay) {
            this.autopay = autopay;
        }

        public void setExpiredate(int expiredate) {
            this.expiredate = expiredate;
        }

        public void setGrowvalue(int growvalue) {
            this.growvalue = growvalue;
        }

        public void setIsvip(boolean isvip) {
            this.isvip = isvip;
        }

        public void setPaytype(int paytype) {
            this.paytype = paytype;
        }

        public void setRetbody(String retbody) {
            this.retbody = retbody;
        }

        public void setUserid(long userid) {
            this.userid = userid;
        }

        public void setVip_404(boolean vip_404) {
            this.vip_404 = vip_404;
        }

        public String toString() {
            return "VipInfo [userid=" + this.userid + ", isvip=" + this.isvip + ", autopay=" + this.autopay + ", paytype=" + this.paytype + ", expiredate=" + this.expiredate + ", growvalue=" + this.growvalue + ", vip_404=" + this.vip_404 + ", retbody=" + this.retbody + "]";
        }
    }

    public class VipState {
        private byte autodeduct = (byte)-1;
        private int daily = -1;
        private long expire = -1L;
        private int grow = -1;
        private byte isvip = (byte)-1;
        private int level = -1;
        private int payid = -1;
        private String payname;
        private byte remind = (byte)-1;
        private int ret = Integer.MIN_VALUE;
        private long userid = -1L;
        private int uservas = -1;
        private int viplevel = 0;
        private byte isyear = (byte)-1;
        private long month_expire = -1L;

        public VipState(String retbody) {
            if (StringTools.isNotEmpty(retbody)) {
                HashMap<String, String> map = new HashMap<String, String>(12);
                for (String v : StringTools.splitAndTrim(retbody, "&")) {
                    int index = v.indexOf(61);
                    if (index <= 0) continue;
                    String key = v.substring(0, index);
                    String value = v.substring(index + 1);
                    map.put(key, value);
                }
                this.ret = ValueUtil.getInteger((String)map.get("ret"), Integer.MIN_VALUE);
                this.userid = ValueUtil.getInteger((String)map.get("userid"), -1);
                this.isvip = ValueUtil.getByte((String)map.get("isvip"), (byte)-1);
                this.uservas = ValueUtil.getInteger((String)map.get("uservas"), -1);
                this.level = ValueUtil.getInteger((String)map.get("level"), -1);
                this.grow = ValueUtil.getInteger((String)map.get("grow"), -1);
                this.payid = ValueUtil.getInteger((String)map.get("payid"), -1);
                this.payname = (String)map.get("payname");
                this.daily = ValueUtil.getInteger((String)map.get("daily"), -1);
                this.expire = ValueUtil.getLong((String)map.get("expire"), -1L);
                this.autodeduct = ValueUtil.getByte((String)map.get("autodeduct"), (byte)-1);
                this.remind = ValueUtil.getByte((String)map.get("remind"), (byte)-1);
                this.isyear = ValueUtil.getByte((String)map.get("isyear"), (byte)-1);
                this.month_expire = ValueUtil.getLong((String)map.get("month_expire"), -1L);
                this.viplevel = this.isvip > 0 ? (this.payid > 1000 && this.level == 0 ? 1 : this.level) : 0;
            }
        }

        public boolean isVip() {
            return this.isvip > 0;
        }

        public boolean isVipTrial() {
            return this.isvip > 0 && this.payid > 1000;
        }

        public boolean isVipMobile() {
            return this.isvip > 0 && this.payid == 3;
        }

        public boolean isVipYear() {
            return this.isvip > 0 && (this.payid == 5 || this.payid == 105);
        }

        public byte getAutodeduct() {
            return this.autodeduct;
        }

        public int getDaily() {
            return this.daily;
        }

        public long getExpire() {
            return this.expire;
        }

        public int getGrow() {
            return this.grow;
        }

        public byte getIsvip() {
            return this.isvip;
        }

        public int getLevel() {
            return this.level;
        }

        public int getPayid() {
            return this.payid;
        }

        public String getPayname() {
            return this.payname;
        }

        public byte getRemind() {
            return this.remind;
        }

        public int getRet() {
            return this.ret;
        }

        public long getUserid() {
            return this.userid;
        }

        public int getUservas() {
            return this.uservas;
        }

        public int getViplevel() {
            return this.viplevel;
        }

        @Deprecated
        public byte getIsyear() {
            return this.isyear;
        }

        public long getMonth_expire() {
            return this.month_expire;
        }

        public String toString() {
            return "VipState [autodeduct=" + this.autodeduct + ", daily=" + this.daily + ", expire=" + this.expire + ", grow=" + this.grow + ", isvip=" + this.isvip + ", level=" + this.level + ", payid=" + this.payid + ", payname=" + this.payname + ", remind=" + this.remind + ", ret=" + this.ret + ", userid=" + this.userid + ", uservas=" + this.uservas + ", viplevel=" + this.viplevel + ", isyear=" + this.isyear + ", month_expire=" + this.month_expire + "]";
        }
    }
}

