/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy.http;

import com.xunlei.proxy.HttpClientUtil;
import com.xunlei.spring.Config;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import com.xunlei.util.XmlUtil;
import java.net.URI;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.utils.URIUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MessageProxy {
    private static final Logger log = Log.getLogger();
    @Config(value="product_id")
    private int send_sid;
    @Config(value="product_id")
    private int recv_sid;
    public static final int SYSTYPE_INTERNALMAIL = 1;
    public static final int SYSTYPE_WEBINFORM = 101;
    public static final int SYSTYPE_CLIENT_FRIEND = 102;
    public static final int SYSTYPE_PERSONNAL_DYNAMIC = 201;
    public static final int SYSTYPE_FRIEND_DYNAMIC = 202;
    public static final int SYSTYPE_CLIENT_MSGBOX = 301;
    @Config(value="message.host")
    private String host;
    private int port;

    public boolean sysSendMsg2User(long recv_user, String title, String content, int sys_type) {
        String result;
        URI uri;
        block3: {
            int recv_user_type = 2;
            StringBuilder params = new StringBuilder().append("recv_user=").append(recv_user).append(':').append(recv_user_type).append("&send_sid=").append(this.send_sid).append("&recv_sid=").append(this.recv_sid).append("&title=").append(URLEncoder.encode(title.toString(), "UTF-8")).append("&content=").append(URLEncoder.encode(content.toString(), "UTF-8")).append("&sys_type=").append(sys_type);
            String p = params.toString();
            uri = URIUtils.createURI("http", this.host, this.port, "/send_sys_msg", p, null);
            result = HttpClientUtil.httpGet(uri.toString());
            if (!result.contains("result='0'")) break block3;
            log.debug("httpget ok url:{}", uri);
            return true;
        }
        try {
            log.error("httpget fail url:{}\tresult:{}", uri, (Object)result);
        }
        catch (Exception e) {
            log.error("", e);
        }
        return false;
    }

    public String sysSendDynamicMsg(long recv_user, String content) {
        int recv_user_type = 2;
        int sys_type = 201;
        try {
            StringBuilder params = new StringBuilder().append("recv_user=").append(recv_user).append(':').append(recv_user_type).append("&send_sid=").append(this.send_sid).append("&recv_sid=").append(this.recv_sid).append("&content=").append(URLEncoder.encode(content, "UTF-8")).append("&sys_type=").append(sys_type);
            String p = params.toString();
            URI uri = URIUtils.createURI("http", this.host, this.port, "/send_sys_msg", p, null);
            String result = HttpClientUtil.httpGet(uri.toString());
            log.debug("httpget ok url:{}", uri);
            if (StringTools.isEmpty(result)) {
                Element root = XmlUtil.getRootNode(result);
                return "result : " + root.attributeValue("result") + ",msg " + root.attributeValue("msg");
            }
        }
        catch (Exception e) {
            log.error("", e);
        }
        return null;
    }

    public String getDynamicMsg(long userId) {
        int sys_type = 201;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("sys_type=").append(sys_type);
            sb.append("&userid=").append(userId);
            sb.append("&recv_sid=").append(this.recv_sid);
            sb.append("&start=0").append("&row=10").append("&charset=utf-8");
            URI uri = URIUtils.createURI("http", this.host, this.port, "/get_dynamic_msg", sb.toString(), null);
            String result = HttpClientUtil.httpGet(uri.toString());
            if (result.contains("result='0'")) {
                log.debug("httpget ok url:{} result:{}", uri, (Object)result);
            } else {
                log.error("httpget fail url:{} result:{}", uri, (Object)result);
            }
            return result;
        }
        catch (Exception e) {
            log.error("", e);
            return null;
        }
    }

    public List<DynamicMsg> getDynamicVo(long userId, int nums) {
        String xmlResult = this.getDynamicMsg(userId);
        Element root = XmlUtil.getRootNode(xmlResult);
        ArrayList<DynamicMsg> list = new ArrayList<DynamicMsg>();
        if ("0".equals(root.attribute("result").getText())) {
            int dynCount = Integer.parseInt(root.attribute("count").getText());
            nums = dynCount >= 5 ? 5 : (nums == 1 && dynCount > 0 && dynCount < 5 ? 1 : (nums != 1 && dynCount > 0 && dynCount < 5 ? dynCount : 0));
            if (root != null) {
                List<Element> elements = XmlUtil.parseXml(root, "imsg");
                DynamicMsg dynamicMsg = null;
                int i = 0;
                while (i < nums) {
                    dynamicMsg = new DynamicMsg();
                    dynamicMsg.setContent(XmlUtil.xmlGetValue(elements.get(i), "content"));
                    dynamicMsg.setDate(MessageProxy.formatStringDate(XmlUtil.xmlGetValue(elements.get(i), "create_time")));
                    list.add(dynamicMsg);
                    ++i;
                }
            }
        }
        return list;
    }

    public static long formatStringDate(String date) {
        SimpleDateFormat sp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sp.parse(date).getTime() / 1000L;
        }
        catch (ParseException e) {
            log.error("", e);
            return 0L;
        }
    }

    public class DynamicMsg {
        private String content;
        private long date;

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public long getDate() {
            return this.date;
        }

        public void setDate(long date) {
            this.date = date;
        }
    }
}

