/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy.http;

import com.xunlei.proxy.HttpClientUtil;
import com.xunlei.spring.Config;
import com.xunlei.util.Log;
import com.xunlei.util.XmlUtil;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.client.utils.URIUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class AchievementProxy {
    private static final Logger log = Log.getLogger();
    @Config(value="achievement.host")
    private String host;

    public String query_user_achmToString(long uid, int status, int rows) {
        URI uri = null;
        try {
            uri = URIUtils.createURI("http", this.host, -1, "/query_user_achm", "status=" + status + "&rows=" + rows + "&&uid=" + uid, null);
            return HttpClientUtil.httpGet(uri.toString());
        }
        catch (Exception e) {
            log.error("", e);
            return null;
        }
    }

    public List<UserAchm> user_achm(long uid, int status, int rows) {
        String xmlResult = this.query_user_achmToString(uid, status, rows);
        ArrayList<UserAchm> list = null;
        Element root = XmlUtil.getRootNode(xmlResult);
        if (root != null) {
            list = new ArrayList<UserAchm>();
            UserAchm userAchm = null;
            List<Element> elements = XmlUtil.parseXml(root, "achm");
            for (Element e : elements) {
                long id = Long.valueOf(e.attribute("id").getText());
                byte state = Byte.valueOf(e.attribute("status").getText());
                String time = e.attribute("status").getText();
                userAchm = new UserAchm(id, state, time);
                list.add(userAchm);
            }
        }
        return list;
    }

    public String achmReportToString(long uid, int product_id, int achm_id, Date can_grant_time) {
        URI uri = null;
        String date = null;
        if (can_grant_time != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            date = format.format(can_grant_time);
        }
        try {
            StringBuilder query = new StringBuilder();
            query.append("product_id=").append(product_id).append("&achm_id=").append(achm_id).append("&uid=").append(uid);
            if (date != null) {
                query.append("&can_grant_time=").append(date);
            }
            uri = URIUtils.createURI("http", this.host, -1, "/achm_report", query.toString(), null);
            return HttpClientUtil.httpGet(uri.toString());
        }
        catch (Exception e) {
            log.error("", e);
            return null;
        }
    }

    public AchmReport achmReport(long uid, int product_id, int achm_id, Date can_grant_time) {
        String xmlResult = this.achmReportToString(uid, product_id, achm_id, can_grant_time);
        AchmReport report = null;
        if (xmlResult != null && xmlResult.contains("result='0'")) {
            Element root = XmlUtil.getRootNode(xmlResult);
            if (root == null) {
                return null;
            }
            report = new AchmReport(Byte.valueOf(root.attributeValue("result")), root.attributeValue("msg"));
        }
        return report;
    }

    public class AchmReport {
        private byte result;
        private String msg;

        public AchmReport(byte result, String msg) {
            this.result = result;
            this.msg = msg;
        }

        public byte getResult() {
            return this.result;
        }

        public void setResult(byte result) {
            this.result = result;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String toString() {
            return "AchmReport[ result:" + this.result + " msg:" + this.msg + "]";
        }
    }

    public class UserAchm {
        private long id;
        private byte status;
        private String time;

        public UserAchm(long id, byte status, String time) {
            this.id = id;
            this.status = status;
            this.time = time;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public byte getStatus() {
            return this.status;
        }

        public void setStatus(byte status) {
            this.status = status;
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }
    }
}

