/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.jinzuan.task;

import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.niux.jinzuan.task.ConnUtil;
import com.xunlei.niux.jinzuan.task.TimeTaskLog;
import com.xunlei.niux.jinzuan.util.HttpClientUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import org.json.JSONObject;

public class ExpireRewardTask {
    private static String time = null;
    private static final String growkey = ResourceBundle.getBundle("conn").getString("growkey");
    private static final String dailyRewardUrl = ResourceBundle.getBundle("conn").getString("dailyRewardUrl");
    private static String type = "5";
    private static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    static {
        if (time == null) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            time = sdf.format(cal.getTime());
        }
    }

    public static void main(String[] args) {
        System.out.println("========ExpireRewardTask start=========");
        ExpireRewardTask.task();
        System.out.println("========ExpireRewardTask end=========");
    }

    public static void task() {
        Connection conn = null;
        Connection sconn = null;
        Statement stmt = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String uid = null;
        String startTime = format.format(new Date());
        long timestamp = System.currentTimeMillis() / 1000L;
        try {
            try {
                conn = ConnUtil.getConn();
                sconn = ConnUtil.getConn();
                stmt = conn.createStatement();
                String param = String.valueOf(type) + timestamp + growkey;
                String querysql = "SELECT userid FROM jinzuan_membership WHERE  growthValue>0 and  memberExpireDate <= DATE_SUB(CURDATE(),INTERVAL 1 DAY)";
                String insertsql = "insert into jinzuan_privilegefailureuser values(null,?,'5',?,'0',?,?)";
                pstmt = sconn.prepareStatement(insertsql);
                rs = stmt.executeQuery(querysql);
                int index = 1;
                while (rs.next()) {
                    uid = rs.getString(1);
                    try {
                        String url = ExpireRewardTask.getUrl(uid, timestamp, param);
                        System.out.println("ExpireRewardTask index=" + index + ",daytime=" + time + ",uid=" + uid + ",url=" + url);
                        String responseText = HttpClientUtil.get(url);
                        JSONObject data = new JSONObject(responseText);
                        int rtn = data.getInt("rtn");
                        System.out.println("ExpireRewardTask index=" + index + ",daytime=" + time + ",uid=" + uid + ",rtn=" + rtn);
                        if (rtn != 0) {
                            pstmt.setString(1, uid);
                            pstmt.setString(2, time);
                            pstmt.setString(3, "");
                            pstmt.setInt(4, rtn);
                            pstmt.execute();
                        }
                    }
                    catch (Exception e) {
                        pstmt.setString(1, uid);
                        pstmt.setString(2, time);
                        pstmt.setString(3, "");
                        pstmt.setInt(4, 6);
                        pstmt.execute();
                    }
                    ++index;
                }
                String endTime = format.format(new Date());
                timestamp = System.currentTimeMillis() / 1000L - timestamp;
                TimeTaskLog.getInstance().addLog(startTime, endTime, timestamp, "001", "\u672a\u7eed\u8d39\u51cf\u5c11\u6210\u957f\u503c", 1, "");
            }
            catch (Exception e) {
                String endTime = format.format(new Date());
                timestamp = System.currentTimeMillis() / 1000L - timestamp;
                TimeTaskLog.getInstance().addLog(startTime, endTime, timestamp, "001", "\u672a\u7eed\u8d39\u51cf\u5c11\u6210\u957f\u503c", 0, e.getMessage());
                System.out.println("ExpireRewardTask exception uid:" + uid + ",reason:" + e.getMessage());
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (sconn != null) {
                        sconn.close();
                        sconn = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (sconn != null) {
                    sconn.close();
                    sconn = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String getUrl(String uid, long timestamp, String param) {
        String msg = String.valueOf(uid) + param;
        String mysign = Md5Encrypt.md5(msg);
        StringBuffer sb = new StringBuffer("uid=");
        sb.append(uid).append("&timestamp=").append(timestamp).append("&sign=").append(mysign).append("&ptype=" + type);
        return String.valueOf(dailyRewardUrl) + sb;
    }
}

