/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.jinzuan.cmd.sign;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.BuQian;
import com.xunlei.niux.data.jinzuan.vo.CommonData;
import com.xunlei.niux.data.jinzuan.vo.GrowHistory;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeReceiveInfo;
import com.xunlei.niux.data.jinzuan.vo.SigninHistory;
import com.xunlei.niux.jinzuan.cache.BonusCache;
import com.xunlei.niux.jinzuan.cache.LevelCache;
import com.xunlei.niux.jinzuan.cmd.DefaultCmd;
import com.xunlei.niux.jinzuan.util.DateUtil;
import com.xunlei.niux.jinzuan.util.IpUtil;
import com.xunlei.niux.jinzuan.util.RBundleUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SignCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(SignCmd.class.getName());
    private static String sourceId = "00001";
    private static final String signkey = "6f5aadf0-8aa7-41bf-bcd1-74eab17dd9b5";
    private static String BUQIAN_KEY = RBundleUtil.getString("niux", "buQianKey");

    @CmdMapper(value={"/sign/buQianRecord.do"})
    public Object buQianRecord(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam param = this.checkMainParam(request, response, true);
            long userId = param.getUserid();
            BuQian query = new BuQian();
            query.setUserId(userId);
            Page page = new Page();
            page.addOrder("dayTime", OrderType.DESC);
            List<BuQian> buQianList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, buQianList);
        }
        catch (Exception e) {
            logger.error("buQianRecord.do error", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/sign/queryBuQianCount.do"})
    public Object queryBuQianCount(XLHttpRequest request, XLHttpResponse response) {
        try {
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            String myip = request.getRemoteIP();
            if (!IpUtil.getInstance().validateIp(myip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u65e0\u6548ip");
            }
            String uid = request.getParameter("uid");
            String timeStamp = request.getParameter("timeStamp");
            String sign = request.getParameter("sign");
            if (StringTools.isEmpty(uid) || StringTools.isEmpty(timeStamp) || StringTools.isEmpty(sign)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            long myTimeStamp = System.currentTimeMillis() / 1000L;
            try {
                if (myTimeStamp - Long.parseLong(timeStamp) >= 300L) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(6, "\u8be5\u8bf7\u6c42\u8d85\u65f6");
                }
            }
            catch (Exception e) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u53c2\u6570\u9519\u8bef");
            }
            String mySign = Md5Encrypt.md5(String.valueOf(uid) + timeStamp + BUQIAN_KEY);
            if (!mySign.trim().equals(sign.trim())) {
                return JsonObjectUtil.getRtnAndDataJsonObject(7, "\u7b7e\u540d\u9519\u8bef");
            }
            long userId = 0L;
            try {
                userId = Long.parseLong(uid);
            }
            catch (Exception e) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u53c2\u6570\u9519\u8bef");
            }
            PrivilegeReceiveInfo info = this.getPrivilegeReceiveInfo(userId);
            if (info == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u672c\u6708\u65e0\u8865\u7b7e\u7279\u6743");
            }
            HashMap<String, Long> result = new HashMap<String, Long>();
            result.put("totalValue", info.getTotalValue());
            result.put("availableValue", info.getAvailableValue());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    private PrivilegeReceiveInfo getPrivilegeReceiveInfo(long userId) {
        String month = SignCmd.now().substring(0, 7);
        PrivilegeReceiveInfo query = new PrivilegeReceiveInfo();
        query.setUserId(userId);
        query.setYearMonth(month);
        query.setPrivilegeType(6);
        PrivilegeReceiveInfo info = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        return info;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CmdMapper(value={"/sign/addBuQianRecord.do"})
    public Object addBuQianRecord(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String myip = request.getRemoteIP();
        if (!IpUtil.getInstance().validateIp(myip, 1)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u65e0\u6548ip");
        }
        String uid = request.getParameter("uid");
        String signWay = request.getParameter("signWay");
        String dayTime = request.getParameter("dayTime");
        String bonus = request.getParameter("bonus");
        String growValue = request.getParameter("growValue");
        String timeStamp = request.getParameter("timeStamp");
        String sign = request.getParameter("sign");
        if (StringTools.isEmpty(uid) || StringTools.isEmpty(signWay) || StringTools.isEmpty(dayTime) || StringTools.isEmpty(bonus) || StringTools.isEmpty(growValue) || StringTools.isEmpty(timeStamp) || StringTools.isEmpty(sign)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            PrivilegeReceiveInfo info = this.getPrivilegeReceiveInfo(Long.parseLong(uid));
            if (info == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u672c\u6708\u65e0\u8865\u7b7e\u7279\u6743");
            }
            long myTimeStamp = System.currentTimeMillis() / 1000L;
            if (myTimeStamp - Long.parseLong(timeStamp) >= 300L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(6, "\u8be5\u8bf7\u6c42\u8d85\u65f6");
            }
            String mySign = Md5Encrypt.md5(String.valueOf(uid) + signWay + dayTime + bonus + growValue + timeStamp + BUQIAN_KEY);
            if (!mySign.trim().equals(sign.trim())) {
                return JsonObjectUtil.getRtnAndDataJsonObject(7, "\u7b7e\u540d\u9519\u8bef");
            }
            BuQian buQian = new BuQian();
            buQian.setUserId(Long.parseLong(uid.trim()));
            buQian.setBonus(Integer.parseInt(bonus.trim()));
            buQian.setGrowValue(Integer.parseInt(growValue.trim()));
            buQian.setDayTime(dayTime.trim());
            buQian.setSignTime(SignCmd.now());
            buQian.setSignWay(Integer.parseInt(signWay.trim()));
            try {
                FacadeFactory.INSTANCE.getBaseSo().addObject(buQian);
                return JsonObjectUtil.getOnlyOkJson();
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonObjectUtil.getRtnAndDataJsonObject(8, "\u8be5\u8bb0\u5f55\u5df2\u5b58\u5728");
            }
        }
        catch (Exception e) {
            try {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u53c2\u6570\u9519\u8bef");
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u7f51\u7edc\u5f02\u5e38");
            }
        }
    }

    @Deprecated
    @CmdMapper(value={"/sign/updatesigncount.do"})
    public Object updateCount(XLHttpRequest request, XLHttpResponse response) {
        SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String myip = request.getRemoteIP();
            if (!IpUtil.getInstance().validateIp(myip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u65e0\u6548ip");
            }
            CacheManager cacheManager = CacheManager.GetInstance();
            String cacheKey = cacheManager.generateCacheKey(SignCmd.class, "jinzuan_sign_count");
            SigninHistory queryhistory = new SigninHistory();
            queryhistory.setDayTime(Daysdf.format(new Date()));
            int count = FacadeFactory.INSTANCE.getBaseSo().countObject(queryhistory);
            cacheManager.put(cacheKey, count, 10L);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, count);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u67e5\u8be2\u5931\u8d25");
        }
    }

    @CmdMapper(value={"/sign/getSignCount.do"})
    public Object getSignCountLive(XLHttpRequest request, XLHttpResponse response) {
        try {
            CommonData query = new CommonData();
            query.setSeqId(1L);
            CommonData commonData = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, commonData.getDataValue());
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u67e5\u8be2\u5931\u8d25");
        }
    }

    @Deprecated
    @CmdMapper(value={"/sign/getSignPeopleCount.do"})
    public Object getSignPeopleCount(XLHttpRequest request, XLHttpResponse response) {
        SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            CacheManager cacheManager = CacheManager.GetInstance();
            String cacheKey = cacheManager.generateCacheKey(SignCmd.class, "jinzuan_sign_count");
            Object cacheResult = cacheManager.get(cacheKey);
            int count = 0;
            if (cacheResult != null) {
                count = Integer.parseInt(cacheResult.toString());
                return JsonObjectUtil.getRtnAndDataJsonObject(0, count);
            }
            SigninHistory queryhistory = new SigninHistory();
            queryhistory.setDayTime(Daysdf.format(new Date()));
            count = FacadeFactory.INSTANCE.getBaseSo().countObject(queryhistory);
            cacheManager.put(cacheKey, count, 10L);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, count);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u67e5\u8be2\u5931\u8d25");
        }
    }

    private MemberShip getMemberShip(long userId) {
        MemberShip query = new MemberShip();
        query.setUserId(userId);
        MemberShip ship = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        return ship;
    }

    private SigninHistory getSignMap(long uid, Map<String, Object> result) {
        SigninHistory query = new SigninHistory();
        query.setUserId(uid);
        String dayTime = DateUtil.newDayTime();
        query.setDayTime(dayTime);
        SigninHistory history = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        String daytime = DateUtil.getNowDay();
        result.put("daytime", daytime);
        if (history == null) {
            result.put("isSign", 0);
        } else {
            result.put("isSign", 1);
            result.put("signIndex", history.getSignIndex());
            result.put("continueDays", history.getContinueDays());
            GrowHistory gquery = new GrowHistory();
            gquery.setDayTime(dayTime);
            gquery.setUserId(uid);
            gquery.setGrowType(new Integer(4));
            GrowHistory growhistory = FacadeFactory.INSTANCE.getBaseSo().findObject(gquery);
            if (growhistory == null) {
                result.put("growValue", 0);
            } else {
                result.put("growValue", growhistory.getGrowValue());
            }
        }
        return history;
    }

    @CmdMapper(value={"/sign/getSign.do"})
    public Object getSign(XLHttpRequest request, XLHttpResponse response) {
        try {
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            String userId = request.getParameter("uid");
            if (StringTools.isEmpty(userId)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u53c2\u6570\u4e3a\u7a7a");
            }
            long uid = Long.parseLong(userId);
            String myip = request.getRemoteIP();
            if (!IpUtil.getInstance().validateIp(myip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u65e0\u6548ip");
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            SigninHistory history = this.getSignMap(uid, result);
            MemberShip shipquery = new MemberShip();
            shipquery.setUserId(uid);
            MemberShip ship = FacadeFactory.INSTANCE.getBaseSo().findObject(shipquery);
            if (ship == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u8be5\u7528\u6237\u975e\u91d1\u94bb\u4f1a\u5458");
            }
            if (history == null) {
                result.put("bounsValue", 0);
            } else {
                result.put("bounsValue", history.getBonus() == null ? 0 : history.getBonus());
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u67e5\u8be2\u5931\u8d25");
        }
    }

    @CmdMapper(value={"/sign/getSignInfo.do"})
    public Object getSignInfo(XLHttpRequest request, XLHttpResponse response) {
        MainParam param = this.checkMainParam(request, response, true);
        long uid = param.getUserid();
        try {
            SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
            HashMap<String, Object> result = new HashMap<String, Object>();
            SigninHistory history = this.getSignMap(uid, result);
            Calendar cal = Calendar.getInstance();
            cal.add(2, -1);
            String beforetime = Daysdf.format(cal.getTime());
            String beforeMonth = beforetime.substring(0, 7);
            String month = DateUtil.getNowDay().substring(0, 7);
            beforetime = String.valueOf(beforeMonth) + "-01";
            MemberShip shipquery = new MemberShip();
            shipquery.setUserId(uid);
            MemberShip ship = FacadeFactory.INSTANCE.getBaseSo().findObject(shipquery);
            if (ship == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u8be5\u7528\u6237\u975e\u91d1\u94bb\u4f1a\u5458");
            }
            String sql = "select * from jinzuan_signinhistory where userid=" + uid + " and  daytime>='" + beforetime + "' and daytime<='" + DateUtil.getNowDay() + "'  order by daytime asc";
            List shlist = FacadeFactory.INSTANCE.getBaseSo().executeQuery(SigninHistory.class, sql, new ArrayList());
            ArrayList<Integer> beforeList = new ArrayList<Integer>();
            ArrayList<Integer> nowList = new ArrayList<Integer>();
            for (SigninHistory sh : shlist) {
                String mydaytime = sh.getDayTime();
                if (mydaytime.indexOf(beforeMonth) != -1) {
                    beforeList.add(this.getDays(mydaytime));
                    continue;
                }
                nowList.add(this.getDays(mydaytime));
            }
            if (history == null) {
                result.put("bounsValue", 0);
            } else {
                result.put("bounsValue", history.getBonus() == null ? 0 : history.getBonus());
            }
            TreeMap<String, ArrayList<Integer>> monthMap = new TreeMap<String, ArrayList<Integer>>();
            monthMap.put(this.formatMonth(beforeMonth), beforeList);
            monthMap.put(this.formatMonth(month), nowList);
            result.put("signHistory", monthMap);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u67e5\u8be2\u5931\u8d25");
        }
    }

    private int getDays(String daytime) {
        if ((daytime = daytime.substring(8)).charAt(0) == '\u0000') {
            daytime = daytime.substring(1);
        }
        return Integer.parseInt(daytime);
    }

    @CmdMapper(value={"/sign/issign.do"})
    public Object isSign(XLHttpRequest request, XLHttpResponse response) {
        String uid = request.getParameter("uid");
        String daytime = request.getParameter("daytime");
        String type = request.getParameter("type");
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String msg = "";
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String myip = request.getRemoteIP();
            if (!IpUtil.getInstance().validateIp(myip, 1)) {
                msg = "\u65e0\u6548ip";
                result.put("msg", msg);
                if (StringTools.isEmpty(type)) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(5, msg);
                }
                return JsonObjectUtil.getRtnAndDataJsonObject(5, result);
            }
            if (StringTools.isEmpty(uid)) {
                msg = "\u53c2\u6570\u4e3a\u7a7a";
                result.put("msg", msg);
                if (StringTools.isEmpty(type)) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(2, msg);
                }
                return JsonObjectUtil.getRtnAndDataJsonObject(2, result);
            }
            BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
            MemberShip queryship = new MemberShip();
            queryship.setUserId(Long.parseLong(uid));
            MemberShip ship = baseSo.findObject(queryship);
            if (ship == null) {
                msg = "\u8be5\u7528\u6237\u975e\u91d1\u94bb\u7528\u6237";
                result.put("msg", msg);
                if (StringTools.isEmpty(type)) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(3, msg);
                }
                return JsonObjectUtil.getRtnAndDataJsonObject(3, result);
            }
            SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
            SigninHistory historyquery = new SigninHistory();
            historyquery.setUserId(Long.parseLong(uid));
            if (StringTools.isEmpty(daytime)) {
                historyquery.setDayTime(Daysdf.format(new Date()));
            } else {
                historyquery.setDayTime(daytime);
            }
            int count = baseSo.countObject(historyquery);
            if (count <= 0) {
                msg = "\u4eca\u65e5\u672a\u7b7e\u5230";
                result.put("msg", msg);
                if (StringTools.isEmpty(type)) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(0, msg);
                }
                return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
            }
            msg = "\u4eca\u65e5\u5df2\u7b7e\u5230";
            result.put("msg", msg);
            if (StringTools.isEmpty(type)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, msg);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(1, result);
        }
        catch (Exception e) {
            msg = "\u7f51\u7edc\u5f02\u5e38";
            result.put("msg", msg);
            if (StringTools.isEmpty(type)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(4, msg);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(4, result);
        }
    }

    @CmdMapper(value={"/sign/signstatus.do"})
    public Object signStatus(XLHttpRequest request, XLHttpResponse response) {
        String uid = request.getParameter("uid");
        String daytime = request.getParameter("daytime");
        SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String msg = "";
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String myip = request.getRemoteIP();
            logger.info("/sign/signstatus.do  uid:" + uid + ",ip:" + myip);
            if (!IpUtil.getInstance().validateIp(myip, 1)) {
                msg = "\u65e0\u6548ip";
                result.put("msg", msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(5, result);
            }
            if (StringTools.isEmpty(uid)) {
                msg = "\u53c2\u6570\u4e3a\u7a7a";
                result.put("msg", msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(2, result);
            }
            BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
            MemberShip queryship = new MemberShip();
            queryship.setUserId(Long.parseLong(uid));
            MemberShip ship = baseSo.findObject(queryship);
            if (ship == null) {
                msg = "\u8be5\u7528\u6237\u975e\u91d1\u94bb\u7528\u6237";
                result.put("msg", msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(3, result);
            }
            SigninHistory historyquery = new SigninHistory();
            historyquery.setUserId(Long.parseLong(uid));
            if (StringTools.isEmpty(daytime)) {
                historyquery.setDayTime(Daysdf.format(new Date()));
            } else {
                historyquery.setDayTime(daytime);
            }
            int count = baseSo.countObject(historyquery);
            if (count <= 0) {
                msg = "\u4eca\u65e5\u672a\u7b7e\u5230";
                result.put("msg", msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(1, result);
            }
            msg = "\u4eca\u65e5\u5df2\u7b7e\u5230";
            result.put("msg", msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            msg = "\u7f51\u7edc\u5f02\u5e38";
            result.put("msg", msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(4, result);
        }
    }

    private String changeDay(String day) {
        int dayInt = Integer.parseInt(day);
        if (dayInt <= 9) {
            return "0" + day;
        }
        return day;
    }

    @CmdMapper(value={"/sign/dosign.do"})
    public Object doSign(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String uid = request.getParameter("uid");
        String ip = request.getParameter("ip");
        String day = request.getParameter("day");
        try {
            String experienceDate;
            long timestamp0;
            String timestamp = request.getParameter("timestamp");
            String sign = request.getParameter("sign");
            logger.info("jinzuan sign dosign.do uid=" + uid + ",clienip=" + ip + ",timestamp=" + timestamp + ",sign=" + sign);
            String myip = request.getRemoteIP();
            if (!IpUtil.getInstance().validateIp(myip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(10, "\u65e0\u6548ip");
            }
            if (StringTools.isEmpty(uid) || StringTools.isEmpty(ip) || StringTools.isEmpty(timestamp) || StringTools.isEmpty(sign)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            String md5msg = String.valueOf(uid) + timestamp + ip + signkey;
            String mysign = Md5Encrypt.md5(md5msg);
            if (!sign.trim().equals(mysign)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7b7e\u540d\u9519\u8bef");
            }
            long mytimestamp = System.currentTimeMillis() / 1000L;
            if (mytimestamp - (timestamp0 = Long.parseLong(timestamp)) >= 900L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u8bf7\u6c42\u8d85\u65f6");
            }
            MemberShip ship = this.getMemberShip(Long.parseLong(uid));
            if (ship == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(7, "\u60a8\u975e\u91d1\u94bb\u4f1a\u5458");
            }
            String nowDay = DateUtil.getNowDay();
            String month = nowDay.substring(0, 7);
            String time = "";
            time = StringTools.isEmpty(day) ? nowDay : String.valueOf(month) + "-" + this.changeDay(day);
            if (!DateUtil.compareTime(nowDay, time)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(11, "\u65e5\u671f\u4e0d\u5bf9");
            }
            SigninHistory historyQuery = new SigninHistory();
            historyQuery.setUserId(Long.parseLong(uid));
            historyQuery.setDayTime(time);
            SigninHistory history = FacadeFactory.INSTANCE.getBaseSo().findObject(historyQuery);
            if (history != null) {
                Map<String, Object> result = this.getSign(ship, Long.parseLong(uid));
                return JsonObjectUtil.getRtnAndDataJsonObject(6, result);
            }
            String memberEndTime = ship.getMemberExpireDate();
            if (!(DateUtil.compareTime(memberEndTime, nowDay) || !StringTools.isEmpty(experienceDate = ship.getExperienceDate()) && DateUtil.compareTime(experienceDate, nowDay))) {
                return JsonObjectUtil.getRtnAndDataJsonObject(8, "\u60a8\u7684\u91d1\u94bb\u4f1a\u5458\u7279\u6743\u5df2\u8fc7\u671f");
            }
            int levelNum = ship.getLevelNum();
            long growValue = 0L;
            switch (levelNum) {
                case 1: {
                    growValue = 1L;
                    break;
                }
                case 2: {
                    growValue = 1L;
                    break;
                }
                case 3: {
                    growValue = 2L;
                    break;
                }
                case 4: {
                    growValue = 2L;
                    break;
                }
                case 5: {
                    growValue = 3L;
                    break;
                }
                case 6: {
                    growValue = 3L;
                    break;
                }
                case 7: {
                    growValue = 4L;
                }
            }
            String endtime = ship.getAnnualMemberExpireDate();
            if (DateUtil.compareTime(endtime, nowDay)) {
                growValue += 3L;
            }
            GrowHistory gh = this.getGrowHistory(Long.parseLong(uid), sourceId, 4);
            gh.setGrowValue(growValue);
            FacadeFactory.INSTANCE.getGrowHistoryBo().signGrowHistory(gh, ship, ip, time);
            logger.info("jinzuan sign dosign.do success uid=" + uid + ",clienip=" + ip + ",timestamp=" + timestamp);
            Map<String, Object> result = this.getSign(ship, Long.parseLong(uid));
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (XLRuntimeException ee) {
            logger.info("jinzuan sign dosign.do error uid=" + uid + ",clienip=" + ip + ",reason=" + ee.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u672a\u77e5\u5f02\u5e38");
        }
        catch (Exception e) {
            logger.info("jinzuan sign dosign.do error uid=" + uid + ",clienip=" + ip + ",reason=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    public Map<String, Object> getSign(MemberShip ship, long uid) throws Exception {
        SigninHistory query = new SigninHistory();
        query.setUserId(uid);
        String nowDay = DateUtil.getNowDay();
        query.setDayTime(nowDay);
        SigninHistory history = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        HashMap<String, Object> result = new HashMap<String, Object>();
        SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
        result.put("daytime", nowDay);
        if (history == null) {
            result.put("isSign", 0);
        } else {
            result.put("isSign", 1);
            result.put("signIndex", history.getSignIndex());
            result.put("continueDays", history.getContinueDays());
            GrowHistory gquery = new GrowHistory();
            gquery.setDayTime(nowDay);
            gquery.setUserId(uid);
            gquery.setGrowType(new Integer(4));
            GrowHistory growhistory = FacadeFactory.INSTANCE.getBaseSo().findObject(gquery);
            if (growhistory == null) {
                result.put("growValue", 0);
            } else {
                result.put("growValue", growhistory.getGrowValue());
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        String beforetime = Daysdf.format(cal.getTime());
        String beforeMonth = beforetime.substring(0, 7);
        String month = nowDay.substring(0, 7);
        beforetime = String.valueOf(beforeMonth) + "-01";
        String sql = "select * from jinzuan_signinhistory where userid=" + uid + " and  daytime>='" + beforetime + "' and daytime<='" + nowDay + "'  order by daytime asc";
        List shlist = FacadeFactory.INSTANCE.getBaseSo().executeQuery(SigninHistory.class, sql, new ArrayList());
        ArrayList<Integer> beforeList = new ArrayList<Integer>();
        ArrayList<Integer> nowList = new ArrayList<Integer>();
        for (SigninHistory sh : shlist) {
            String mydaytime = sh.getDayTime();
            if (mydaytime.indexOf(beforeMonth) != -1) {
                beforeList.add(this.getDays(mydaytime));
                continue;
            }
            nowList.add(this.getDays(mydaytime));
        }
        result.put("bounsValue", history.getBonus() == null ? 0 : history.getBonus());
        TreeMap<String, ArrayList<Integer>> monthMap = new TreeMap<String, ArrayList<Integer>>();
        monthMap.put(this.formatMonth(beforeMonth), beforeList);
        monthMap.put(this.formatMonth(month), nowList);
        result.put("signHistory", monthMap);
        return result;
    }

    private String formatMonth(String month) {
        if (StringTools.isEmpty(month)) {
            return "";
        }
        String[] strs = month.split("-");
        return "y" + strs[0] + strs[1];
    }

    public Map<String, Object> getMember(MemberShip memberShip, String uid) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean ismember = SignCmd.isMember(memberShip, 1);
        boolean isyear = SignCmd.isMember(memberShip, 2);
        if (!ismember) {
            result.put("memberStatus", 3);
        } else {
            result.put("memberStatus", 2);
        }
        Map<Integer, Long> levelMap = LevelCache.getInstance().getLevelMap();
        long rightLevelGrowthValue = levelMap.get(memberShip.getLevelNum());
        result.put("levelGrowthValue", rightLevelGrowthValue);
        int maxlevel = levelMap.size();
        long nextLevelGrowthValue = 0L;
        nextLevelGrowthValue = maxlevel > memberShip.getLevelNum() ? levelMap.get(memberShip.getLevelNum() + 1).longValue() : levelMap.get(memberShip.getLevelNum()).longValue();
        result.put("nextLevelGrowthValue", nextLevelGrowthValue);
        result.put("isAnnualMember", isyear ? 1 : 0);
        result.put("userId", memberShip.getUserId());
        result.put("growthValue", memberShip.getGrowthValue());
        result.put("levelNum", memberShip.getLevelNum());
        result.put("registerTime", SignCmd.formatTime(memberShip.getRegisterTime()));
        result.put("lastFeeTime", SignCmd.formatTime(memberShip.getLastFeeTime()));
        result.put("annualMemberExpireDate", memberShip.getAnnualMemberExpireDate() == null ? "" : memberShip.getAnnualMemberExpireDate());
        result.put("memberExpireDate", memberShip.getMemberExpireDate() == null ? "" : memberShip.getMemberExpireDate());
        PrivilegeReceiveInfo info = new PrivilegeReceiveInfo();
        info.setUserId(Long.parseLong(uid));
        String daytime = DateUtil.getNowDay();
        info.setYearMonth(daytime.substring(0, 7));
        List<PrivilegeReceiveInfo> prilist = FacadeFactory.INSTANCE.getBaseSo().findObjects(info, new Page());
        HashMap<String, Object> data = new HashMap<String, Object>();
        Map<String, Long> map = BonusCache.getInstance().getBonusMap();
        boolean validFlag = DateUtil.compareTime(memberShip.getAnnualMemberExpireDate(), DateUtil.getNowDay());
        Long value = map.get(memberShip.getLevelNum() + "_" + (validFlag ? 1 : 0));
        result.put("bounsValue", value == null ? 0L : value);
        data.put("memberinfo", result);
        data.put("prilist", prilist);
        return data;
    }

    private static String formatTime(String time) {
        if (StringTools.isEmpty(time)) {
            return "";
        }
        if (time.indexOf(".") != -1 && "0000-00-00 00:00:00".equals(time = time.substring(0, time.indexOf(".")))) {
            return "";
        }
        return time;
    }

    public static boolean isMember(MemberShip memberShip, int vtype) throws Exception {
        if (memberShip == null) {
            throw new XLRuntimeException("\u8be5\u7528\u6237\u975e\u91d1\u94bb\u7528\u6237");
        }
        boolean validFlag = false;
        String nowday = SignCmd.now().split(" ")[0];
        switch (vtype) {
            case 1: {
                String memberExpireDate = memberShip.getMemberExpireDate();
                validFlag = DateUtil.compareTime(memberExpireDate, nowday);
                break;
            }
            case 2: {
                String annualMemberExpireDate = memberShip.getAnnualMemberExpireDate();
                validFlag = DateUtil.compareTime(annualMemberExpireDate, nowday);
            }
        }
        return validFlag;
    }

    public GrowHistory getGrowHistory(long uid, String sourceId, int type) {
        SimpleDateFormat sdfhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        GrowHistory gh = new GrowHistory();
        gh.setUserId(uid);
        gh.setSourceId(sourceId);
        gh.setGrowType(new Integer(type));
        String nowTime = sdfhms.format(new Date());
        gh.setRecordTime(nowTime);
        gh.setDayTime(nowTime.split(" ")[0]);
        return gh;
    }
}

